/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.IubOverAtmManager;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmTrafficDescriptor;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVpcTp;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class VirtualPathRI
extends AbstractResourceItem {
    public static final String name = "NbapDedicatedProtocolStack";
    private static final String[] myPhases = new String[]{"VirtualPathCreationPhase"};
    private String atmId;
    private final String atmTrafficDescriptorId;
    private static final Integer INGRESS_ATM_PCR1 = new Integer(4500);
    private static final Integer EGRESS_ATM_PCR1 = new Integer(4500);
    private static final Integer INGRESS_ATM_QOS1 = new Integer(1);
    private static final Integer EGRESS_ATM_QOS1 = new Integer(1);
    private static final Integer SERVICE_CATEGORY_1 = new Integer(1);
    private Integer externalVpi = new Integer(1);
    private static final String VPL_TP_ID = "vp1";
    private static final String VPC_TP_ID = "1";

    public VirtualPathRI(Rbs rbs, String string) {
        super(name, rbs, myPhases);
        this.atmTrafficDescriptorId = string;
    }

    private void initialiseMois() throws BemException {
        String string = this.rbs.getCustomerParameter("IubNpcTestConfiguration_etbSlot");
        this.atmId = "1-" + string + "-1";
    }

    public void install(String string) throws BemException {
        BemLog.log(3, this.getClass() + ": install() entered");
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            BemLog.log(3, this.getClass() + ": install() into install, phasename is " + string);
            this.initialiseMois();
            BemMo bemMo = this.configureAtmTrafficDescriptor();
            this.configureVplTpTree(bemMo);
        }
    }

    private BemMo configureAtmTrafficDescriptor() throws BemException, BemException {
        BemMo bemMo = null;
        MoInstance moInstance = this.rbs.getMoiRefs().getTransportNetworkMoi();
        String string = moInstance.getLdn() + "," + MimAtmTrafficDescriptor.MOTYPENAME + "=" + this.atmTrafficDescriptorId;
        BemLog.log(3, this.getClass() + ": configureAtmTrafficDescriptor(), ldn is " + string);
        bemMo = this.getMo(string);
        boolean bl = bemMo.isExisting();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        if (!bl) {
            vector.add(Nal.getFactory().getNameValue("ingressAtmPcr", INGRESS_ATM_PCR1));
            vector.add(Nal.getFactory().getNameValue("egressAtmPcr", EGRESS_ATM_PCR1));
            vector.add(Nal.getFactory().getNameValue("ingressAtmQos", INGRESS_ATM_QOS1));
            vector.add(Nal.getFactory().getNameValue("egressAtmQos", EGRESS_ATM_QOS1));
            vector.add(Nal.getFactory().getNameValue("serviceCategory", SERVICE_CATEGORY_1));
            this.create(bemMo, vector);
        }
        return bemMo;
    }

    private void configureVplTpTree(BemMo bemMo) throws BemException {
        String string = IubOverAtmManager.getVplTpLdn(this.atmId, VPL_TP_ID);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("externalVpi", this.externalVpi));
        vector.add(Nal.getFactory().getNameValue("atmTrafficDescriptor", bemMo));
        this.createMoIfNotExisting(string, vector);
        String string2 = string + "," + MimVpcTp.MOTYPENAME + "=" + VPC_TP_ID;
        this.createMoIfNotExisting(string2);
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return name;
    }

    public void setExternalVpi(String string) {
        this.externalVpi = Integer.valueOf(string);
    }
}

