/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DuwXcuResourceManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioBuildingBlockParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.XcuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt.HspaResourcesManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractDuwXcuRadioEquipmentCI
extends GenericRadioEquipmentCI {
    private static final String DUAL_DUW_CONFIGURATION_NOT_SUPPORTED_RESTRICTION = "The type of configuration requires two DUW boards";
    protected EnumeratedRange radioIfTypeRange;
    private int maxNoOfBaseBandPools;
    protected DuwXcuResourceManager duwXcuManager;
    private HspaResourcesManager hspaManager;
    protected int startingSectorNumber;

    public AbstractDuwXcuRadioEquipmentCI(Rbs rbs, int n, int n2, int n3, int n4, boolean bl) {
        super(rbs, n, n2, n3, bl);
        this.maxNoOfBaseBandPools = n4;
        this.startingSectorNumber = 1;
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        this.createDuwXcuResourceManager();
        boolean bl = super.open();
        this.setCpriLineRate();
        this.updateDualDuwRestrictions();
        this.updateEulRestrictions();
        return bl;
    }

    private void createDuwXcuResourceManager() throws BemException {
        this.duwXcuManager = new DuwXcuResourceManager(this.rbs, this.maxNoOfBaseBandPools);
    }

    protected String getBBPoolRadioInterfaceType(int n) {
        return "XCU";
    }

    private int[] getDuwSlotArray() throws BemException {
        int[] nArray = this.rbs.isPantherHybridRbs() && this.startingSectorNumber == 7 ? new int[]{1} : (DuwUtil.hasDualDuws() && !this.rbs.isPantherHybridRbs() ? new int[]{0, 1} : new int[]{0});
        return nArray;
    }

    protected List getRadioInterfaceRIs(int n) {
        List list = this.duwXcuManager.getResourceItems(n);
        return list;
    }

    protected ResourceItem getRadioInterfaceBoardRI(String string, int n) {
        XcuRI xcuRI = this.duwXcuManager.getXcuRI(n);
        return xcuRI;
    }

    protected String getAtfPiuLdn(int n) {
        String string = this.duwXcuManager.getDuwPiuLdn(n);
        return string;
    }

    private void setCpriLineRate() {
        SectorRI[] sectorRIArray = this.getSectors();
        if (sectorRIArray != null) {
            for (int i = 0; i < sectorRIArray.length; ++i) {
                sectorRIArray[i].setLineRate(new Integer(2));
            }
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = super.getNeededRIs();
        return arrayList;
    }

    protected void createRadioInterfaceBoard() {
    }

    protected abstract void initiateCPRanges();

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }

    private void updateDualDuwRestrictions() throws BemException {
        if (!DuwUtil.hasDualDuws()) {
            for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                SectorCapability sectorCapability = this.getSectorCapability(n);
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.add("");
                RadioBuildingBlock[] radioBuildingBlockArray = sectorCapability.getConfigurations();
                for (int j = 0; j < radioBuildingBlockArray.length; ++j) {
                    if (radioBuildingBlockArray[j].isDualRadioInterfaceBoardNeeded()) continue;
                    treeSet.add(radioBuildingBlockArray[j].getName());
                }
                String[] stringArray = new String[treeSet.size()];
                Iterator iterator = treeSet.iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    stringArray[n2] = (String)iterator.next();
                    ++n2;
                }
                EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
                ParameterRestriction parameterRestriction = new ParameterRestriction(DUAL_DUW_CONFIGURATION_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
                RadioBuildingBlockParameter radioBuildingBlockParameter = this.getRadioBuildingBlockParameter(n);
                if (radioBuildingBlockParameter == null) continue;
                radioBuildingBlockParameter.addRestriction(parameterRestriction);
            }
        }
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        if (!DuwUtil.hasDualDuws() && this.isRb4UsedWithDualRadioInterfaceBoard(this.getEquippedSectors())) {
            throw new BemException(DUAL_DUW_CONFIGURATION_NOT_SUPPORTED_RESTRICTION);
        }
    }

    protected void createTxRaxResources() throws BemException {
    }

    protected void createHspaResources() throws BemException {
        this.hspaManager = new HspaResourcesManager(this, this.getDuwSlotArray());
        this.updateHspaLoadedValues();
        this.setHspaParameterRestrictions();
    }

    private void updateHspaLoadedValues() throws BemException {
        this.hspaManager.updateLoadedValues();
    }

    private void setHspaParameterRestrictions() throws BemException {
        this.hspaManager.setParameterRestrictions();
    }

    protected void initRaxCustomerParameters() throws BemException {
    }

    protected void setHspaCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        if (this.hspaManager != null) {
            ArrayList arrayList = this.hspaManager.getAllCpPseudoNames();
            String[] stringArray = arrayList.toArray(new String[0]);
            super.setCustomerParametersFromSV(stringArray, serviceValue);
        }
    }

    protected void updateEulRestrictions() {
        boolean bl = super.eulSupportInTwoBaseBandPools();
        this.hspaManager.setEulSupportInTwoBaseBandPools(bl);
    }

    protected ArrayList getNeededHspaRIs() throws BemException {
        ArrayList arrayList = new ArrayList();
        if (this.hspaManager != null) {
            List list = this.hspaManager.getAllHspaResourceItems();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected ArrayList getNeededRaxTxRIs() throws BemException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    protected List getRaxRIsToUninstall() throws BemException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List getRaxAndTxRIsForBBpool(int n) throws BemException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public int getSumOfHsCodeResources(int n) throws BemException {
        int n2 = 0;
        if (this.hspaManager != null) {
            n2 = this.hspaManager.getSumOfHsCodeResources(n);
        }
        return n2;
    }

    public String[] getSlotArrayForTxDevices(int n) {
        return DuwUtil.getSlotArrayForTxDevices(n);
    }

    protected AtfProvider getAtfProvider() {
        AtfProvider atfProvider = super.getAtfProvider();
        if (atfProvider != null && atfProvider instanceof AtfProviderImpl) {
            AtfProviderImpl atfProviderImpl = (AtfProviderImpl)atfProvider;
            for (int i = 0; i < this.maxNoOfBaseBandPools; ++i) {
                atfProviderImpl.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_XCU_INDEXED_BY_BBPOOL[i + 1], this.getAtfPiuLdn(i));
            }
            return atfProviderImpl;
        }
        return atfProvider;
    }

    public void addListener(HsdpaResourcesListener hsdpaResourcesListener) {
        if (this.hspaManager != null) {
            this.hspaManager.addListener(hsdpaResourcesListener);
        }
    }

    public boolean isTxbStaticallyLoaded(int n) throws BemException {
        return this.hspaManager.isTxbStaticallyLoaded(n);
    }
}

