/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.RbsLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbDynamicMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaDataMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AuxPiuRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTpaDevice;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractRbb {
    public static final String NAME_RBB10_1A = "RBB10_1A";
    public static final String NAME_RBB11_1A = "RBB11_1A";
    public static final String NAME_RBB12_1A = "RBB12_1A";
    public static final String NAME_RBB12_1C = "RBB12_1C";
    public static final String NAME_RBB12_1D = "RBB12_1D";
    public static final String NAME_RBB12_1E = "RBB12_1E";
    public static final String NAME_RBB12_1F = "RBB12_1F";
    public static final String NAME_RBB12_2B = "RBB12_2B";
    public static final String NAME_RBB12_2C = "RBB12_2C";
    public static final String NAME_RBB14_1A = "RBB14_1A";
    public static final String NAME_RBB14_2A = "RBB14_2A";
    public static final String NAME_RBB22_1A = "RBB22_1A";
    public static final String NAME_RBB22_1B = "RBB22_1B";
    public static final String NAME_RBB22_1C = "RBB22_1C";
    public static final String NAME_RBB22_1F = "RBB22_1F";
    public static final String NAME_RBB22_1G = "RBB22_1G";
    public static final String NAME_RBB22_1H = "RBB22_1H";
    public static final String NAME_RBB22_2A = "RBB22_2A";
    public static final String NAME_RBB22_2B = "RBB22_2B";
    public static final String NAME_RBB22_2E = "RBB22_2E";
    public static final String NAME_RBB24_1A = "RBB24_1A";
    public static final String NAME_RBB24_1B = "RBB24_1B";
    public static final String NAME_RBB24_1C = "RBB24_1C";
    public static final String NAME_RBB24_2B = "RBB24_2B";
    public static final String NAME_RBB32_1A = "RBB32_1A";
    public static final String NAME_RBB42_1B = "RBB42_1B";
    public static final String NAME_RBB42_2D = "RBB42_2D";
    public static final String NAME_RBB44_1B = "RBB44_1B";
    public static final String NAME_RBB44_1D = "RBB44_1D";
    public static final String NAME_RBB44_2C = "RBB44_2C";
    public static final String NAME_RBB44_1N = "RBB44_1N";
    public static final String NAME_RBB44_1P = "RBB44_1P";
    public static final String NAME_RBB44_1S = "RBB44_1S";
    public static final String NAME_RBB44_2S = "RBB44_2S";
    public static final String NAME_RBB44_2T = "RBB44_2T";
    public static final String NAME_RBB44_2W = "RBB44_2W";
    public static final int ZERO_DYNAMIC_RU_NUMBER = 0;
    public static final int EMPTY_DYNAMIC_RU_NUMBER = -1;
    public static final int DEFAULT_TPA_INDEX = 1;
    public static final int TPA_INDEX_FOR_THIRD_RBB = 5;
    private static final int NUM_OF_ONE_RU = 1;
    private static final int NUM_OF_TWO_RU = 2;
    private static final int FIRST_RU = 1;
    private static final int SECOND_RU = 2;
    protected static final int DC_ELECTRICAL_DELAY_IS_MEASURED_BY_RBS = -1;
    protected static final String RF_CABLE_OBJECT_A_CONNECTOR_NAME_RXA_IO = "RXA_IO";
    protected static final String RF_CABLE_OBJECT_A_CONNECTOR_NAME_RXA_OUT = "RXA_OUT";
    public static final String FIRST_SECTOR_SEQUENCE_NUMBER = "1";
    protected static final int OBJECTA_CONNECTOR_RXA_IO = 12;
    protected static final int OBJECTB_CONNECTOR_RXB_IO = 22;
    protected static final String HAS_NOT_RUW_SUBRACK_RDN = null;
    protected static final String INTERNAL_SEQUENCE_NUMBER_FIRST_RU = "1";
    protected static final String INTERNAL_SEQUENCE_NUMBER_SECOND_RU = "2";
    protected static final String INTERNAL_SEQUENCE_NUMBER_THIRD_RU = "3";
    public int MAX_TOTAL_POWER_OUTPUT_PER_TPA = MimTpaDevice.MAX_MAXTOTALOUTPUTPOWER[1];
    public int MAX_TOTAL_POWER_OUTPUT_LOW_PER_TPA = MimTpaDevice.MAX_MAXTOTALOUTPUTPOWERLOW[1];
    public int MIN_TOTAL_POWER_OUTPUT_LOW_PER_TPA = MimTpaDevice.MIN_MAXTOTALOUTPUTPOWERLOW[1];
    private RbbDynamicMetaData dynamicMetaData;
    private RbbStaticMetaData staticMetaData;
    protected RbbHandler rbbHandler;
    protected List allRIs = null;
    protected Map radioUnitRIs = null;
    public static final List rbbForRadioShare = Arrays.asList("RBB22_1F", "RBB22_1G", "RBB22_1H", "RBB12_1C", "RBB12_1D", "RBB12_2B", "RBB12_2C", "RBB12_1E", "RBB12_1F", "RBB44_1N", "RBB44_1P", "RBB44_1S", "RBB44_2S", "RBB44_2T", "RBB44_2W");
    public static final List rbbForRadioSharedSecondRbb = Arrays.asList("RBB22_1G", "RBB12_1D", "RBB12_2C", "RBB12_1F", "RBB44_1P", "RBB44_2T");
    public static final List rbbForRadioSharedThirdRbb = Arrays.asList("RBB22_1H", "RBB44_1S", "RBB44_2W");
    public static final Map radioSharedRbbMap = new HashMap(){
        {
            this.put(AbstractRbb.NAME_RBB22_1F, Arrays.asList(AbstractRbb.NAME_RBB22_1G, AbstractRbb.NAME_RBB22_1H));
            this.put(AbstractRbb.NAME_RBB22_1G, Arrays.asList(AbstractRbb.NAME_RBB22_1F, AbstractRbb.NAME_RBB22_1H));
            this.put(AbstractRbb.NAME_RBB22_1H, Arrays.asList(AbstractRbb.NAME_RBB22_1F, AbstractRbb.NAME_RBB22_1G));
            this.put(AbstractRbb.NAME_RBB12_1C, Arrays.asList(AbstractRbb.NAME_RBB12_1D));
            this.put(AbstractRbb.NAME_RBB12_1D, Arrays.asList(AbstractRbb.NAME_RBB12_1C));
            this.put(AbstractRbb.NAME_RBB12_2B, Arrays.asList(AbstractRbb.NAME_RBB12_2C));
            this.put(AbstractRbb.NAME_RBB12_2C, Arrays.asList(AbstractRbb.NAME_RBB12_2B));
            this.put(AbstractRbb.NAME_RBB12_1E, Arrays.asList(AbstractRbb.NAME_RBB12_1F));
            this.put(AbstractRbb.NAME_RBB12_1F, Arrays.asList(AbstractRbb.NAME_RBB12_1E));
            this.put(AbstractRbb.NAME_RBB44_1N, Arrays.asList(AbstractRbb.NAME_RBB44_1P, AbstractRbb.NAME_RBB44_1S));
            this.put(AbstractRbb.NAME_RBB44_1P, Arrays.asList(AbstractRbb.NAME_RBB44_1N, AbstractRbb.NAME_RBB44_1S));
            this.put(AbstractRbb.NAME_RBB44_1S, Arrays.asList(AbstractRbb.NAME_RBB44_1N, AbstractRbb.NAME_RBB44_1P));
            this.put(AbstractRbb.NAME_RBB44_2S, Arrays.asList(AbstractRbb.NAME_RBB44_2T, AbstractRbb.NAME_RBB44_2W));
            this.put(AbstractRbb.NAME_RBB44_2T, Arrays.asList(AbstractRbb.NAME_RBB44_2S, AbstractRbb.NAME_RBB44_2W));
            this.put(AbstractRbb.NAME_RBB44_2W, Arrays.asList(AbstractRbb.NAME_RBB44_2S, AbstractRbb.NAME_RBB44_2T));
        }
    };

    public AbstractRbb(RbbDynamicMetaData rbbDynamicMetaData, RbbStaticMetaData rbbStaticMetaData) throws BemException {
        this.dynamicMetaData = rbbDynamicMetaData;
        this.staticMetaData = rbbStaticMetaData;
        this.allRIs = new ArrayList();
        this.radioUnitRIs = new HashMap();
        this.rbbHandler = new RbbHandler(rbbDynamicMetaData, rbbStaticMetaData);
        this.createRadioUnitRis();
    }

    public String getTerminationObject(String string) throws BemException {
        String string2 = null;
        int n = this.getStaticMetaData().getTerminationConnectorAndObject(string).getTerminationObject();
        int n2 = this.getNumberOfRusForRadioShared();
        if (rbbForRadioShare.contains(this.getName()) && n2 == 0) {
            string2 = this.getAuxPiuLdnOfRadioSharedBySector(string);
        } else {
            if (n > n2) {
                throw new BemException("TerminationConnectorAndObject initialization was wrong in RbbStaticMetaDataMap for radioBuildingBlock: " + this.getName());
            }
            string2 = this.getRadioUnitResourceItems()[n - 1].getAuxPiuLdn();
        }
        return string2;
    }

    public Integer[] getTerminationConnectors(String string) throws BemException {
        return this.staticMetaData.getTerminationConnectorAndObject(string).getTerminationConnector();
    }

    public ResourceItem getRuForSectorCascade(int n) {
        return this.rbbHandler.getRuForSectorCascade(n);
    }

    public Integer getRadioBuildingBlockMomValue() {
        return this.staticMetaData.getMomValueForRbb();
    }

    public String getName() {
        return this.staticMetaData.getRbbName();
    }

    protected Rbs getRbs() {
        return this.dynamicMetaData.getRbs();
    }

    public String getPrimaryPortId() {
        return this.dynamicMetaData.getPrimaryPortId();
    }

    public String getSecondaryPortId() {
        return this.dynamicMetaData.getSecondaryPortId();
    }

    public SectorCustomerParameterManager getSectorCustomerParameterManager() {
        return this.dynamicMetaData.getScpm();
    }

    public String getLineRate() {
        return this.dynamicMetaData.getLineRate();
    }

    public int getSectorNumber() {
        return this.dynamicMetaData.getSectorNumber();
    }

    public int getMaxNumberOfCarriers() {
        return this.staticMetaData.getMaxNumberOfCarriers();
    }

    public int getNumberOfSupportedTxBranches() {
        return this.staticMetaData.getMaxNumberOfSupportedTxBranches();
    }

    public int getNumberOfSupportedRxBranches() {
        return this.staticMetaData.getMaxNumberOfSupportedRxBranches();
    }

    public boolean canBeCascaded() {
        return this.staticMetaData.isCanBeCascaded();
    }

    public boolean canHaveCascadesFollowing() {
        return this.staticMetaData.isCanHaveCascadesFollowing();
    }

    public int getNumberOfCpriLinks() {
        return this.staticMetaData.getNumberOfCpriLinks();
    }

    public int minNumberOfCarriers() {
        return this.staticMetaData.getMinNumberOfCarriers();
    }

    public String getSectorSequence() {
        return this.dynamicMetaData.getSectorSequence();
    }

    protected void createRadioUnitRis() throws BemException {
        throw new BemException("createRadioUnitRis method should be overridden in sub class: " + this.getClass().getName());
    }

    public AbstractRuRI[] getRadioUnitResourceItems() {
        int n = this.getNumberOfRusForRadioShared();
        AbstractRuRI[] abstractRuRIArray = null;
        if (n != 0) {
            abstractRuRIArray = new AbstractRuRI[n];
            for (int i = 1; i <= n; ++i) {
                abstractRuRIArray[i - 1] = (AbstractRuRI)this.radioUnitRIs.get(String.valueOf(i));
            }
        } else {
            try {
                abstractRuRIArray = this.getResourceItemOfRadioSharedBySector();
            }
            catch (Exception exception) {
                BemLog.log(5, "ruRI is not available: " + exception.getMessage());
            }
        }
        return abstractRuRIArray;
    }

    protected abstract List getCableRis(RbbManager var1, String var2) throws BemException;

    public List getLoadedResourceItems() throws BemException {
        Object object;
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnitResourceItems();
        if (abstractRuRIArray == null) {
            return arrayList;
        }
        if (abstractRuRIArray.length == 1 && abstractRuRIArray[0] == null) {
            return null;
        }
        for (int i = 0; i < abstractRuRIArray.length; ++i) {
            arrayList.add(abstractRuRIArray[i]);
        }
        AuxPiuRI auxPiuRI = abstractRuRIArray[0];
        if (auxPiuRI != null) {
            object = this.getLoadedIncomingDigitalCable(auxPiuRI);
            arrayList.add((ResourceItem)object);
        }
        if (this.staticMetaData.getNumberOfCpriLinks() == 2) {
            object = abstractRuRIArray[1];
            ResourceItem resourceItem = this.getLoadedIncomingDigitalCable((AuxPiuRI)object);
            arrayList.add(resourceItem);
        }
        object = this.getInternalDigitalCascadeCableRis();
        arrayList.addAll((Collection<ResourceItem>)object);
        List list = this.getRfCableRis("##UNDEFINED");
        arrayList.addAll(list);
        return arrayList;
    }

    protected List getInternalDigitalCascadeCableRis() throws BemException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    protected List getRfCableRis(String string) throws BemException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private ResourceItem getLoadedIncomingDigitalCable(AuxPiuRI auxPiuRI) throws BemException {
        String string = auxPiuRI.getAuxPiuLdn();
        MoHandler moHandler = this.dynamicMetaData.getRbs().getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        BemMo bemMo2 = RbsLoader.getInstance().getDigitalCableWhereAuxPiuIsObjectB(moHandler, bemMo);
        String string2 = bemMo2.getDN();
        DigitalCableRI digitalCableRI = DigitalCableRI.getDigitalCableRIForDelete(this.dynamicMetaData.getRbs(), string2);
        return digitalCableRI;
    }

    public void verifyThatAllRisAreInstalled(RbbManager rbbManager) throws BemException {
        Rbs rbs = rbbManager.getRbs();
        MoHandler moHandler = rbs.getMoHandler();
        String string = "##UNDEFINED";
        List list = this.getCableRis(rbbManager, string);
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnitResourceItems();
        if (abstractRuRIArray != null) {
            int n;
            for (n = 0; n < abstractRuRIArray.length; ++n) {
                list.add(abstractRuRIArray[n]);
            }
            n = list.size();
            for (int i = 0; i < n; ++i) {
                ResourceItem resourceItem = (ResourceItem)list.get(i);
                String string2 = resourceItem.getLdn();
                BemMo bemMo = moHandler.getMo(string2);
                boolean bl = false;
                try {
                    bl = moHandler.isExisting(bemMo);
                }
                catch (Exception exception) {
                    throw new BemException("Can not access the RBS", (Throwable)exception);
                }
                if (bl) continue;
                throw new BemException("Can not interpret RBB for sector=" + this.dynamicMetaData.getSectorNumber() + ". Resource not installed. LDN =" + string2 + ". Probably due to a faulty configured RBS.");
            }
        }
    }

    public abstract List getResourceItems(RbbManager var1, String var2) throws BemException;

    public boolean supportsTxDiversity() {
        return this.staticMetaData.isSupportTxDiversity();
    }

    public void setResourcItems(AbstractRuRI[] abstractRuRIArray) throws BemException {
        throw new BemException("setResourcItems method need to be overridden in sub class: " + this.getClass().getName());
    }

    public String getAuUnitType() {
        return this.dynamicMetaData.getAuUnitType();
    }

    public String getRadioSharedBySector() {
        return this.dynamicMetaData.getRadioSharedBySector();
    }

    public String getAuxPiuLdnOfRadioSharedBySector(String string) {
        String string2 = null;
        try {
            AbstractRuRI[] abstractRuRIArray = this.getResourceItemOfRadioSharedBySector();
            if (abstractRuRIArray != null) {
                int n = abstractRuRIArray.length;
                if (n == 1) {
                    if (abstractRuRIArray[0].getAuType() == 20) {
                        string2 = abstractRuRIArray[0].getAuxPiuLdn();
                    }
                } else if (n == 2 && abstractRuRIArray[0].getAuType() == 20 && abstractRuRIArray[1].getAuType() == 20) {
                    RbbStaticMetaDataMap.TerminationConnectorAndObject[] terminationConnectorAndObjectArray = this.staticMetaData.getTerminationConnectorAndObject();
                    for (int i = 0; i < terminationConnectorAndObjectArray.length; ++i) {
                        if (terminationConnectorAndObjectArray[i] == null || !string.equals(terminationConnectorAndObjectArray[i].getAntennaBranch())) continue;
                        int n2 = terminationConnectorAndObjectArray[i].getTerminationObject();
                        if (n2 == 1) {
                            string2 = abstractRuRIArray[0].getAuxPiuLdn();
                            continue;
                        }
                        if (n2 != 2) continue;
                        string2 = abstractRuRIArray[1].getAuxPiuLdn();
                    }
                }
            }
        }
        catch (Exception exception) {
            BemLog.log(5, "Radio Ldn is not available: " + exception.getMessage());
        }
        return string2;
    }

    public AbstractRuRI[] getResourceItemOfRadioSharedBySector() throws BemException {
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.getRbs().getProvider(RadioEquipmentProviderWithRbb.class);
        String string = this.getRadioSharedBySector();
        if (string == "") {
            return null;
        }
        return radioEquipmentProviderWithRbb == null ? null : radioEquipmentProviderWithRbb.getSectorRadioUnits(Integer.parseInt(string));
    }

    public String getCabinetNumber() {
        return this.dynamicMetaData.getCabinetNumber();
    }

    public int getNumOfRus() {
        return this.staticMetaData.getNumberOfRuUnits();
    }

    public int getNumberOfRusForRadioShared() {
        int n;
        int n2 = this.getNumOfRus();
        SectorCustomerParameterManager sectorCustomerParameterManager = this.dynamicMetaData.getScpm();
        if (sectorCustomerParameterManager.isSharedSector(sectorCustomerParameterManager.getRbbNameForSector(n = this.dynamicMetaData.getSectorNumber()), n)) {
            n2 = 0;
        }
        return n2;
    }

    public int getMaxPowerOutput() {
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnitResourceItems();
        if (abstractRuRIArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < abstractRuRIArray.length; ++i) {
            n += abstractRuRIArray[i].getTpaDeviceCount();
        }
        return n * this.MAX_TOTAL_POWER_OUTPUT_PER_TPA;
    }

    public int getMaxPowerOutputLow() {
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnitResourceItems();
        if (abstractRuRIArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < abstractRuRIArray.length; ++i) {
            n += abstractRuRIArray[i].getTpaDeviceCount();
        }
        return n * this.MAX_TOTAL_POWER_OUTPUT_LOW_PER_TPA;
    }

    public int getMinPowerOutputLow() {
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnitResourceItems();
        if (abstractRuRIArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < abstractRuRIArray.length; ++i) {
            n += abstractRuRIArray[i].getTpaDeviceCount();
        }
        return n * this.MIN_TOTAL_POWER_OUTPUT_LOW_PER_TPA;
    }

    public int[] getSupportedConfiguration() {
        return this.staticMetaData.getSupportedConfiguration();
    }

    public int[] getNumberOfRxBranchesPerAntenna() {
        return this.staticMetaData.getNumOfRxBranchesPerAntenna();
    }

    public boolean supportsRadioSharedBy() {
        return false;
    }

    public boolean mustConfigRadioSharedBy() {
        return false;
    }

    public RbbStaticMetaData getStaticMetaData() {
        return this.staticMetaData;
    }

    public RbbDynamicMetaData getDynamicMetaData() {
        return this.dynamicMetaData;
    }

    public boolean needRuPositionAllocation() {
        return this.getSectorCustomerParameterManager().needRuPositionAllocation(this.getSectorNumber());
    }

    public boolean getNeedRuPostionAllocationLoadedValue() {
        return this.getSectorCustomerParameterManager().getNeedRuPositionAllocationLoadedValue(this.getSectorNumber());
    }

    public void setRuwPositions(String string, int n, int n2) throws BemException {
        throw new BemException("setRuwPosition method should be overridden in sub class: " + this.getClass().getName());
    }

    public void setCabinetNumberForAux(int n) throws BemException {
        block7: {
            AbstractRuRI[] abstractRuRIArray;
            block6: {
                abstractRuRIArray = this.getRadioUnitResourceItems();
                String string = MessageFormat.format("S{0}_", new Integer(n));
                String string2 = string + "cabinetNumber";
                CustomerParameter customerParameter = this.dynamicMetaData.getRbs().getCustomerParameterObject(string2);
                if (!AuUnitType.isMacroAuUnitType(this.getSectorCustomerParameterManager().getAuUnitTypeForSector(n))) break block6;
                boolean bl = this.dynamicMetaData.getRbs().isParameterSupported(string2);
                boolean bl2 = this.getSectorCustomerParameterManager().isCabinetNumberConfigured(n);
                String string3 = this.getSectorCustomerParameterManager().getCabinetNumberForSector(n);
                if (string3.equals(String.valueOf(0)) && "IRU".equals(this.getSectorCustomerParameterManager().getAuUnitTypeForSector(n))) {
                    string3 = null;
                }
                if (!bl2) {
                    string3 = "1";
                    if (bl) {
                        if (SectorUtil.isIRUInEnclosure(this.dynamicMetaData.getRbs(), n)) {
                            string3 = "0";
                        }
                        customerParameter.setValue(string3);
                    }
                }
                for (int i = 0; i < abstractRuRIArray.length; ++i) {
                    abstractRuRIArray[i].setCabinetNumber(string3);
                }
                break block7;
            }
            if (abstractRuRIArray == null) break block7;
            this.getSectorCustomerParameterManager().clearCabinetNumberValue(n);
            for (int i = 0; i < abstractRuRIArray.length; ++i) {
                abstractRuRIArray[i].setCabinetNumber(null);
            }
        }
    }

    public static int getTpaIndex(String string, AbstractRuRI abstractRuRI) {
        int n = 1;
        if (rbbForRadioSharedSecondRbb.contains(string)) {
            n += abstractRuRI.getTpaDeviceCount();
        } else if (rbbForRadioSharedThirdRbb.contains(string)) {
            n = 5;
        }
        return n;
    }
}

