/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.rbb;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbDynamicMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RruwRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class Rbb441sRruw
extends AbstractRbb {
    private RruwRI rruw1;
    private RruwRI rruw2;
    private static final int TPA_DEVICE_NUMBER = 2;

    public Rbb441sRruw(RbbDynamicMetaData rbbDynamicMetaData, RbbStaticMetaData rbbStaticMetaData) throws BemException {
        super(rbbDynamicMetaData, rbbStaticMetaData);
    }

    protected void createRadioUnitRis() {
        if (this.getNumberOfRusForRadioShared() != 0) {
            int n = this.getDynamicMetaData().getSectorNumber();
            String string = this.getDynamicMetaData().getAtfNameManager().getAtfRole(n);
            int n2 = Integer.valueOf("1");
            this.rruw1 = new RruwRI(super.getRbs(), string, 2, n, n2, true);
            int n3 = Integer.valueOf("2");
            this.rruw2 = new RruwRI(super.getRbs(), string, 2, n, n3, true);
        } else {
            try {
                AbstractRuRI[] abstractRuRIArray = this.getResourceItemOfRadioSharedBySector();
                this.rruw1 = (RruwRI)abstractRuRIArray[0];
                this.rruw2 = (RruwRI)abstractRuRIArray[1];
            }
            catch (Exception exception) {
                BemLog.log(5, "Failed to get RU RI from radioSharedBy sector of RBB44_1S.");
            }
        }
        this.allRIs.add(this.rruw1);
        this.allRIs.add(this.rruw2);
        this.radioUnitRIs.put("1", this.rruw1);
        this.radioUnitRIs.put("2", this.rruw2);
        this.rbbHandler.setRuForSectorCascade(1, this.rruw1);
    }

    public List getResourceItems(RbbManager rbbManager, String string) throws BemException {
        List list = this.getCableRis(rbbManager, string);
        this.allRIs.addAll(list);
        return this.allRIs;
    }

    protected List getCableRis(RbbManager rbbManager, String string) throws BemException {
        List list = this.createDigitalCables(rbbManager);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        return arrayList;
    }

    private List createDigitalCables(RbbManager rbbManager) throws BemException {
        ArrayList<DigitalCableRI> arrayList = new ArrayList<DigitalCableRI>();
        if (this.getNumberOfRusForRadioShared() != 0) {
            DigitalCableRI digitalCableRI = this.rbbHandler.createIncomingDigitalCable(rbbManager, 1, this.rruw1);
            List list = this.getInternalDigitalCascadeCableRis();
            arrayList.add(digitalCableRI);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected List getInternalDigitalCascadeCableRis() throws BemException {
        ArrayList<DigitalCableRI> arrayList = new ArrayList<DigitalCableRI>();
        int n = Integer.valueOf("1");
        DigitalCableRI digitalCableRI = this.rbbHandler.createInternalCascadeDigitalCable(this.rruw1, this.rruw2, n);
        arrayList.add(digitalCableRI);
        return arrayList;
    }

    public boolean supportsRadioSharedBy() {
        return true;
    }

    public void setResourcItems(AbstractRuRI[] abstractRuRIArray) {
        this.radioUnitRIs.put("1", (RruwRI)abstractRuRIArray[0]);
        this.radioUnitRIs.put("2", (RruwRI)abstractRuRIArray[1]);
    }
}

