/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RB1B
extends AbstractRadioBuildingBlock {
    public static final String name = "RB1B";
    private static final int NO_OF_CARRIERS = 1;
    private static final int NO_OF_RUS = 0;
    private static final int NO_OF_TX_BRANCHES = 1;
    private Rbs rbs;
    private List ris = new ArrayList();
    private DigitalCableRI digitalCable = null;
    private RuwRI ruw = null;
    private int dcElectricalDelay;
    List freeConnectors;
    ReservedConnectorRI[] reservedConnectors;

    public RB1B(Rbs rbs, int n, RuwRI ruwRI, RadioInterfaceBoard radioInterfaceBoard, int n2) throws BemException {
        super(name, n, 1, 0, 1, new RadioInterfaceBoard[]{radioInterfaceBoard});
        this.rbs = rbs;
        this.ruw = ruwRI;
        this.dcElectricalDelay = n2;
        this.createResourceItems(radioInterfaceBoard);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        this.reservedConnectors = new ReservedConnectorRI[6];
        this.reservedConnectors[0] = reservedConnectorRI6;
        this.reservedConnectors[1] = reservedConnectorRI4;
        this.reservedConnectors[2] = reservedConnectorRI2;
        this.reservedConnectors[3] = reservedConnectorRI5;
        this.reservedConnectors[4] = reservedConnectorRI3;
        this.reservedConnectors[5] = reservedConnectorRI;
    }

    private void createResourceItems(RadioInterfaceBoard radioInterfaceBoard) throws BemException {
        this.ris.add(this.ruw);
        this.freeConnectors = new ArrayList();
        String string = this.ruw.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 2, MimDigitalCable.MOTYPENAME, "objectBConnector"));
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 13, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 12, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 14, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.digitalCable = new DigitalCableRI(this.rbs, radioInterfaceBoard.getLdn(), this.getDigitalCableConnectorA(), this.ruw.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable);
    }

    public List getResourceItems() throws BemException {
        this.ruw.setSecondAiLocked(false);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ruw);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA() throws BemException {
        int n = 0;
        int n2 = this.getSectorNo();
        int[] nArray = new int[]{6, 4, 2, 5, 3, 1};
        n = nArray[n2 - 1];
        return n;
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (string.equalsIgnoreCase("A")) {
            n = new Integer(1);
        } else if (string.equalsIgnoreCase("B")) {
            n = new Integer(2);
        } else {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        return this.ruw.getAuxPiuLdn();
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    public int getNoOfRuws() {
        return 1;
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ruw.getSlotNumber(), new int[]{0}));
        return arrayList;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }
}

