/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.StringTokenizer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;

public class DNSRange
implements ParameterRange {
    public boolean equals(ParameterRange parameterRange) {
        return parameterRange instanceof DNSRange;
    }

    public String getDescription() {
        return "DNS Address Range permits [A to Z], [a to z], [0 to 9], the dot (.) and the hyphen (-). IP Address Range [0.0.0.0 - 255.255.255.255]";
    }

    public boolean isValueInRange(Object object) {
        int n;
        String string = (String)object;
        boolean bl = false;
        for (n = 0; n < string.length() && !bl; ++n) {
            bl = Character.isLetter(string.charAt(n));
        }
        if (!bl) {
            return this.isValidIPAddress(object);
        }
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '.') continue;
            if (c != '-' || n == 0 || n == string.length() - 1) {
                return false;
            }
            if (string.charAt(n - 1) != '.' && string.charAt(n + 1) != '.') continue;
            return false;
        }
        return true;
    }

    public boolean isValidIPAddress(Object object) {
        String string = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() == 7 && this.isValidIpPart(stringTokenizer.nextToken())) {
            stringTokenizer.nextToken();
            if (this.isValidIpPart(stringTokenizer.nextToken())) {
                stringTokenizer.nextToken();
                if (this.isValidIpPart(stringTokenizer.nextToken())) {
                    stringTokenizer.nextToken();
                    if (this.isValidIpPart(stringTokenizer.nextToken())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isValidIpPart(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 0 && n <= 255;
    }

    public ParameterRange copyAndRetainRange(ParameterRange parameterRange) {
        return new DNSRange();
    }

    public ParameterRange copyAndRemove(ParameterRange parameterRange) {
        return new DNSRange();
    }
}

