/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3967.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.BaseBandPoolData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet1;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet2;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB1;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB3;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4b;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB6;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB7;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB8;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.DiscBranchBReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.UninitSectorReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuifDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;

public class RadioEquipment3967CI
extends GenericRadioEquipmentCI {
    private static final int MAX_NO_OF_SECTORS = 6;
    private static final int MAX_NO_OF_RUS = 2;
    private static final int MAX_NO_OF_CARRIERS = 4;
    private ReservedConnectorRI[] a = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] b = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] c = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] d = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] e = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] f = new ReservedConnectorRI[2];
    private EnumeratedRange radioIfTypeRange;

    public RadioEquipment3967CI(Rbs rbs) {
        super(rbs, 6, 2, 4, false);
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"10", "11", "14", "15"});
        this.setBoardPositions(MimRuifDeviceGroup.MOTYPENAME, new String[]{"12", "13"});
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"4", "5", "6", "7", "8", "9", "16", "17", "18", "19", "20", "21"});
        BaseBandPoolData baseBandPoolData = new BaseBandPoolData(13, 4);
        super.setBaseBandPoolData(baseBandPoolData);
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createRadioBuildingBlocks() throws BemException {
        int n = this.getMaxNoOfSectors();
        this.radioBuildingBlocks = new RadioBuildingBlock[n];
        this.createReservedConnectors();
        for (int i = 1; i <= n; ++i) {
            Reconfiguration[] reconfigurationArray;
            Object object;
            SectorCapability sectorCapability = new SectorCapability();
            int n2 = 2 * i;
            if (i > 3) {
                n2 = 2 * (i - 3) + 1;
            }
            RuRI ruRI = this.ruSubrack.getSlot(n2);
            FuRI fuRI = this.fuSubrack.getSlot(n2);
            RB1 rB1 = new RB1(this.rbs, i, fuRI, ruRI, this.ruif[0], 60, 0, 0, 0, 0);
            RB4 rB4 = new RB4(this.rbs, i, fuRI, ruRI, this.ruif[0], 60, 0, 0, 0, 0);
            RB4b rB4b = new RB4b(this.rbs, i, fuRI, ruRI, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
            rB1.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            rB4.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            rB4b.setRadioIfConnectors(this.a[1], this.b[0], this.c[1], this.d[0], this.e[1], this.f[0]);
            if (i <= 3) {
                object = this.ruSubrack.getSlot(n2 + 1);
                reconfigurationArray = this.fuSubrack.getSlot(n2 + 1);
                RB3 rB3 = new RB3(this.rbs, i, fuRI, (FuRI)reconfigurationArray, ruRI, (RuRI)object, this.ruif[0], 60, 0, 0, 0, 0);
                RB6 rB6 = new RB6(this.rbs, i, fuRI, (FuRI)reconfigurationArray, ruRI, (RuRI)object, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                RB7 rB7 = new RB7(this.rbs, i, fuRI, (FuRI)reconfigurationArray, ruRI, (RuRI)object, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                RB8 rB8 = new RB8(this.rbs, i, fuRI, (FuRI)reconfigurationArray, ruRI, (RuRI)object, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                rB3.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                rB6.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                rB7.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                rB8.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                Reconfiguration[] reconfigurationArray2 = new Reconfiguration[]{new DiscBranchBReconfiguration(this.getRbs(), rB1, rB3, i), new UninitSectorReconfiguration(this.getRbs(), rB1, rB4, i), new UninitSectorReconfiguration(this.getRbs(), rB1, rB4b, i), new UninitSectorReconfiguration(this.getRbs(), rB1, rB6, i), new UninitSectorReconfiguration(this.getRbs(), rB1, rB7, i), new UninitSectorReconfiguration(this.getRbs(), rB1, rB8, i)};
                Reconfiguration[] reconfigurationArray3 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB3, rB6, i), new UninitSectorReconfiguration(this.getRbs(), rB3, rB7, i), new UninitSectorReconfiguration(this.getRbs(), rB3, rB8, i)};
                Reconfiguration[] reconfigurationArray4 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB4, rB6, i), new DiscBranchBReconfiguration(this.getRbs(), rB4, rB7, i)};
                Reconfiguration[] reconfigurationArray5 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB4b, rB6, i), new DiscBranchBReconfiguration(this.getRbs(), rB4b, rB7, i)};
                Reconfiguration[] reconfigurationArray6 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB7, rB6, i)};
                Reconfiguration[] reconfigurationArray7 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB8, rB6, i)};
                sectorCapability.addConfiguration(rB1, reconfigurationArray2);
                sectorCapability.addConfiguration(rB4, reconfigurationArray4);
                sectorCapability.addConfiguration(rB4b, reconfigurationArray5);
                sectorCapability.addConfiguration(rB3, reconfigurationArray3);
                sectorCapability.addConfiguration(rB6);
                sectorCapability.addConfiguration(rB7, reconfigurationArray6);
                sectorCapability.addConfiguration(rB8, reconfigurationArray7);
            } else {
                object = new RB4b(this.rbs, i, fuRI, ruRI, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                ((RB4b)object).setRadioIfConnectors(this.a[0], this.b[1], this.c[0], this.d[1], this.e[0], this.f[1]);
                reconfigurationArray = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB1, (RadioBuildingBlock)object, i), new UninitSectorReconfiguration(this.getRbs(), rB1, rB4, i)};
                sectorCapability.addConfiguration(rB1, reconfigurationArray);
                sectorCapability.addConfiguration((RadioBuildingBlock)object);
                sectorCapability.addConfiguration(rB4);
            }
            this.addSectorCapability(i, sectorCapability);
        }
    }

    protected void createRadioInterfaceBoard() {
        this.ruif[0] = new RuifRI(this.rbs, 12, this.hubSubrackMoi);
        this.ruif[1] = new RuifRI(this.rbs, 13, this.hubSubrackMoi);
    }

    protected void createSubracks() throws BemException {
        this.ruSubrack = new RuSubrackRI(this.rbs, 7, "2", "2B2");
        this.fuSubrack = new FuSubrackRI(this.rbs, 7, "2", "2A2");
    }

    protected RbsCableSets getRbsCableSets() {
        RbsCableSets rbsCableSets = new RbsCableSets();
        rbsCableSets.addCableSet("RB1", new CableSet1());
        rbsCableSets.addCableSet("RB4", new CableSet1());
        rbsCableSets.addCableSet("RB4b", new CableSet1());
        rbsCableSets.addCableSet("RB3", new CableSet2());
        rbsCableSets.addCableSet("RB6", new CableSet2());
        rbsCableSets.addCableSet("RB7", new CableSet2());
        rbsCableSets.addCableSet("RB8", new CableSet2());
        return rbsCableSets;
    }

    private void createReservedConnectors() {
        String string = MimDigitalCable.MOTYPENAME;
        String string2 = "objectAConnector";
        for (int i = 0; i <= 1; ++i) {
            this.a[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 1, string, string2);
            this.b[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 2, string, string2);
            this.c[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 3, string, string2);
            this.d[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 4, string, string2);
            this.e[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 5, string, string2);
            this.f[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 6, string, string2);
        }
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RUIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

