/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.util;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSecurity;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class WebServerUtil {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static int webServerMode = 0;

    public static boolean isHttps() {
        return webServerMode == 1;
    }

    public static void setDefaultHostnameVerifier() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return string.equals(sSLSession.getPeerHost());
            }
        });
    }

    public static void updateWebSeverMode() {
        try {
            NalMo nalMo = Nal.getFactory().getMo(BemLdn.LDN_SECURITY);
            if (nalMo.exists(null)) {
                NalNameValue nalNameValue = nalMo.getAttribute("webServer", null);
                Integer n = (Integer)nalNameValue.getValue();
                webServerMode = n;
                BemLog.log(6, "successfully read attribute webServer, value=" + webServerMode);
            } else {
                BemLog.log(3, "MO " + BemLdn.LDN_SECURITY + " does not exist on RBS. Setting security to FALSE.");
                webServerMode = 0;
            }
        }
        catch (Throwable throwable) {
            BemLog.log(2, "failed reading attribute webServer on MO " + MimSecurity.MOTYPENAME);
            webServerMode = 0;
        }
    }

    public static String getUrlPref() {
        String string = null;
        WebServerUtil.updateWebSeverMode();
        if (webServerMode == 1) {
            string = HTTPS_PREFIX;
            WebServerUtil.setDefaultHostnameVerifier();
        } else {
            string = HTTP_PREFIX;
        }
        return string;
    }
}

