/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import se.ericsson.cello.neal.CelloNodeConfig;
import se.ericsson.cello.neal.CppOamException;
import se.ericsson.cello.neal.HttpClient;
import se.ericsson.cello.neal.HttpsClient;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeConnectionEvent;
import se.ericsson.cello.neal.NodeConnectionListener;
import se.ericsson.cello.neal.Poller;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmServiceFactory;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.cello.neal.fm.FmServiceFactory;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.NealOrb;
import se.ericsson.cello.neal.internal.OamServiceFactory;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.ServiceContextImpl;
import se.ericsson.cello.neal.internal.orb_version.NealOrbDefaultFactory;
import se.ericsson.cello.neal.pi.PiService;
import se.ericsson.cello.neal.pi.PiServiceFactory;
import se.ericsson.cello.neal.pm.PmService;
import se.ericsson.cello.neal.pm.PmServiceFactory;

class CelloNode
implements Node {
    private static final String SECURITY_FILE = "/cello/corbasecurity";
    private int oldSecurityState = 0;
    private static final String SECURITY_PROPERTY = "CorbaSecurity";
    private static final String CELLO_SECURITY_STATE = "CelloSecurityState";
    private static final String NEAL_ORB_REUSE = "neal.orb.reuse";
    private static final String NEAL_ORB_SHUTDOWN = "neal.orb.shutdown";
    private ServiceContext serviceContext;
    private String nodeNsIorString;
    private String webServerUrl;
    private String hostname;
    Boolean isOrbSecure;
    Boolean isNodeSecure;
    private OamServiceFactory cmServiceFactory = new CmServiceFactory();
    private OamServiceFactory piServiceFactory = new PiServiceFactory();
    private OamServiceFactory pmServiceFactory = new PmServiceFactory();
    private OamServiceFactory fmServiceFactory = new FmServiceFactory();
    private OamServiceFactory[] oamServiceFactories = new OamServiceFactory[]{this.cmServiceFactory, this.pmServiceFactory, this.piServiceFactory, this.fmServiceFactory};
    private Thread pollerThread;
    List connectionListeners;
    private boolean nodeAccessable = true;
    private boolean allServicesRequired = true;

    CelloNode(CelloNodeConfig celloNodeConfig) throws IOException {
        this.serviceContext = ServiceContextImpl.create();
        this.nodeNsIorString = celloNodeConfig.getNsIorString();
        this.webServerUrl = celloNodeConfig.getWebServerUrl();
        this.hostname = celloNodeConfig.getHostname();
        this.allServicesRequired = celloNodeConfig.isAllServicesRequired();
        this.connectionListeners = new ArrayList(5);
        NealLog.fine("Reading security state from the node");
        this.isNodeSecure = this.readSecurityStateFromNode(this.getWebServerURL(false));
        if (this.isNodeSecure == null) {
            NealLog.fine("HTTP Connection Failed. Trying HTTPS Connection");
            this.isNodeSecure = this.readSecurityStateFromNodeUsingHttps(this.getWebServerURL(true));
        }
        this.setSecurity(this.isCorbaSecurityPropertyOn());
        NealOrb nealOrb = null;
        if (celloNodeConfig.getOrb() != null) {
            NealOrb.setDefaultOrbAndPoa(celloNodeConfig.getOrb(), celloNodeConfig.getSecurePoa(), celloNodeConfig.getUnsecurePoa());
            nealOrb = new NealOrb(celloNodeConfig.getOrb(), celloNodeConfig.getSecurePoa(), celloNodeConfig.getUnsecurePoa());
            NealLog.fine("Setting external ORB and POA as default NealOrb");
            NealOrbDefaultFactory.setExternalNealOrb(nealOrb);
        } else {
            nealOrb = NealOrb.createDefaultNealOrb();
            String string = celloNodeConfig.getAuditIdentity();
            if (string == null) {
                NealLog.finest("Auditidenity is null. Failed to set auditidentity");
            } else if (!nealOrb.isOrbSecure()) {
                NealLog.finest("Orb is not secure. Failed to set auditidentity.");
            } else {
                nealOrb.setAuditIdenity(string);
            }
        }
        this.init(nealOrb);
    }

    CelloNode() {
    }

    void setSecurity(Boolean bl) {
        this.isOrbSecure = bl;
        if (bl != null) {
            NealOrbDefaultFactory.setSecurityState(bl);
        }
    }

    private void init(NealOrb nealOrb) {
        String string = "resolve the Remote Naming Service from IOR";
        try {
            boolean bl;
            Object object = nealOrb.string_to_object(this.nodeNsIorString);
            NamingContext namingContext = NamingContextHelper.narrow((Object)object);
            string = "initialize the interfaces to the O&M Services on the CPP node";
            this.serviceContext.init(this, nealOrb, namingContext, this.allServicesRequired);
            for (bl = false; bl < this.oamServiceFactories.length; bl += 1) {
                this.oamServiceFactories[bl].create(this.serviceContext);
            }
            if (this.hostname == null) {
                string = "extract hostname from NameService IOR";
                this.hostname = nealOrb.getHostname(this.nodeNsIorString);
            }
            string = "determine the security state of the connected node";
            bl = this.isOrbSecure != null ? this.isOrbSecure.booleanValue() : this.isSecure();
            nealOrb.useSecure(bl);
            NealLog.fine("Node " + (this.hostname == null ? "" : this.hostname + " ") + "is " + (this.isSecure() ? "" : "Not ") + "Secure");
        }
        catch (UserException userException) {
            CppOamException cppOamException = new CppOamException(userException);
            NealLog.fine("Failed initializing Node!\n  Failed to " + string + ".", cppOamException);
            throw cppOamException;
        }
        catch (RuntimeException runtimeException) {
            NealLog.fine("Failed initializing Node!\n  Failed to " + string + ".", runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            NealLog.fine("Failed initializing Node!\n  Failed to " + string + ".", error);
            throw error;
        }
    }

    public void init() {
        this.init(this.serviceContext.getNealOrb());
    }

    public synchronized void free() {
        if (this.serviceContext != null) {
            for (int i = 0; i < this.oamServiceFactories.length; ++i) {
                this.oamServiceFactories[i].get().free();
            }
            this.serviceContext.free();
            this.serviceContext = null;
        }
        if (this.pollerThread != null) {
            Thread thread = this.pollerThread;
            this.pollerThread = null;
            thread.interrupt();
        }
        if (System.getProperty(NEAL_ORB_SHUTDOWN, "false").equalsIgnoreCase("true")) {
            NealOrbDefaultFactory.instance().shutdownOrb();
        }
        if (System.getProperty(NEAL_ORB_REUSE, "false").equalsIgnoreCase("true") && !System.getProperty(NEAL_ORB_SHUTDOWN, "false").equalsIgnoreCase("true")) {
            NealLog.fine("Keeping neal ORB instance");
        } else {
            NealLog.fine("Resetting neal ORB instance");
            NealOrbDefaultFactory.free();
        }
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    String getHostname() {
        return this.hostname;
    }

    public boolean isSecure() {
        if (this.isNodeSecure == null) {
            this.isNodeSecure = this.serviceContext.isCmServiceSecure();
        }
        if (this.isNodeSecure == null) {
            NealLog.fine("Unable to determin CorbaSecurity state for CmService on Node using IOR.\n   Resorting to unreliable download of CorbaSecurity property from\n   Node web server at " + this.getWebServerURL(false));
            this.isNodeSecure = this.readSecurityStateFromNode(this.getWebServerURL(false));
            if (this.isNodeSecure == null) {
                NealLog.fine("HTTP Connection Failed. Trying HTTPS Connection");
                this.isNodeSecure = this.readSecurityStateFromNodeUsingHttps(this.getWebServerURL(true));
            }
        }
        if (this.isNodeSecure == null) {
            NealLog.fine("Unable to determin CorbaSecurity state for CmService on Node using file on web server.\n   Examining Secure POA.");
            if (!this.serviceContext.getNealOrb().isOrbSecure()) {
                this.isNodeSecure = Boolean.FALSE;
            }
        }
        if (this.isNodeSecure == null) {
            NealLog.warning("Unable to determin CorbaSecurityState of connected Node" + (this.hostname != null ? " " + this.hostname : "") + ".\n   Assuming CorbaSecurity=OFF.");
            this.isNodeSecure = Boolean.FALSE;
        }
        return this.isNodeSecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean readSecurityStateFromNode(String string) {
        Boolean bl = null;
        if (string == null) {
            return bl;
        }
        HttpClient httpClient = null;
        URL uRL = null;
        try {
            uRL = new URL(string + SECURITY_FILE);
            Properties properties = new Properties();
            httpClient = new HttpClient(uRL);
            properties.load(httpClient.getInputStream());
            String string2 = properties.getProperty(SECURITY_PROPERTY);
            if (string2 == null) {
                NealLog.fine("Failed to read property CorbaSecurity\n   from URL=" + uRL + "!");
                bl = null;
            } else {
                NealLog.fine("CelloSecurityState on the node is " + string2);
                bl = "ON".equalsIgnoreCase(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            NealLog.warning("Failed to construct URL to read the property CorbaSecurity\n   from \"" + string + SECURITY_FILE);
        }
        catch (IOException iOException) {
            NealLog.fine(iOException.getMessage());
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return bl;
    }

    Boolean isCorbaSecurityPropertyOn() {
        if (System.getProperty(CELLO_SECURITY_STATE) != null) {
            NealLog.info("Using Orb security state defined by user");
            return "ON".equals(System.getProperty(CELLO_SECURITY_STATE));
        }
        NealLog.info("Using Orb security state from the node ");
        return this.isNodeSecure;
    }

    public synchronized FmService getFmService() {
        return (FmService)((java.lang.Object)this.fmServiceFactory.get());
    }

    public synchronized PmService getPmService() {
        return (PmService)((java.lang.Object)this.pmServiceFactory.get());
    }

    public synchronized PiService getPiService() {
        return (PiService)((java.lang.Object)this.piServiceFactory.get());
    }

    public synchronized CmService getCmService() {
        return (CmService)((java.lang.Object)this.cmServiceFactory.get());
    }

    public synchronized String getWebServerURL(boolean bl) {
        if (!bl) {
            if (this.hostname != null) {
                this.webServerUrl = System.getProperty("SIM", "false").equalsIgnoreCase("true") ? "http://" + this.hostname + ":8080" : "http://" + this.hostname + ":80";
            }
        } else if (this.hostname != null) {
            this.webServerUrl = System.getProperty("SIM", "false").equalsIgnoreCase("true") ? "https://" + this.hostname + ":8443" : "https://" + this.hostname + ":443";
        }
        return this.webServerUrl;
    }

    public synchronized void addConnectionListener(NodeConnectionListener nodeConnectionListener) {
        this.connectionListeners.add(nodeConnectionListener);
        if (this.connectionListeners.size() == 1) {
            this.pollerThread = new Thread((Runnable)new Poller(this), "NodePoller" + this);
            this.pollerThread.setDaemon(true);
            this.pollerThread.start();
        }
    }

    public synchronized void removeConnectionListener(NodeConnectionListener nodeConnectionListener) {
        this.connectionListeners.remove(nodeConnectionListener);
        if (this.connectionListeners.size() == 0) {
            this.pollerThread = null;
        }
    }

    public NealOrb getNealOrb() {
        return this.serviceContext.getNealOrb();
    }

    private synchronized void fireNealConnectionEvent(int n) {
        NealLog.fine("fireNealConnectionEvent " + n);
        NodeConnectionEvent nodeConnectionEvent = new NodeConnectionEvent(this, n);
        NodeConnectionListener[] nodeConnectionListenerArray = new NodeConnectionListener[this.connectionListeners.size()];
        Iterator iterator = this.connectionListeners.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            nodeConnectionListenerArray[n2] = (NodeConnectionListener)iterator.next();
            ++n2;
        }
        for (int i = 0; i < nodeConnectionListenerArray.length; ++i) {
            if (n == 1) {
                nodeConnectionListenerArray[i].connectionLost(nodeConnectionEvent);
                continue;
            }
            if (n == 2) {
                nodeConnectionListenerArray[i].connectionRestored(nodeConnectionEvent);
                continue;
            }
            if (n != 3) continue;
            nodeConnectionListenerArray[i].connectionRestored(nodeConnectionEvent);
        }
    }

    synchronized void setNodeAccessable(boolean bl, int n) {
        try {
            if (this.nodeAccessable) {
                if (!bl) {
                    this.fireNealConnectionEvent(1);
                    this.saveOldSecState();
                    this.nodeAccessable = bl;
                }
            } else if (bl) {
                this.fireNealConnectionEvent(2);
                this.nodeAccessable = bl;
            } else if (n != 0 && n != this.oldSecurityState) {
                this.fireNealConnectionEvent(3);
                this.nodeAccessable = bl;
            }
        }
        catch (Exception exception) {
            NealLog.fine("Failed to set node Accessibility" + exception);
            this.nodeAccessable = false;
        }
    }

    void saveOldSecState() {
        this.oldSecurityState = this.isNodeSecure == null ? 0 : (this.isNodeSecure != false ? 2 : 1);
    }

    String getIOR() {
        return this.nodeNsIorString;
    }

    Thread getPollerThread() {
        return this.pollerThread;
    }

    public String toString() {
        return this.nodeNsIorString;
    }

    public boolean equals(java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            CelloNode celloNode = (CelloNode)object;
            return this.getIOR().equals(celloNode.getIOR());
        }
        return false;
    }

    public int hashCode() {
        return this.getIOR().hashCode();
    }

    public int compareTo(java.lang.Object object) {
        CelloNode celloNode = (CelloNode)object;
        if (this == celloNode) {
            return 0;
        }
        if (this.getIOR().equals(celloNode.getIOR())) {
            return 0;
        }
        return this.getIOR().compareTo(celloNode.getIOR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean readSecurityStateFromNodeUsingHttps(String string) {
        Boolean bl = null;
        if (string == null) {
            return bl;
        }
        HttpsClient httpsClient = null;
        URL uRL = null;
        try {
            uRL = new URL(string + SECURITY_FILE);
            Properties properties = new Properties();
            httpsClient = new HttpsClient(uRL);
            properties.load(httpsClient.getInputStream());
            String string2 = properties.getProperty(SECURITY_PROPERTY);
            if (string2 == null) {
                NealLog.fine("Failed to read property CorbaSecurity\n   from URL=" + uRL + "!");
                bl = null;
            } else {
                NealLog.fine("CelloSecurityState on the node is " + string2);
                bl = "ON".equalsIgnoreCase(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            NealLog.warning("Failed to construct URL to read the property CorbaSecurity\n   from \"" + string + SECURITY_FILE);
        }
        catch (IOException iOException) {
            NealLog.fine(iOException.getMessage());
        }
        finally {
            if (httpsClient != null) {
                httpsClient.close();
            }
        }
        return bl;
    }
}

