/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.neal.cm.CelloNameValue;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.internal.ServiceContext;

class NameValueCache {
    private Map attributeCache = new HashMap();

    NameValueCache() {
    }

    public void reset() {
        this.attributeCache.clear();
    }

    void update(BasicConfig.NameValue[] nameValueArray, ServiceContext serviceContext) {
        NameValue[] nameValueArray2 = new CelloNameValue[nameValueArray.length];
        for (int i = 0; i < nameValueArray2.length; ++i) {
            nameValueArray2[i] = new CelloNameValue(nameValueArray[i], serviceContext);
        }
        this.update(nameValueArray2);
    }

    boolean exists(String[] stringArray) {
        if (this.attributeCache.size() < stringArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.pick(stringArray[i]) != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.attributeCache.size() == 0) {
            return "  <Cache is empty>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.attributeCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("  ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(this.attributeCache.get(string));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    NameValue pick(String string) {
        return (NameValue)this.attributeCache.get(string);
    }

    NameValue[] pick(String[] stringArray) {
        NameValue[] nameValueArray = new NameValue[stringArray.length];
        for (int i = 0; i < nameValueArray.length; ++i) {
            nameValueArray[i] = this.pick(stringArray[i]);
        }
        return nameValueArray;
    }

    void update(NameValue[] nameValueArray) {
        for (int i = 0; i < nameValueArray.length; ++i) {
            this.attributeCache.put(nameValueArray[i].getName(), nameValueArray[i]);
        }
    }
}

