/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.RSACipher;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.ConnectionState;
import com.ibm.j9.ssl.HandshakeMessage;
import com.ibm.j9.ssl.HandshakeSocket;
import com.ibm.j9.ssl.HashingAlgorithmMD5;
import com.ibm.j9.ssl.HashingAlgorithmSHA1;
import com.ibm.j9.ssl.J9DefaultSSLContext;
import com.ibm.j9.ssl.J9HandshakeException;
import com.ibm.j9.ssl.J9ProtocolException;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.SessionState;
import com.ibm.j9.ssl.StreamQueue;
import com.ibm.j9.ssl.Util;
import com.ibm.oti.crypto.DigestOutputStream;
import com.ibm.oti.crypto.Key;
import com.ibm.oti.crypto.MD5OutputStream;
import com.ibm.oti.crypto.Provider;
import com.ibm.oti.crypto.SHAOutputStream;
import com.ibm.oti.security.provider.PKCS1;
import com.ibm.oti.security.provider.RSAPrivateKey;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.security.provider.X509CertImpl;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;

public class HandshakeHandler {
    private static final int TWO_BYTE_LENGTH = 2;
    private static final int THREE_BYTE_LENGTH = 3;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int SIZE = 2;
    private static final byte[] SSL_CLIENT_FINISHED_LABEL = new byte[]{67, 76, 78, 84};
    private static final byte[] SSL_SERVER_FINISHED_LABEL = new byte[]{83, 82, 86, 82};
    private static final String TLS_CLIENT_FINISHED_LABEL = "client finished";
    private static final String TLS_SERVER_FINISHED_LABEL = "server finished";
    private HandshakeSocket socket;
    private J9SSLContext context;
    private StreamQueue inputQueue;
    boolean isHandshaking;
    boolean handShakeCompleted;
    private byte[] pre_master_secret;
    private com.ibm.oti.security.provider.RSAPublicKey tempKey;
    private boolean resumeSession;
    private SHAOutputStream shaMessageHash = new SHAOutputStream();
    private MD5OutputStream md5MessageHash = new MD5OutputStream();
    private ConnectionState connectionState;
    private boolean clientCertificateRequested;
    private boolean clientCertificateVerified;
    private String clientAlias;
    private String serverAlias;
    static final boolean DEBUG = false;
    static long DEBUG_TIME;

    public HandshakeHandler(HandshakeSocket socket) {
        this.socket = socket;
        this.context = new J9DefaultSSLContext();
    }

    public HandshakeHandler(HandshakeSocket socket, J9SSLContext context) {
        this.socket = socket;
        this.context = context;
    }

    public boolean isHandShakeCompleted() {
        return this.handShakeCompleted;
    }

    public boolean isHandshaking() {
        return this.isHandshaking;
    }

    void initialize() throws IOException {
        this.isHandshaking = true;
        this.resumeSession = false;
        this.handShakeCompleted = false;
        this.shaMessageHash.reset();
        this.md5MessageHash.reset();
        byte[] time = Util.getBytes(System.currentTimeMillis() / 1000L, 4);
        byte[] random = new byte[28];
        this.context.getRandomBytes(random);
        this.connectionState = new ConnectionState();
        if (this.socket.getUseClientMode()) {
            this.connectionState.clientRandom = Util.concatenate(time, random);
            this.connectionState.setSessionState(this.getCachedClientSession(this.socket.getHostName()));
        } else {
            this.connectionState.serverRandom = Util.concatenate(time, random);
        }
    }

    public synchronized void run() throws IOException {
        long timeoutTime;
        this.initialize();
        this.inputQueue = new StreamQueue();
        if (this.socket.getUseClientMode()) {
            this.sendMessage((byte)1);
        }
        timeoutTime = (timeoutTime = this.socket.getTimeoutLength()) < 1L ? -1L : (timeoutTime += System.currentTimeMillis());
        boolean socketOpen = true;
        while (socketOpen && this.isHandshaking) {
            socketOpen = this.socket.readData();
            this.processQueuedMessages();
            if (timeoutTime == -1L || System.currentTimeMillis() <= timeoutTime) continue;
            throw new J9HandshakeException(Msg.getString("K01ee"));
        }
        this.isHandshaking = false;
    }

    private SessionState getCachedClientSession(String hostName) throws IOException {
        SessionState sessionState = this.context.getSession(hostName);
        if (sessionState != null) {
            String sessionCipherSpec = sessionState.getCipherSpec().getIdString();
            CipherSpec[] specs = this.socket.getEnabledCipherSpecs();
            int i = 0;
            while (i < specs.length) {
                String anEnabledCipherSpec = specs[i].getIdString();
                if (sessionCipherSpec.equals(anEnabledCipherSpec)) {
                    this.resumeSession = true;
                    sessionState.updateLastAccessTime(System.currentTimeMillis());
                    return sessionState;
                }
                ++i;
            }
        }
        this.resumeSession = false;
        return this.context.createSession(this.socket.getHostName());
    }

    public void notifyReceived(byte[] data) {
        try {
            this.inputQueue.getWriteStream().write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SessionState getSessionState() {
        if (this.connectionState == null) {
            return null;
        }
        return this.connectionState.getSessionState();
    }

    private void endHandshakeSequence() {
        this.isHandshaking = false;
        this.handShakeCompleted = true;
        if (!this.resumeSession) {
            this.context.addSession(this.connectionState.getSessionState());
        }
    }

    void updateMessagesHash(HandshakeMessage message) {
        if (!message.isHelloRequest() && !message.isSSLv2ClientHello()) {
            try {
                this.shaMessageHash.write(message.getBytes());
                this.md5MessageHash.write(message.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean hasQueuedMessages() {
        return this.inputQueue.getSize() > 0;
    }

    public void processQueuedMessages() throws IOException {
        while (this.hasQueuedMessages()) {
            this.processNextMessage();
        }
    }

    private void processNextMessage() throws IOException {
        this.processNextMessage(new HandshakeMessage(this.inputQueue.getReadStream(), this.inputQueue.getCapacity()));
    }

    void processNextMessage(HandshakeMessage message) throws IOException {
        if (!(message.isFinished() || message.isCertificateVerify() || message.isHelloRequest())) {
            this.updateMessagesHash(message);
        }
        switch (message.getType()) {
            case -1: {
                this.processSSLv2ClientHello(message);
                this.sendMessage((byte)2);
                break;
            }
            case 1: {
                this.processClientHello(message);
                this.sendMessage((byte)2);
                break;
            }
            case 0: {
                if (this.isHandshaking) break;
                this.beginRehandshake();
                break;
            }
            case 2: {
                this.processServerHello(message);
                break;
            }
            case 11: {
                this.processCertificate(message);
                break;
            }
            case 12: {
                this.processServerKeyExchange(message);
            }
            case 14: {
                this.processServerHelloDone(message);
                if (this.clientCertificateRequested) {
                    this.sendMessage((byte)11);
                    break;
                }
                this.sendMessage((byte)16);
                break;
            }
            case 16: {
                this.processClientKeyExcahnge(message);
                break;
            }
            case 20: {
                this.processFinished(message);
                if (this.socket.getUseClientMode()) {
                    if (this.resumeSession) {
                        this.sendMessage((byte)99);
                        break;
                    }
                    this.endHandshakeSequence();
                    break;
                }
                if (this.resumeSession) {
                    this.endHandshakeSequence();
                    break;
                }
                this.sendMessage((byte)99);
                break;
            }
            case 13: {
                this.processCertificateRequest(message);
                break;
            }
            case 15: {
                this.processCertificateVerify(message);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void processClientKeyExcahnge(HandshakeMessage message) throws IOException {
        int bytesProcessed;
        byte[] decryptedBytes;
        if (this.socket.getNeedClientAuth() && !this.clientCertificateVerified) {
            throw new J9HandshakeException(Msg.getString("K01da"));
        }
        if (!this.getSessionState().getCipherSpec().getKeyAlgorithmName().equals("RSA")) {
            throw new IOException(Msg.getString("K0437"));
        }
        int messageLength = this.isTLS() ? message.readLength(2) : message.getLength();
        byte[] cipherText = new byte[messageLength];
        int bytesRead = message.read(cipherText);
        if (bytesRead != messageLength) {
            throw new IOException(Msg.getString("K01db"));
        }
        RSAPrivateCrtKey serverKey = this.context.getPrivateKey(this.serverAlias);
        if (serverKey == null) {
            throw new IOException(Msg.getString("K01e9"));
        }
        try {
            Provider rsaProvider = Provider.getProvider(7, 0);
            Key key = rsaProvider.createKey(serverKey);
            key.cryptInit(2, 1, null);
            key.cryptUpdate(cipherText, 0, cipherText.length);
            decryptedBytes = key.cryptFinish();
            bytesProcessed = decryptedBytes.length;
        }
        catch (IOException e) {
            CL3 cl3KeyHandle = CL3.importKey(2, serverKey.getEncoded(), 0, serverKey.getEncoded().length);
            decryptedBytes = new byte[CL3.getSize(cl3KeyHandle)];
            bytesProcessed = RSACipher.rsaDecrypt(cl3KeyHandle, 32, null, cipherText, 0, cipherText.length, decryptedBytes, 0);
        }
        if (bytesProcessed != 48) {
            throw new IOException(Msg.getString("K01db"));
        }
        this.pre_master_secret = new byte[48];
        System.arraycopy((Object)decryptedBytes, 0, (Object)this.pre_master_secret, 0, 48);
        if (this.isTLS()) {
            this.getSessionState().setMasterSecret(this.generateTLSMasterSecret());
        } else {
            this.getSessionState().setMasterSecret(this.generateSSLMasterSecret());
        }
    }

    public void processChangeCipherSpec(boolean isReading) throws IOException {
        if (this.socket.getNeedClientAuth() && !this.clientCertificateVerified) {
            throw new J9HandshakeException(Msg.getString("K01da"));
        }
        this.connectionState.generateConnectionKeys();
        if (isReading) {
            this.connectionState.setReadEncrypted(true);
        } else {
            this.connectionState.setWriteEncrypted(true);
        }
    }

    private void processSSLv2ClientHello(HandshakeMessage message) throws IOException {
        byte[] someBytes = message.getBytes();
        byte[] newBytes = new byte[someBytes.length - 7];
        newBytes[0] = (byte)(someBytes[0] * -1);
        System.arraycopy((Object)someBytes, 4, (Object)newBytes, 1, newBytes.length - 1);
        this.shaMessageHash.write(newBytes);
        this.md5MessageHash.write(newBytes);
        byte[] suggestedProtocolVersion = message.readField(2, true);
        int cipherSpecLength = message.readSSLv2Length();
        int sessionIDLength = message.readSSLv2Length();
        int challengeLength = message.readSSLv2Length();
        int listSize = cipherSpecLength / 3;
        if (listSize < 1) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            throw new IOException(Msg.getString("K01db"));
        }
        CipherSpec negotiatedCipherSpec = this.negotiateCipherSuite(message, true, listSize);
        message.readField(sessionIDLength, true);
        byte[] challengeData = message.readField(challengeLength, true);
        this.connectionState.clientRandom = new byte[32];
        System.arraycopy((Object)challengeData, 0, (Object)this.connectionState.clientRandom, 32 - challengeLength, challengeLength);
        if (sessionIDLength != 0) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
        }
        byte[] negotiatedProtocolVersion = this.negotiateProtocolVersion(suggestedProtocolVersion);
        this.resumeSession = false;
        byte[] id = new byte[32];
        this.context.getRandomBytes(id);
        SessionState sessionState = this.context.createSession(id);
        this.connectionState.setSessionState(sessionState);
        sessionState.cipherSpec = negotiatedCipherSpec;
        sessionState.protocolVersion = negotiatedProtocolVersion;
    }

    private void processClientHello(HandshakeMessage message) throws IOException {
        byte[] suggestedProtocolVersion = message.readField(2, true);
        this.connectionState.clientRandom = message.readField(32, true);
        byte[] proposedSessionID = message.readShortField(false);
        byte[] negotiatedProtocolVersion = this.negotiateProtocolVersion(suggestedProtocolVersion);
        int listSize = message.readLength(2) / 2;
        if (listSize < 1) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            throw new IOException(Msg.getString("K01db"));
        }
        CipherSpec negotiatedCipherSpec = this.negotiateCipherSuite(message, false, listSize);
        this.negotiateCompressionMode(message);
        SessionState sessionState = this.context.getSession(proposedSessionID);
        if (sessionState == null) {
            this.resumeSession = false;
            byte[] id = new byte[32];
            this.context.getRandomBytes(id);
            sessionState = this.context.createSession(id);
        } else {
            this.resumeSession = true;
        }
        this.connectionState.setSessionState(sessionState);
        sessionState.cipherSpec = negotiatedCipherSpec;
        sessionState.protocolVersion = negotiatedProtocolVersion;
        message.skipRemaining();
    }

    private void negotiateCompressionMode(HandshakeMessage message) throws IOException {
        int listSize = message.read();
        if (listSize < 1) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            throw new IOException(Msg.getString("K01db"));
        }
        boolean supportedCompressionMethod = false;
        int i = 0;
        while (i < listSize) {
            byte compressionMethod = (byte)message.read();
            if (compressionMethod == -1) {
                this.socket.sendSocketAlert((byte)2, (byte)40);
                throw new IOException(Msg.getString("K01db"));
            }
            if (compressionMethod == 0) {
                supportedCompressionMethod = true;
            }
            ++i;
        }
        if (!supportedCompressionMethod) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            throw new IOException(Msg.getString("K0439"));
        }
    }

    private CipherSpec negotiateCipherSuite(HandshakeMessage message, boolean isSSLv2, int listSize) throws IOException {
        CipherSpec[] enabledCipherSpecs = this.socket.getEnabledCipherSpecs();
        CipherSpec negotiatedCipherSpec = null;
        int i = 0;
        while (i < listSize) {
            int result;
            int msb;
            byte[] cipherSuite = new byte[2];
            if (isSSLv2) {
                msb = message.read();
                result = message.read(cipherSuite);
            } else {
                msb = 0;
                result = message.read(cipherSuite);
            }
            if (result != 2) {
                this.socket.sendSocketAlert((byte)2, (byte)40);
                throw new IOException(Msg.getString("K01db"));
            }
            if (msb == 0 && negotiatedCipherSpec == null) {
                int j = 0;
                while (j < enabledCipherSpecs.length) {
                    if (Util.equals(enabledCipherSpecs[j].getId(), cipherSuite)) {
                        negotiatedCipherSpec = enabledCipherSpecs[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (negotiatedCipherSpec == null) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            throw new IOException(Msg.getString("K0438"));
        }
        return negotiatedCipherSpec;
    }

    private boolean lessThan(byte[] a, byte[] b) {
        if (a.length != 2 || b.length != 2) {
            return false;
        }
        if (a[0] < b[0]) {
            return true;
        }
        if (a[0] > b[0]) {
            return false;
        }
        return a[1] < b[1];
    }

    private byte[][] getMinMaxProtocolVersinos() {
        byte[][] result = new byte[2][];
        byte[] minimumEnabledProtocol = new byte[]{127, 127};
        byte[] maximumEnabledProtocol = new byte[2];
        String[] protocols = this.socket.getEnabledProtocols();
        int i = 0;
        while (i < protocols.length) {
            byte[] possibleProtocol = CipherSpec.getProtocolVersion(protocols[i]);
            if (this.lessThan(possibleProtocol, minimumEnabledProtocol)) {
                minimumEnabledProtocol = possibleProtocol;
            }
            if (this.lessThan(maximumEnabledProtocol, possibleProtocol)) {
                maximumEnabledProtocol = possibleProtocol;
            }
            ++i;
        }
        result[0] = minimumEnabledProtocol;
        result[1] = maximumEnabledProtocol;
        return result;
    }

    private byte[] negotiateProtocolVersion(byte[] suggestedProtocolVersion) {
        byte[][] minMax = this.getMinMaxProtocolVersinos();
        byte[] minimumEnabledProtocol = minMax[0];
        byte[] maximumEnabledProtocol = minMax[1];
        if (this.lessThan(suggestedProtocolVersion, minimumEnabledProtocol)) {
            return minimumEnabledProtocol;
        }
        if (this.lessThan(maximumEnabledProtocol, suggestedProtocolVersion)) {
            return maximumEnabledProtocol;
        }
        return suggestedProtocolVersion;
    }

    void sendMessage(byte type) throws IOException {
        switch (type) {
            case 1: {
                byte[] buffer = this.generateClientHelloData();
                this.sendMessage(type, buffer);
                break;
            }
            case 2: {
                byte[] buffer = this.generateServerHelloData();
                this.sendMessage(type, buffer);
                if (this.resumeSession) {
                    this.sendMessage((byte)99);
                    break;
                }
                this.sendMessage((byte)11);
                break;
            }
            case 16: {
                byte[] buffer = this.generateClientKeyExchangeData();
                this.sendMessage(type, buffer);
                if (this.clientCertificateRequested && this.clientAlias != null) {
                    this.sendMessage((byte)15);
                    break;
                }
                this.sendMessage((byte)99);
                break;
            }
            case 20: {
                byte[] buffer = this.generateFinishedData();
                this.sendMessage(type, buffer);
                if (this.socket.getUseClientMode()) {
                    if (!this.resumeSession) break;
                    this.endHandshakeSequence();
                    break;
                }
                if (this.resumeSession) break;
                this.endHandshakeSequence();
                break;
            }
            case 14: {
                byte[] buffer = this.generateServerHelloDoneData();
                this.sendMessage(type, buffer);
                break;
            }
            case 99: {
                this.sendChangeCipherSpec();
                this.connectionState.generateConnectionKeys();
                this.sendMessage((byte)20);
                break;
            }
            case 13: {
                byte[] buffer = this.generateCertificateRequest();
                this.sendMessage(type, buffer);
                this.sendMessage((byte)14);
                break;
            }
            case 11: {
                byte[] buffer = this.generateCertificateData();
                this.sendMessage(type, buffer);
                if (this.socket.getUseClientMode()) {
                    this.sendMessage((byte)16);
                    break;
                }
                if (this.socket.getWantClientAuth()) {
                    this.clientCertificateVerified = false;
                    this.sendMessage((byte)13);
                    break;
                }
                this.sendMessage((byte)14);
                break;
            }
            case 15: {
                byte[] buffer = this.generateCertificateVerifyData();
                this.sendMessage(type, buffer);
                this.sendMessage((byte)99);
                break;
            }
            default: {
                throw new IllegalStateException("Attempted to send invalid message type");
            }
        }
    }

    void sendMessage(byte type, byte[] buffer) throws IOException {
        HandshakeMessage message = new HandshakeMessage(type, buffer);
        this.updateMessagesHash(message);
        this.socket.writeData(message.getBytes(), 0, message.getBytes().length, (byte)22);
    }

    private byte[] generateServerHelloDoneData() {
        return new byte[0];
    }

    private byte[] generateServerHelloData() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(this.getSessionState().getProtocolVersion());
        output.write(this.connectionState.serverRandom);
        output.write(this.getSessionState().getSessionID().length);
        output.write(this.getSessionState().getSessionID());
        output.write(this.getSessionState().getCipherSpec().getId());
        output.write(0);
        return output.toByteArray();
    }

    private byte[] generateClientHelloData() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] maxVersion = this.getMinMaxProtocolVersinos()[1];
        output.write(maxVersion);
        output.write(this.connectionState.clientRandom);
        if (this.resumeSession) {
            output.write((byte)this.getSessionState().getSessionID().length);
            output.write(this.getSessionState().getSessionID());
        } else {
            output.write(0);
        }
        CipherSpec[] cipherSuites = this.socket.getEnabledCipherSpecs();
        output.write(Util.getBytes(cipherSuites.length * 2, 2));
        int i = 0;
        while (i < cipherSuites.length) {
            output.write(cipherSuites[i].getId());
            ++i;
        }
        output.write(1);
        output.write(0);
        return output.toByteArray();
    }

    private byte[] generateCertificateData() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        String alias = this.socket.getUseClientMode() ? this.clientAlias : (this.serverAlias = this.context.chooseServerAlias(this.getSessionState().getCipherSpec().getKeyAlgorithmName(), null));
        X509Certificate[] certificateChain = this.context.getCertificateChain(alias);
        if (certificateChain == null) {
            if (this.socket.getUseClientMode()) {
                buffer.write(Util.getBytes(0, 3));
                return buffer.toByteArray();
            }
            throw new IOException(Msg.getString("K0523", alias));
        }
        int i = 0;
        while (i < certificateChain.length) {
            try {
                byte[] encoded = certificateChain[i].getEncoded();
                buffer.write(Util.getBytes((long)encoded.length, 3));
                buffer.write(encoded);
            }
            catch (CertificateEncodingException e) {
                throw new IOException(Msg.getString("K03a7"));
            }
            ++i;
        }
        this.getSessionState().setLocalCertificates(certificateChain);
        byte[] result = new byte[buffer.size() + 3];
        byte[] lengthBytes = Util.getBytes((long)buffer.size(), 3);
        System.arraycopy((Object)lengthBytes, 0, (Object)result, 0, lengthBytes.length);
        System.arraycopy((Object)buffer.toByteArray(), 0, (Object)result, lengthBytes.length, result.length - lengthBytes.length);
        return result;
    }

    private byte[] generateCertificateVerifyData() throws IOException {
        if (this.clientAlias == null) {
            return Util.getBytes(0, 2);
        }
        byte[] result = this.computeCertificateVerifyMessage();
        PKCS1 pkcs1 = new PKCS1("SHA1");
        RSAPrivateCrtKey rsaPrivateCrtKey = this.context.getPrivateKey(this.clientAlias);
        RSAPrivateKey rsaPrivateKey = rsaPrivateCrtKey instanceof RSAPrivateKey ? (RSAPrivateKey)((Object)rsaPrivateCrtKey) : new RSAPrivateKey(rsaPrivateCrtKey);
        result = pkcs1.signSSA_PKCS1_v15Impl_NO_DER(rsaPrivateKey, result);
        byte[] lengthBytes = Util.getBytes(result.length, 2);
        result = Util.concatenate(lengthBytes, result);
        return result;
    }

    private byte[] computeCertificateVerifyMessage() {
        byte[] shaHash;
        byte[] md5Hash;
        if (this.isTLS()) {
            md5Hash = this.md5MessageHash.copyOf().getHashAsBytes();
            shaHash = this.shaMessageHash.copyOf().getHashAsBytes();
        } else {
            md5Hash = this.computeFinishedMD5Hash(new byte[0]);
            shaHash = this.computeFinishedSHAHash(new byte[0]);
        }
        return Util.concatenate(md5Hash, shaHash);
    }

    private void processCertificateVerify(HandshakeMessage message) throws IOException {
        if (this.getSessionState().getPeerCertificates().length == 0) {
            if (this.socket.getNeedClientAuth()) {
                throw new J9HandshakeException(Msg.getString("K01da"));
            }
            this.updateMessagesHash(message);
            return;
        }
        this.clientCertificateVerified = true;
        byte[] candidateMessage = this.computeCertificateVerifyMessage();
        int length = message.readLength(2);
        byte[] signature = new byte[length];
        message.read(signature);
        PKCS1 pkcs1 = new PKCS1("SHA1");
        RSAPublicKey key = (RSAPublicKey)this.getSessionState().getPeerCertificates()[0].getPublicKey();
        if (!pkcs1.verifySSA_PKCS1_v15Impl_NO_DER(key, candidateMessage, signature)) {
            throw new IOException(Msg.getString("K01d5"));
        }
        this.updateMessagesHash(message);
    }

    private boolean isProtocolVersionSupported(byte[] version) {
        String protocolName = CipherSpec.getProtocolName(version);
        String[] protocols = this.socket.getEnabledProtocols();
        int i = 0;
        while (i < protocols.length) {
            if (protocols[i].equals(protocolName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void processServerHello(HandshakeMessage message) throws IOException {
        byte[] protocolVersion = message.readField(2, true);
        this.connectionState.serverRandom = message.readField(32, true);
        byte[] proposedSessionID = message.readShortField(false);
        byte[] cipherSpecBytes = message.readField(2, true);
        CipherSpec cipherSpec = CipherSpec.getCipherSpec(cipherSpecBytes);
        byte compressionMethod = (byte)message.read();
        if (compressionMethod == -1) {
            throw new IOException(Msg.getString("K01db"));
        }
        if (!this.isProtocolVersionSupported(protocolVersion)) {
            throw new J9ProtocolException(Msg.getString("K01e5", (Object)protocolVersion));
        }
        if (cipherSpec == null) {
            throw new J9ProtocolException(Msg.getString("K01e6", cipherSpec));
        }
        if (compressionMethod != 0) {
            throw new J9ProtocolException(Msg.getString("K01e7", compressionMethod));
        }
        if (Util.equals(this.getSessionState().getSessionID(), proposedSessionID)) {
            this.resumeSession = true;
        } else {
            this.resumeSession = false;
            this.connectionState.setSessionState(this.context.createSession(this.socket.getHostName()));
            this.getSessionState().sessionID = proposedSessionID;
            this.getSessionState().cipherSpec = cipherSpec;
            this.getSessionState().protocolVersion = protocolVersion;
        }
    }

    private void processCertificate(HandshakeMessage message) throws IOException {
        Vector certificates = new Vector();
        message.readLength(3);
        byte[] certBytes = message.readLongField(3, false);
        while (certBytes != null) {
            try {
                X509CertImpl newCert = X509CertImpl.certificateFromASN1Object(certBytes);
                certificates.addElement(newCert);
                certBytes = message.readLongField(3, false);
            }
            catch (CertificateException e) {
                throw new J9HandshakeException(Msg.getString("K01e8", e.getMessage()));
            }
        }
        try {
            com.ibm.oti.security.provider.X509Certificate[] certArray = new com.ibm.oti.security.provider.X509Certificate[certificates.size()];
            int i = 0;
            while (i < certificates.size()) {
                certArray[i] = new com.ibm.oti.security.provider.X509Certificate((X509CertImpl)certificates.elementAt(i));
                ++i;
            }
            if (this.socket.getUseClientMode()) {
                if (certificates.size() == 0) {
                    throw new J9HandshakeException(Msg.getString("K01e9"));
                }
                this.context.checkServerTrusted(certArray);
            } else if (certificates.size() == 0) {
                if (this.socket.getNeedClientAuth()) {
                    throw new J9HandshakeException(Msg.getString("K01da"));
                }
            } else {
                this.context.checkClientTrusted(certArray);
            }
            this.clientCertificateVerified = true;
        }
        catch (CertificateException e) {
            throw new J9HandshakeException(e.getMessage());
        }
        this.getSessionState().setPeerCertificates(certificates);
    }

    private void processServerKeyExchange(HandshakeMessage message) throws IOException {
        try {
            byte[] modulusBytes = message.readLongField(2, true);
            BigInteger modulus = new BigInteger(1, modulusBytes);
            byte[] exponentBytes = message.readLongField(2, true);
            BigInteger exponent = new BigInteger(1, exponentBytes);
            this.tempKey = new com.ibm.oti.security.provider.RSAPublicKey(modulus, exponent);
        }
        catch (IOException e) {
            throw new J9ProtocolException(Msg.getString("K01ea"));
        }
    }

    private void processCertificateRequest(HandshakeMessage message) throws IOException {
        this.clientCertificateRequested = true;
        this.clientAlias = null;
        int length = message.read();
        if (length == -1) {
            return;
        }
        String[] allowedKeyAlgorithmNames = new String[length];
        int i = 0;
        while (i < length) {
            allowedKeyAlgorithmNames[i] = this.getKeyAlogorithmName(message.read());
            ++i;
        }
        Vector result = new Vector();
        message.readLength(2);
        byte[] buffer = message.readLongField(2, false);
        while (buffer != null) {
            result.add(new X500Principal(buffer));
            buffer = message.readLongField(2, false);
        }
        Principal[] allowedCAs = (X500Principal[])result.toArray(new X500Principal[result.size()]);
        this.clientAlias = this.context.chooseClientAlias(allowedKeyAlgorithmNames, allowedCAs);
    }

    private byte[] generateCertificateRequest() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(1);
        output.write(1);
        X509Certificate[] acceptedIssuers = this.context.getAcceptedIssuers();
        output.write(new byte[2]);
        int size = 0;
        int i = 0;
        while (i < acceptedIssuers.length) {
            X509Certificate certificate = acceptedIssuers[i];
            byte[] encodedDN = new X500Principal(certificate.getIssuerDN().getName()).getEncoded();
            output.write(Util.getBytes(encodedDN.length, 2));
            output.write(encodedDN);
            size = size + 2 + encodedDN.length;
            ++i;
        }
        byte[] sizeBytes = Util.getBytes(size, 2);
        byte[] result = output.toByteArray();
        result[2] = sizeBytes[0];
        result[3] = sizeBytes[1];
        return result;
    }

    private String getKeyAlogorithmName(int b) {
        switch (b) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSS";
            }
        }
        return "unknown";
    }

    private void processServerHelloDone(HandshakeMessage message) throws IOException {
        if (!this.resumeSession) {
            this.generatePreMasterSecret();
            if (this.isTLS()) {
                this.getSessionState().setMasterSecret(this.generateTLSMasterSecret());
            } else {
                this.getSessionState().setMasterSecret(this.generateSSLMasterSecret());
            }
        }
        if (this.clientCertificateRequested && this.clientAlias == null) {
            this.socket.sendSocketAlert((byte)1, (byte)41);
        }
    }

    private byte[] generateTLSMasterSecret() {
        byte[] seed = Util.concatenate(this.connectionState.clientRandom, this.connectionState.serverRandom);
        byte[] result = this.connectionState.getHashingAlgorithm().PRF(this.pre_master_secret, "master secret", seed, 48);
        return result;
    }

    private byte[] generateSSLMasterSecret() {
        byte[] buffer1 = Util.concatenate(new byte[]{65}, this.pre_master_secret, this.connectionState.clientRandom, this.connectionState.serverRandom);
        byte[] buffer2 = Util.concatenate(this.pre_master_secret, HashingAlgorithmSHA1.hashSHA1(buffer1));
        byte[] masterSecretComponent1 = HashingAlgorithmMD5.hashMD5(buffer2);
        buffer1 = Util.concatenate(new byte[]{66, 66}, this.pre_master_secret, this.connectionState.clientRandom, this.connectionState.serverRandom);
        buffer2 = Util.concatenate(this.pre_master_secret, HashingAlgorithmSHA1.hashSHA1(buffer1));
        byte[] masterSecretComponent2 = HashingAlgorithmMD5.hashMD5(buffer2);
        buffer1 = Util.concatenate(new byte[]{67, 67, 67}, this.pre_master_secret, this.connectionState.clientRandom, this.connectionState.serverRandom);
        buffer2 = Util.concatenate(this.pre_master_secret, HashingAlgorithmSHA1.hashSHA1(buffer1));
        byte[] masterSecretComponent3 = HashingAlgorithmMD5.hashMD5(buffer2);
        byte[] masterSecret = Util.concatenate(masterSecretComponent1, masterSecretComponent2, masterSecretComponent3);
        return masterSecret;
    }

    private void generatePreMasterSecret() {
        byte[] random = new byte[46];
        this.context.getRandomBytes(random);
        this.pre_master_secret = Util.concatenate(this.getSessionState().getProtocolVersion(), random);
    }

    private byte[] generateClientKeyExchangeData() throws IOException {
        int bytesProcessed;
        byte[] encryptedBytes;
        RSAPublicKey serverKey = null;
        if (this.tempKey != null) {
            serverKey = this.tempKey;
        } else {
            X509CertImpl serverCert = this.connectionState.getSessionState().getPeerCertificates()[0];
            serverKey = (RSAPublicKey)serverCert.getPublicKey();
        }
        try {
            Provider provider = Provider.getProvider(7, 0);
            Key key = provider.createKey(serverKey);
            key.cryptInit(1, 1, null);
            key.cryptUpdate(this.pre_master_secret, 0, this.pre_master_secret.length);
            encryptedBytes = key.cryptFinish();
            bytesProcessed = encryptedBytes.length;
        }
        catch (IOException e) {
            CL3 cl3KeyHandle = CL3.importKey(3, serverKey.getEncoded(), 0, serverKey.getEncoded().length);
            encryptedBytes = new byte[CL3.getSize(cl3KeyHandle)];
            bytesProcessed = RSACipher.rsaEncrypt(cl3KeyHandle, 32, null, this.pre_master_secret, 0, this.pre_master_secret.length, encryptedBytes, 0);
        }
        byte[] cipherTextBytes = new byte[bytesProcessed];
        System.arraycopy((Object)encryptedBytes, 0, (Object)cipherTextBytes, 0, bytesProcessed);
        if (this.isTLS()) {
            byte[] length = Util.getBytes(cipherTextBytes.length, 2);
            return Util.concatenate(length, cipherTextBytes);
        }
        return cipherTextBytes;
    }

    private boolean isTLS() {
        return this.connectionState.isTLS();
    }

    private void processFinished(HandshakeMessage message) throws IOException {
        if (this.isTLS()) {
            this.processTLSServerFinished(message);
        } else {
            this.processSSLServerFinished(message);
        }
        this.updateMessagesHash(message);
    }

    private void processTLSServerFinished(HandshakeMessage message) throws IOException {
        byte[] verifyData = message.readField(12, true);
        byte[] hashes = Util.concatenate(this.getMD5Hash(), this.getSHAHash());
        byte[] localData = this.socket.getUseClientMode() ? this.connectionState.getHashingAlgorithm().PRF(this.getSessionState().getMasterSecret(), TLS_SERVER_FINISHED_LABEL, hashes, 12) : this.connectionState.getHashingAlgorithm().PRF(this.getSessionState().getMasterSecret(), TLS_CLIENT_FINISHED_LABEL, hashes, 12);
        if (!Util.equals(verifyData, localData)) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            throw new J9HandshakeException(Msg.getString("K01eb"));
        }
    }

    private void processSSLServerFinished(HandshakeMessage message) throws IOException {
        byte[] hashSHAPrime;
        byte[] hashMD5Prime;
        byte[] hashMD5 = message.readField(16, true);
        byte[] hashSHA = message.readField(20, true);
        if (this.socket.getUseClientMode()) {
            hashMD5Prime = this.computeFinishedMD5Hash(SSL_SERVER_FINISHED_LABEL);
            hashSHAPrime = this.computeFinishedSHAHash(SSL_SERVER_FINISHED_LABEL);
        } else {
            hashMD5Prime = this.computeFinishedMD5Hash(SSL_CLIENT_FINISHED_LABEL);
            hashSHAPrime = this.computeFinishedSHAHash(SSL_CLIENT_FINISHED_LABEL);
        }
        if (!Util.equals(hashMD5, hashMD5Prime)) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            if (this.socket.getUseClientMode()) {
                throw new J9HandshakeException(Msg.getString("K01eb"));
            }
            throw new J9HandshakeException(Msg.getString("K043A"));
        }
        if (!Util.equals(hashSHA, hashSHAPrime)) {
            this.socket.sendSocketAlert((byte)2, (byte)40);
            if (this.socket.getUseClientMode()) {
                throw new J9HandshakeException(Msg.getString("K01eb"));
            }
            throw new J9HandshakeException(Msg.getString("K043A"));
        }
    }

    private byte[] generateFinishedData() throws IOException {
        if (this.isTLS()) {
            return this.generateTLSFinishedData();
        }
        return this.generateSSLFinishedData();
    }

    private byte[] generateTLSFinishedData() throws IOException {
        byte[] hashes = Util.concatenate(this.getMD5Hash(), this.getSHAHash());
        byte[] localData = this.socket.getUseClientMode() ? this.connectionState.getHashingAlgorithm().PRF(this.getSessionState().getMasterSecret(), TLS_CLIENT_FINISHED_LABEL, hashes, 12) : this.connectionState.getHashingAlgorithm().PRF(this.getSessionState().getMasterSecret(), TLS_SERVER_FINISHED_LABEL, hashes, 12);
        return localData;
    }

    private byte[] generateSSLFinishedData() {
        byte[] shaHash;
        byte[] md5Hash;
        if (this.socket.getUseClientMode()) {
            md5Hash = this.computeFinishedMD5Hash(SSL_CLIENT_FINISHED_LABEL);
            shaHash = this.computeFinishedSHAHash(SSL_CLIENT_FINISHED_LABEL);
        } else {
            md5Hash = this.computeFinishedMD5Hash(SSL_SERVER_FINISHED_LABEL);
            shaHash = this.computeFinishedSHAHash(SSL_SERVER_FINISHED_LABEL);
        }
        byte[] result = Util.concatenate(md5Hash, shaHash);
        return result;
    }

    private byte[] computeFinishedMD5Hash(byte[] sender) {
        try {
            DigestOutputStream md5Hash = this.md5MessageHash.copyOf();
            md5Hash.write(sender);
            md5Hash.write(this.getSessionState().getMasterSecret());
            md5Hash.write(HashingAlgorithmMD5.PAD_1);
            byte[] buffer = Util.concatenate(this.getSessionState().getMasterSecret(), HashingAlgorithmMD5.PAD_2, md5Hash.getHashAsBytes());
            return HashingAlgorithmMD5.hashMD5(buffer);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getMD5Hash() {
        DigestOutputStream md5Hash = this.md5MessageHash.copyOf();
        return md5Hash.getHashAsBytes();
    }

    private byte[] getSHAHash() {
        DigestOutputStream shaHash = this.shaMessageHash.copyOf();
        return shaHash.getHashAsBytes();
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    private byte[] computeFinishedSHAHash(byte[] sender) {
        try {
            DigestOutputStream shaHash = this.shaMessageHash.copyOf();
            shaHash.write(sender);
            shaHash.write(this.getSessionState().getMasterSecret());
            shaHash.write(HashingAlgorithmSHA1.PAD_1);
            byte[] buffer = Util.concatenate(this.getSessionState().getMasterSecret(), HashingAlgorithmSHA1.PAD_2, shaHash.getHashAsBytes());
            return HashingAlgorithmSHA1.hashSHA1(buffer);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean wasResumed() {
        if (this.isHandshaking || this.connectionState == null || !this.connectionState.readEncrypted || !this.connectionState.writeEncrypted) {
            throw new IllegalArgumentException("Handshake not completed yet.");
        }
        return this.resumeSession;
    }

    void beginRehandshake() throws IOException {
        this.sendMessage((byte)1);
    }

    void sendChangeCipherSpec() throws IOException {
        this.socket.sendChangeCipherSpec();
    }

    void printDebug(String mode, Object message) {
    }
}

