/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.SSLProtocol;
import com.ibm.j9.ssl.Util;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Record {
    public static final int MAX_RECORD_LENGTH = 16384;
    public static final int HEADER_LENGTH = 5;
    private final byte[] version;
    private final byte contentType;
    private final byte[] data;
    private static boolean recordDebug = false;

    public Record(byte contentType, byte[] version, byte[] data) {
        this.contentType = contentType;
        this.version = new byte[2];
        System.arraycopy((Object)version, 0, (Object)this.version, 0, 2);
        this.data = new byte[data.length];
        System.arraycopy((Object)data, 0, (Object)this.data, 0, data.length);
    }

    public static Record readRecord(InputStream is) throws IOException {
        int dataLength;
        int readlen = -1;
        int offset = 0;
        byte[] header = new byte[5];
        while (offset < header.length) {
            readlen = is.read(header, offset, header.length - offset);
            if (readlen == -1) {
                return null;
            }
            if (readlen == 0 && offset == 0) {
                return null;
            }
            if (readlen <= 0) continue;
            offset += readlen;
        }
        byte contentType = header[0];
        byte[] version = new byte[2];
        if (contentType == -128 && header[2] == 1) {
            System.arraycopy((Object)header, 3, (Object)version, 0, version.length);
            dataLength = (int)Util.getLong(header, 1, 1) + 3;
        } else {
            System.arraycopy((Object)header, 1, (Object)version, 0, version.length);
            dataLength = (int)Util.getLong(header, 3, 2);
        }
        if (!SSLProtocol.isValidContentType(contentType)) {
            throw new IOException(Msg.getString("K01ef"));
        }
        if (!SSLProtocol.isValidVersion(version)) {
            throw new IOException(Msg.getString("K01f0"));
        }
        offset = 0;
        byte[] inData = new byte[dataLength];
        if (contentType == -128) {
            inData[0] = header[2];
            inData[1] = 0;
            inData[2] = 0;
            inData[3] = (byte)dataLength;
            System.arraycopy((Object)header, 3, (Object)inData, offset += 4, 2);
            offset += 2;
            inData[0] = (byte)(inData[0] * -1);
        }
        while (offset < dataLength) {
            readlen = is.read(inData, offset, dataLength - offset);
            if (readlen == -1) {
                return null;
            }
            if (readlen <= 0) continue;
            offset += readlen;
        }
        Record newRecord = new Record(contentType, version, inData);
        if (recordDebug) {
            System.err.println(Msg.getString("K0431"));
            System.err.print(newRecord.toString());
            System.err.println("--------------");
            System.err.flush();
        }
        return newRecord;
    }

    public void writeRecord(OutputStream os) throws IOException {
        if (recordDebug) {
            System.err.println(Msg.getString("K0432"));
            System.err.print(this.toString());
            System.err.println("==============");
            System.err.flush();
        }
        byte[] encodedData = this.toByteArray();
        os.write(encodedData);
        os.flush();
    }

    private byte[] toByteArray() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(this.contentType);
            output.write(this.version);
            output.write(Util.getBytes(this.data.length, 2));
            output.write(this.data);
        }
        catch (IOException iOException) {}
        return output.toByteArray();
    }

    public byte[] getVersion() {
        return this.version;
    }

    public byte getContentType() {
        return this.contentType;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(Msg.getString("K0433", SSLProtocol.getContentTypeName(this.contentType)));
        output.append(Util.getLineTerminator());
        output.append(Msg.getString("K0434", new Byte(this.version[0]), new Byte(this.version[1])));
        output.append(Util.getLineTerminator());
        output.append(Msg.getString("K0435", new String[]{String.valueOf(this.data.length), Util.getStringForByteArray(this.data)}));
        output.append(Util.getLineTerminator());
        return output.toString();
    }
}

