/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.bluez.crypto.CL3State;
import com.ibm.j9.bluez.crypto.HMAC;
import com.ibm.j9.ssl.Util;

public class TLSProtocol {
    public static final byte[] TLS_PROTOCOL_VERSION = new byte[]{3, 1};
    public static final String TLS_PROTOCOL_NAME = "TLSv1";

    public static byte[] PRF(byte[] secret, String label, byte[] seed, int bytesRequired) {
        int offset = 0;
        int half = secret.length / 2;
        if (secret.length % 2 != 0) {
            ++half;
            ++offset;
        }
        byte[] S1 = new byte[half];
        byte[] S2 = new byte[half];
        System.arraycopy((Object)secret, 0, (Object)S1, 0, half);
        System.arraycopy((Object)secret, half - offset, (Object)S2, 0, half);
        byte[] newSeed = Util.concatenate(label.getBytes(), seed);
        byte[] md5Hash = TLSProtocol.pHash(2, S1, newSeed, bytesRequired);
        byte[] shaHash = TLSProtocol.pHash(3, S2, newSeed, bytesRequired);
        byte[] result = new byte[bytesRequired];
        int i = 0;
        while (i < bytesRequired) {
            result[i] = (byte)(md5Hash[i] ^ shaHash[i]);
            ++i;
        }
        return result;
    }

    private static byte[] pHash(int hashType, byte[] secret, byte[] seed, int bytesRequired) {
        int digestSize;
        if (hashType == 2) {
            digestSize = 16;
        } else if (hashType == 3) {
            digestSize = 20;
        } else {
            throw new IllegalArgumentException("Unsupported hashType.  Must be MD5 or SHA");
        }
        int iterations = bytesRequired / digestSize;
        if (bytesRequired % digestSize > 0) {
            ++iterations;
        }
        byte[] result = new byte[iterations * digestSize];
        byte[][] A = new byte[iterations + 1][digestSize];
        A[0] = seed;
        CL3State hmac = null;
        int i = 1;
        while (i <= iterations) {
            hmac = HMAC.hmacInit(hmac, hashType, secret, 0, secret.length);
            HMAC.hmac(hmac, A[i - 1], 0, A[i - 1].length, A[i], 0);
            ++i;
        }
        i = 1;
        while (i <= iterations) {
            byte[] tempSeed = Util.concatenate(A[i], seed);
            hmac = HMAC.hmacInit(hmac, hashType, secret, 0, secret.length);
            HMAC.hmac(hmac, tempSeed, 0, tempSeed.length, result, (i - 1) * digestSize);
            ++i;
        }
        return result;
    }
}

