/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.comm;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.DataConnection;
import com.ibm.oti.connection.comm.CommInputStream;
import com.ibm.oti.connection.comm.CommOutputStream;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.CommConnection;

public class Connection
extends DataConnection
implements CreateConnection,
CommConnection {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int PARITY_NONE = 0;
    private static final int PARITY_ODD = 1;
    private static final int PARITY_EVEN = 2;
    private static final int UNOPENED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private boolean open = false;
    private boolean throwTimeout = false;
    private int access = 3;
    private int osHandle = 0;
    private int timeout = 5000;
    private int inputStatus = 0;
    private int outputStatus = 0;
    private int finalBaud = -1;
    private String portName = "";
    private static Hashtable openConnections = new Hashtable();

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        int portNum;
        this.access = access;
        this.throwTimeout = throwTimeout;
        try {
            portNum = Integer.parseInt(spec);
        }
        catch (NumberFormatException numberFormatException) {
            portNum = -1;
        }
        int baudrate = 9600;
        int bitsPerChar = 8;
        int stopBits = 1;
        int parity = 0;
        boolean autoRTS = false;
        boolean autoCTS = false;
        boolean blocking = true;
        int i = 0;
        while (i < equates.length) {
            String key = equates[i][0].toLowerCase();
            String value = equates[i][1].toLowerCase();
            if (key.equals("baudrate")) {
                try {
                    baudrate = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(value);
                }
            }
            if (key.equals("bitsperchar")) {
                if (value.equals("5")) {
                    bitsPerChar = 5;
                } else if (value.equals("6")) {
                    bitsPerChar = 6;
                } else if (value.equals("7")) {
                    bitsPerChar = 7;
                } else {
                    if (!value.equals("8")) throw new IllegalArgumentException(value);
                    bitsPerChar = 8;
                }
            } else if (key.equals("parity")) {
                if (value.equals("odd")) {
                    parity = 1;
                } else if (value.equals("even")) {
                    parity = 2;
                } else {
                    if (!value.equals("none")) throw new IllegalArgumentException(value);
                    parity = 0;
                }
            } else if (key.equals("stopbits")) {
                if (value.equals("1")) {
                    stopBits = 1;
                } else {
                    if (!value.equals("2")) throw new IllegalArgumentException(value);
                    stopBits = 2;
                }
            } else if (key.equals("autocts")) {
                if (value.equals("on")) {
                    autoCTS = true;
                } else if (!value.equals("off")) {
                    throw new IllegalArgumentException(value);
                }
            } else if (key.equals("autorts")) {
                if (value.equals("on")) {
                    autoRTS = true;
                } else if (!value.equals("off")) {
                    throw new IllegalArgumentException(value);
                }
            } else if (key.equals("blocking")) {
                if (value.equals("off")) {
                    blocking = false;
                } else if (!value.equals("on")) {
                    throw new IllegalArgumentException(value);
                }
            } else {
                if (!key.equals("timeout")) throw new IllegalArgumentException(key);
                try {
                    this.timeout = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    this.timeout = -1;
                }
                if (this.timeout < 0) {
                    throw new IllegalArgumentException(value);
                }
            }
            ++i;
        }
        switch (baudrate) {
            case 300: 
            case 1200: 
            case 2400: 
            case 4800: 
            case 9600: 
            case 19200: 
            case 38400: 
            case 57600: 
            case 115200: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(baudrate));
            }
        }
        if (blocking && this.timeout == 0) {
            this.timeout = 3000;
        }
        if (!blocking) {
            this.timeout = 0;
        }
        if (portNum == -1) {
            if (openConnections.containsKey(spec)) {
                throw new IOException(Msg.getString("K002c", spec));
            }
            this.osHandle = this.openImpl2(spec);
            this.portName = spec;
            openConnections.put(this.portName, "");
        } else {
            this.osHandle = this.openImpl(portNum);
        }
        this.configureImpl(this.osHandle, baudrate, bitsPerChar, stopBits, parity, autoRTS, autoCTS, this.timeout);
        this.open = true;
    }

    private native int openImpl(int var1) throws IOException;

    private native int openImpl2(String var1) throws IOException;

    private native void configureImpl(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7, int var8) throws IOException;

    public void close() throws IOException {
        if (this.open) {
            if (this.inputStatus != 1 && this.outputStatus != 1) {
                this.finalBaud = this.getBaud(this.osHandle);
                this.closeImpl(this.osHandle);
                openConnections.remove(this.portName);
            }
            this.open = false;
        }
    }

    private native void closeImpl(int var1) throws IOException;

    void closeStream(boolean inputStream) throws IOException {
        boolean closeConn = false;
        if (inputStream) {
            this.inputStatus = 2;
            closeConn = this.outputStatus != 1 && !this.open;
        } else {
            this.outputStatus = 2;
            boolean bl = closeConn = this.inputStatus != 1 && !this.open;
        }
        if (closeConn) {
            this.finalBaud = this.getBaud(this.osHandle);
            this.closeImpl(this.osHandle);
            openConnections.remove(this.portName);
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.open) {
            if (this.inputStatus != 0) {
                throw new IOException(Msg.getString("K0192"));
            }
            if (this.access == 1 || this.access == 3) {
                this.inputStatus = 1;
                return new CommInputStream(this);
            }
            throw new IOException(Msg.getString("K00a9"));
        }
        throw new IOException(Msg.getString("K00ac"));
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.open) {
            if (this.outputStatus != 0) {
                throw new IOException(Msg.getString("K0192"));
            }
            if (this.access == 2 || this.access == 3) {
                this.outputStatus = 1;
                return new CommOutputStream(this);
            }
            throw new IOException(Msg.getString("K00aa"));
        }
        throw new IOException(Msg.getString("K00ac"));
    }

    int read(byte[] b, int off, int len) throws IOException {
        if (len != 0) {
            int bytesRead;
            long startTime = System.currentTimeMillis();
            do {
                if ((bytesRead = this.readImpl(this.osHandle, b, off, len)) <= 0) continue;
                return bytesRead;
            } while (bytesRead == 0 && System.currentTimeMillis() - startTime < (long)this.timeout);
            if (!this.throwTimeout) {
                return bytesRead;
            }
            InterruptedIOException e = new InterruptedIOException(Msg.getString("K00df"));
            e.bytesTransferred = bytesRead;
            throw e;
        }
        return 0;
    }

    private native int readImpl(int var1, byte[] var2, int var3, int var4) throws IOException;

    int write(byte[] b, int off, int len) throws IOException {
        if (len != 0) {
            int bytesWritten = this.writeImpl(this.osHandle, b, off, len);
            if (!this.throwTimeout || bytesWritten == len) {
                return bytesWritten;
            }
            InterruptedIOException e = new InterruptedIOException(Msg.getString("K00df"));
            e.bytesTransferred = bytesWritten;
            throw e;
        }
        return 0;
    }

    private native int writeImpl(int var1, byte[] var2, int var3, int var4) throws IOException;

    int available() throws IOException {
        return this.availableImpl(this.osHandle);
    }

    private native int availableImpl(int var1) throws IOException;

    public int getBaudRate() {
        if (this.open || this.outputStatus == 1 || this.inputStatus == 1) {
            return this.getBaud(this.osHandle);
        }
        return this.finalBaud;
    }

    public int setBaudRate(int rate) {
        if (this.open || this.inputStatus == 1 || this.outputStatus == 1) {
            switch (rate) {
                case 300: 
                case 1200: 
                case 2400: 
                case 4800: 
                case 9600: 
                case 19200: 
                case 38400: 
                case 57600: 
                case 115200: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(rate));
                }
            }
            return this.setBaud(this.osHandle, rate);
        }
        return this.finalBaud;
    }

    private native int setBaud(int var1, int var2);

    private native int getBaud(int var1);
}

