/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.socket;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.socket.Socket;
import com.ibm.oti.connection.socket.SocketHelper;
import com.ibm.oti.util.Msg;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.SocketConnection;

public class Connection
implements CreateConnection,
SocketConnection {
    static final int DEFAULT_TIMEOUT = 8000;
    private static final int UNOPENED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private String host;
    private int access;
    private int port = 0;
    private int timeout = 0;
    private int inputStatus = 0;
    private int outputStatus = 0;
    private java.net.Socket socket;

    public Connection() {
    }

    public Connection(java.net.Socket socket) {
        this.host = "";
        this.access = 3;
        this.socket = socket;
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        if (spec.startsWith("//") && (spec.length() == 2 || spec.length() > 2 && (spec.charAt(2) == ':' || spec.charAt(2) == ';'))) {
            Class connectionClass = null;
            try {
                connectionClass = Class.forName("com.ibm.oti.connection.serversocket.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConnectionNotFoundException(Msg.getString("K0002", "serversocket"));
            }
            boolean exception = false;
            CreateConnection connection = null;
            try {
                connection = (CreateConnection)connectionClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                exception = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                exception = true;
            }
            if (exception) {
                throw new ConnectionNotFoundException(Msg.getString("K0003", connectionClass));
            }
            return connection.setParameters2(spec, access, timeout);
        }
        this.setParameters(spec, access, timeout);
        return this;
    }

    private void setParameters(String spec, int access, boolean timeout) throws IOException {
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
    }

    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        int[] result = new int[1];
        boolean setNoDelay = false;
        boolean setKeepAlive = false;
        int linger = -1;
        int rcvbuf = 0;
        int sndbuf = 0;
        int i = 0;
        while (i < equates.length) {
            String value;
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (ConnectionUtil.intParam("so_timeout", equates[i], 1, result)) {
                this.timeout = result[0];
            } else if (ConnectionUtil.intParam("so_linger", equates[i], 1, result)) {
                linger = result[0];
                if (linger > 65535) {
                    linger = 65535;
                }
            } else if (equates[i][0].equals("tcp_nodelay")) {
                value = equates[i][1].toLowerCase();
                if (value.equals("true")) {
                    setNoDelay = true;
                } else if (!value.equals("false")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5", equates[i][1]));
                }
            } else if (equates[i][0].equals("so_keepalive")) {
                value = equates[i][1].toLowerCase();
                if (value.equals("true")) {
                    setKeepAlive = true;
                } else if (!value.equals("false")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5", equates[i][1]));
                }
            } else if (ConnectionUtil.intParam("so_rcvbuf", equates[i], 2, result)) {
                rcvbuf = result[0];
            } else if (ConnectionUtil.intParam("so_sndbuf", equates[i], 2, result)) {
                sndbuf = result[0];
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
        if (throwTimeout && this.timeout == 0) {
            this.timeout = 8000;
        }
        this.host = spec;
        this.access = access;
        if (!this.host.startsWith("//")) {
            throw new IllegalArgumentException(Msg.getString("K01cc"));
        }
        this.host = SocketHelper.parseURL(spec, result, true, false);
        try {
            this.socket = new java.net.Socket(this.host, result[0]);
        }
        catch (UnknownHostException e) {
            throw new ConnectionNotFoundException(Msg.getString("K01ce", this.host, e.getMessage()));
        }
        catch (IOException e) {
            throw new ConnectionNotFoundException(Msg.getString("K01cf", String.valueOf(this.host) + ":" + result[0], e.getMessage()));
        }
        try {
            if (rcvbuf != 0) {
                this.socket.setReceiveBufferSize(rcvbuf);
            }
            if (sndbuf != 0) {
                this.socket.setSendBufferSize(sndbuf);
            }
            if (linger != -1) {
                this.socket.setSoLinger(true, linger);
            }
            if (setNoDelay) {
                this.socket.setTcpNoDelay(true);
            }
            if (setKeepAlive) {
                this.socket.setKeepAlive(true);
            }
            if (this.timeout != 0) {
                this.socket.setSoTimeout(this.timeout);
            }
        }
        catch (SocketException e) {
            if (this.socket != null) {
                this.socket.close();
            }
            throw new IOException(e.getMessage());
        }
    }

    public void close() throws IOException {
        this.host = null;
        if (this.inputStatus != 1 && this.outputStatus != 1) {
            this.socket.close();
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 1 && this.access != 3) {
            throw new IOException(Msg.getString("K00a9"));
        }
        if (this.inputStatus == 2) {
            throw new IOException(Msg.getString("K0059"));
        }
        this.inputStatus = 1;
        return new InputStream(){
            InputStream stream;
            {
                this.stream = Connection.this.socket.getInputStream();
            }

            public int available() throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return this.stream.available();
            }

            public long skip(int amount) throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return this.stream.skip(amount);
            }

            public void close() throws IOException {
                if (Connection.this.inputStatus != 2) {
                    Connection.this.inputStatus = 2;
                    if (Connection.this.outputStatus != 1 && Connection.this.host == null) {
                        this.stream.close();
                    }
                }
            }

            public int read(byte[] buffer, int offset, int count) throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                int result = this.stream.read(buffer, offset, count);
                return result;
            }

            public int read() throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return this.stream.read();
            }
        };
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2 && this.access != 3) {
            throw new IOException(Msg.getString("K00aa"));
        }
        if (this.outputStatus == 2) {
            throw new IOException(Msg.getString("K0059"));
        }
        this.outputStatus = 1;
        return new OutputStream(){
            OutputStream stream;
            {
                this.stream = Connection.this.socket.getOutputStream();
            }

            public void close() throws IOException {
                if (Connection.this.outputStatus != 2) {
                    if ((Socket.getSocketFlags() & 8) == 0 || Connection.this.socket.getSoLinger() == -1) {
                        Connection.this.socket.shutdownOutput();
                    }
                    Connection.this.outputStatus = 2;
                    if (Connection.this.inputStatus != 1 && Connection.this.host == null) {
                        this.stream.close();
                    }
                }
            }

            public void write(int oneByte) throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                this.stream.write(oneByte);
            }

            public void write(byte[] buffer, int offset, int count) throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                this.stream.write(buffer, offset, count);
            }

            public void flush() throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                this.stream.flush();
            }
        };
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public String getLocalAddress() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.socket.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.socket.getLocalPort();
    }

    public String getAddress() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getPort() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.socket.getPort();
    }

    public int getSocketOption(byte optname) throws IllegalArgumentException, IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        try {
            switch (optname) {
                case 0: {
                    return this.socket.getTcpNoDelay() ? 0 : 1;
                }
                case 2: {
                    return this.socket.getKeepAlive() ? 1 : 0;
                }
                case 1: {
                    int result = this.socket.getSoLinger();
                    return result == -1 ? 0 : result;
                }
                case 3: {
                    return this.socket.getReceiveBufferSize();
                }
                case 4: {
                    return this.socket.getSendBufferSize();
                }
            }
            throw new IllegalArgumentException(Msg.getString("K01c8"));
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public void setSocketOption(byte optname, int optval) throws IllegalArgumentException, IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (optval < 0) {
            throw new IllegalArgumentException(Msg.getString("K01c9"));
        }
        try {
            switch (optname) {
                case 0: {
                    this.socket.setTcpNoDelay(optval == 0);
                    break;
                }
                case 2: {
                    this.socket.setKeepAlive(optval != 0);
                    break;
                }
                case 1: {
                    this.socket.setSoLinger(optval != 0, optval);
                    break;
                }
                case 3: {
                    this.socket.setReceiveBufferSize(optval);
                    break;
                }
                case 4: {
                    this.socket.setSendBufferSize(optval);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Msg.getString("K01c8"));
                }
            }
        }
        catch (IOException iOException) {}
    }

    public int getTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (IOException iOException) {
            return 0;
        }
    }
}

