/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.crypto;

import com.ibm.oti.util.Msg;
import java.io.IOException;

public final class Util {
    static byte[] padPKCS5(byte[] data, int offset, int numDataBytes, int blockSize) {
        byte[] block = new byte[blockSize];
        if (data.length > 0) {
            System.arraycopy((Object)data, offset, (Object)block, 0, numDataBytes);
        }
        int padlen = blockSize - numDataBytes;
        int i = numDataBytes;
        while (i < blockSize) {
            block[i] = (byte)padlen;
            ++i;
        }
        return block;
    }

    static byte[] unpadPKCS5(byte[] block) throws IOException {
        int blockSize = block.length;
        byte padlen = block[blockSize - 1];
        if (padlen < 1 || padlen > blockSize) {
            throw new IOException(Msg.getString("K01f7"));
        }
        if (padlen == blockSize) {
            return new byte[0];
        }
        byte[] unpadded = new byte[blockSize - padlen];
        System.arraycopy((Object)block, 0, (Object)unpadded, 0, blockSize - padlen);
        return unpadded;
    }

    static byte[] padTLS10(byte[] data, int offset, int numDataBytes, int dataBlockSize) {
        byte[] block = new byte[dataBlockSize];
        System.arraycopy((Object)data, offset, (Object)block, 0, numDataBytes);
        int padlen = dataBlockSize - numDataBytes;
        int i = numDataBytes;
        while (i < dataBlockSize) {
            block[i] = (byte)(padlen - 1);
            ++i;
        }
        return block;
    }

    static byte[] unpadTLS10(byte[] block) throws IOException {
        int padlen = block[block.length - 1] + 1;
        if (padlen < 1 || padlen > 256) {
            throw new IOException(Msg.getString("K01f7"));
        }
        if (padlen == block.length) {
            return new byte[0];
        }
        byte[] unpadded = new byte[block.length - padlen];
        System.arraycopy((Object)block, 0, (Object)unpadded, 0, unpadded.length);
        return unpadded;
    }

    static byte[] padSSL(byte[] data, int offset, int numDataBytes, int dataBlockSize) throws IOException {
        byte[] tmpBlock = new byte[dataBlockSize];
        int padlen = dataBlockSize - numDataBytes;
        if (numDataBytes > 0) {
            System.arraycopy((Object)data, offset, (Object)tmpBlock, 0, numDataBytes);
        }
        int i = numDataBytes;
        while (i < dataBlockSize - 1) {
            tmpBlock[i] = 0;
            ++i;
        }
        tmpBlock[dataBlockSize - 1] = (byte)(padlen - 1);
        return tmpBlock;
    }

    static byte[] unpadSSL(byte[] block) throws IOException {
        int padlen = block[block.length - 1] + 1;
        if (padlen < 1 || padlen > block.length) {
            throw new IOException(Msg.getString("K01f7"));
        }
        if (padlen == block.length) {
            return new byte[0];
        }
        byte[] unpadded = new byte[block.length - padlen];
        System.arraycopy((Object)block, 0, (Object)unpadded, 0, unpadded.length);
        return unpadded;
    }

    public static byte[] concatenate(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length + b2.length];
        System.arraycopy((Object)b1, 0, (Object)result, 0, b1.length);
        System.arraycopy((Object)b2, 0, (Object)result, b1.length, b2.length);
        return result;
    }
}

