/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang.reflect;

import com.ibm.oti.lang.reflect.ProxyConstantPool;
import com.ibm.oti.lang.reflect.ProxyConstants;
import com.ibm.oti.lang.reflect.ProxyMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;

public final class ProxyClassFile
implements ProxyConstants {
    private ProxyConstantPool constantPool;
    byte[] header = new byte[500];
    int headerOffset;
    private byte[] contents;
    private int contentsOffset;
    private int constantPoolOffset;
    private ProxyMethod[] proxyMethods;
    private static final int INITIAL_CONTENTS_SIZE = 1000;
    private static final int INITIAL_HEADER_SIZE = 500;
    private static final int INCREMENT_SIZE = 250;
    private static Method ObjectEqualsMethod;
    private static Method ObjectHashCodeMethod;
    private static Method ObjectToStringMethod;
    private static Method ClassForNameMethod;
    private static Method ClassGetMethod;
    private static Method HandlerInvokeMethod;
    private static Constructor ProxyConstructor;
    private static Constructor UndeclaredThrowableExceptionConstructor;
    private static Field ProxyHandlerField;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;

    public static byte[] generateBytes(String typeName, Class[] interfaces) {
        ProxyClassFile classFile = new ProxyClassFile(typeName, interfaces);
        classFile.addFields();
        classFile.findMethods(interfaces);
        classFile.addMethods();
        classFile.addAttributes();
        return classFile.getBytes();
    }

    static char[] getConstantPoolName(Class c) {
        if (c.isArray()) {
            return c.getName().replace('.', '/').toCharArray();
        }
        if (c.isPrimitive()) {
            if (c == Void.TYPE) {
                return new char[]{'V'};
            }
            if (c == Integer.TYPE) {
                return new char[]{'I'};
            }
            if (c == Boolean.TYPE) {
                return new char[]{'Z'};
            }
            if (c == Byte.TYPE) {
                return new char[]{'B'};
            }
            if (c == Character.TYPE) {
                return new char[]{'C'};
            }
            if (c == Short.TYPE) {
                return new char[]{'S'};
            }
            if (c == Long.TYPE) {
                return new char[]{'J'};
            }
            if (c == Float.TYPE) {
                return new char[]{'F'};
            }
            if (c == Double.TYPE) {
                return new char[]{'D'};
            }
        }
        return ("L" + c.getName().replace('.', '/') + ";").toCharArray();
    }

    static char[] getConstantPoolName(Constructor method) {
        Class[] parameters = method.getParameterTypes();
        StringBuffer buffer = new StringBuffer(parameters.length + 20);
        buffer.append('(');
        int i = 0;
        int length = parameters.length;
        while (i < length) {
            buffer.append(ProxyClassFile.getConstantPoolName(parameters[i]));
            ++i;
        }
        buffer.append(')');
        buffer.append(ProxyClassFile.getConstantPoolName(Void.TYPE));
        return buffer.toString().toCharArray();
    }

    static char[] getConstantPoolName(Method method) {
        Class[] parameters = method.getParameterTypes();
        StringBuffer buffer = new StringBuffer(parameters.length + 20);
        buffer.append('(');
        int i = 0;
        int length = parameters.length;
        while (i < length) {
            buffer.append(ProxyClassFile.getConstantPoolName(parameters[i]));
            ++i;
        }
        buffer.append(')');
        buffer.append(ProxyClassFile.getConstantPoolName(method.getReturnType()));
        return buffer.toString().toCharArray();
    }

    ProxyClassFile(String typeName, Class[] interfaces) {
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        this.header[this.headerOffset++] = 0;
        this.header[this.headerOffset++] = 0;
        this.header[this.headerOffset++] = 0;
        this.header[this.headerOffset++] = 46;
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool = new ProxyConstantPool(this);
        this.contents = new byte[1000];
        int accessFlags = 49;
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int classNameIndex = this.constantPool.typeIndex(typeName);
        this.contents[this.contentsOffset++] = (byte)(classNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)classNameIndex;
        int superclassNameIndex = this.constantPool.typeIndex("java/lang/reflect/Proxy");
        this.contents[this.contentsOffset++] = (byte)(superclassNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)superclassNameIndex;
        int interfacesCount = interfaces.length;
        this.contents[this.contentsOffset++] = (byte)(interfacesCount >> 8);
        this.contents[this.contentsOffset++] = (byte)interfacesCount;
        int i = 0;
        while (i < interfacesCount) {
            int interfaceIndex = this.constantPool.typeIndex(interfaces[i].getName());
            this.contents[this.contentsOffset++] = (byte)(interfaceIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)interfaceIndex;
            ++i;
        }
    }

    private void addAttributes() {
        this.writeUnsignedShort(0);
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int constantPoolCount = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(constantPoolCount >> 8);
        this.header[this.constantPoolOffset] = (byte)constantPoolCount;
    }

    private void addFields() {
        this.writeUnsignedShort(0);
    }

    private void addMethods() {
        int methodCount = this.proxyMethods.length;
        this.writeUnsignedShort(methodCount + 1);
        this.writeUnsignedShort(1);
        this.writeUnsignedShort(this.constantPool.literalIndex(Init));
        if (ProxyConstructor == null) {
            try {
                Class clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.lang.reflect.Proxy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[1];
                Class clazz2 = class$10;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$10 = Class.forName("java.lang.reflect.InvocationHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                ProxyConstructor = clazz.getDeclaredConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        this.writeUnsignedShort(this.constantPool.literalIndex(ProxyClassFile.getConstantPoolName(ProxyConstructor)));
        this.writeUnsignedShort(1);
        this.writeUnsignedShort(this.constantPool.literalIndex(CodeName));
        int codeLength = 6;
        this.writeUnsignedWord(12 + codeLength);
        this.writeUnsignedShort(2);
        this.writeUnsignedShort(2);
        this.writeUnsignedWord(codeLength);
        this.writeUnsignedByte(42);
        this.writeUnsignedByte(43);
        this.writeUnsignedByte(183);
        this.writeUnsignedShort(this.constantPool.literalIndex(ProxyConstructor));
        this.writeUnsignedByte(177);
        this.writeUnsignedShort(0);
        this.writeUnsignedShort(0);
        int i = 0;
        while (i < methodCount) {
            ProxyMethod pMethod = this.proxyMethods[i];
            Method method = pMethod.method;
            this.writeUnsignedShort(17);
            this.writeUnsignedShort(this.constantPool.literalIndex(method.getName().toCharArray()));
            this.writeUnsignedShort(this.constantPool.literalIndex(ProxyClassFile.getConstantPoolName(method)));
            Class[] thrownsExceptions = pMethod.commonExceptions;
            int eLength = thrownsExceptions.length;
            if (eLength > 0) {
                this.writeUnsignedShort(2);
                this.writeUnsignedShort(this.constantPool.literalIndex(ExceptionsName));
                this.writeUnsignedWord(eLength * 2 + 2);
                this.writeUnsignedShort(eLength);
                int e = 0;
                while (e < eLength) {
                    this.writeUnsignedShort(this.constantPool.typeIndex(thrownsExceptions[e].getName()));
                    ++e;
                }
            } else {
                this.writeUnsignedShort(1);
            }
            this.generateCodeAttribute(pMethod);
            ++i;
        }
    }

    private void findMethods(Class[] interfaces) {
        if (ObjectEqualsMethod == null) {
            try {
                Class clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = class$11 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[1];
                Class clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                ObjectEqualsMethod = clazz.getMethod("equals", classArray);
                Class clazz3 = class$11;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$11 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ObjectHashCodeMethod = clazz3.getMethod("hashCode", new Class[0]);
                Class clazz4 = class$11;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$11 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ObjectToStringMethod = clazz4.getMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        ArrayList allMethods = new ArrayList(25);
        allMethods.add(new ProxyMethod(ObjectEqualsMethod));
        allMethods.add(new ProxyMethod(ObjectHashCodeMethod));
        allMethods.add(new ProxyMethod(ObjectToStringMethod));
        HashSet interfacesSeen = new HashSet();
        int i = 0;
        int length = interfaces.length;
        while (i < length) {
            this.findMethods(interfaces[i], allMethods, interfacesSeen);
            ++i;
        }
        this.proxyMethods = new ProxyMethod[allMethods.size()];
        allMethods.toArray(this.proxyMethods);
    }

    private void findMethods(Class nextInterface, ArrayList allMethods, HashSet interfacesSeen) {
        if (interfacesSeen.contains(nextInterface)) {
            return;
        }
        interfacesSeen.add(nextInterface);
        int existingMethodCount = allMethods.size();
        Method[] methods = nextInterface.getMethods();
        int i = 0;
        int length = methods.length;
        while (i < length) {
            block5: {
                Method method = methods[i];
                int j = 0;
                while (j < existingMethodCount) {
                    if (!((ProxyMethod)allMethods.get(j)).matchMethod(method)) {
                        ++j;
                        continue;
                    }
                    break block5;
                }
                allMethods.add(new ProxyMethod(method));
            }
            ++i;
        }
        Class[] superInterfaces = nextInterface.getInterfaces();
        int i2 = 0;
        int length2 = superInterfaces.length;
        while (i2 < length2) {
            this.findMethods(superInterfaces[i2], allMethods, interfacesSeen);
            ++i2;
        }
    }

    private void generateCodeAttribute(ProxyMethod pMethod) {
        int codeAttributeOffset = this.contentsOffset;
        int contentsLength = this.contents.length;
        if (this.contentsOffset + 20 + 100 >= contentsLength) {
            this.contents = new byte[contentsLength + 250];
            System.arraycopy((Object)this.contents, 0, (Object)this.contents, 0, contentsLength);
        }
        this.writeUnsignedShort(this.constantPool.literalIndex(CodeName));
        this.contentsOffset += 12;
        int codeStartOffset = this.contentsOffset;
        this.writeUnsignedByte(42);
        this.writeUnsignedByte(180);
        if (ProxyHandlerField == null) {
            try {
                Class clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.lang.reflect.Proxy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ProxyHandlerField = clazz.getDeclaredField("h");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InternalError();
            }
        }
        this.writeUnsignedShort(this.constantPool.literalIndex(ProxyHandlerField));
        this.writeUnsignedByte(42);
        Method method = pMethod.method;
        Class[] argTypes = method.getParameterTypes();
        this.genCallGetMethod(method.getDeclaringClass(), method.getName(), argTypes);
        int maxLocals = this.genInvokeArgs(argTypes);
        this.writeUnsignedByte(185);
        if (HandlerInvokeMethod == null) {
            try {
                Class clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = class$10 = Class.forName("java.lang.reflect.InvocationHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[3];
                Class clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class clazz3 = class$12;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$12 = Class.forName("java.lang.reflect.Method");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Class clazz4 = class$13;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$13 = Class.forName("[Ljava.lang.Object;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz4;
                HandlerInvokeMethod = clazz.getMethod("invoke", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        this.writeUnsignedShort(this.constantPool.literalIndex(HandlerInvokeMethod));
        this.writeUnsignedByte(4);
        this.writeUnsignedByte(0);
        this.genCastReturnType(method.getReturnType());
        int codeLength = this.contentsOffset - codeStartOffset;
        Class[] checkedExceptions = pMethod.getCheckedExceptions();
        int checkedLength = checkedExceptions.length;
        if (checkedLength > 0) {
            int codeEndIndex = this.contentsOffset - codeStartOffset;
            this.writeUnsignedByte(191);
            this.genStoreArg(maxLocals);
            this.writeUnsignedByte(187);
            this.writeUnsignedShort(this.constantPool.typeIndex("java/lang/reflect/UndeclaredThrowableException"));
            this.writeUnsignedByte(89);
            this.genLoadArg(maxLocals);
            ++maxLocals;
            this.writeUnsignedByte(183);
            if (UndeclaredThrowableExceptionConstructor == null) {
                try {
                    Class clazz = class$14;
                    if (clazz == null) {
                        try {
                            clazz = class$14 = Class.forName("java.lang.reflect.UndeclaredThrowableException");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class[] classArray = new Class[1];
                    Class clazz5 = class$15;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$15 = Class.forName("java.lang.Throwable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz5;
                    UndeclaredThrowableExceptionConstructor = clazz.getConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
            }
            this.writeUnsignedShort(this.constantPool.literalIndex(UndeclaredThrowableExceptionConstructor));
            this.writeUnsignedByte(191);
            codeLength = this.contentsOffset - codeStartOffset;
            this.writeUnsignedShort(checkedLength + 1);
            int i = 0;
            while (i < checkedLength) {
                this.writeUnsignedShort(0);
                this.writeUnsignedShort(codeEndIndex);
                this.writeUnsignedShort(codeEndIndex);
                this.writeUnsignedShort(this.constantPool.typeIndex(checkedExceptions[i].getName()));
                ++i;
            }
            this.writeUnsignedShort(0);
            this.writeUnsignedShort(codeEndIndex);
            this.writeUnsignedShort(codeEndIndex + 1);
            this.writeUnsignedShort(this.constantPool.typeIndex("java/lang/Throwable"));
        } else {
            this.writeUnsignedShort(0);
        }
        this.writeUnsignedShort(0);
        int codeAttributeLength = this.contentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        int maxStack = maxLocals + 10;
        this.contents[codeAttributeOffset + 6] = (byte)(maxStack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)maxStack;
        this.contents[codeAttributeOffset + 8] = (byte)(maxLocals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)maxLocals;
        this.contents[codeAttributeOffset + 10] = (byte)(codeLength >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(codeLength >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(codeLength >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)codeLength;
    }

    private void genCallGetMethod(Class receiverType, String selector, Class[] argTypes) {
        this.genCallClassForName(receiverType.getName());
        this.writeLdc(selector);
        int length = argTypes.length;
        this.writeIntConstant(length);
        this.writeUnsignedByte(189);
        this.writeUnsignedShort(this.constantPool.typeIndex("java/lang/Class"));
        int i = 0;
        while (i < length) {
            this.writeUnsignedByte(89);
            this.writeIntConstant(i);
            Class type = argTypes[i];
            if (type.isPrimitive()) {
                this.writeUnsignedByte(178);
                this.writeUnsignedShort(this.constantPool.literalIndex(this.typeField(type)));
            } else {
                this.genCallClassForName(type.getName());
            }
            this.writeUnsignedByte(83);
            ++i;
        }
        this.writeUnsignedByte(182);
        if (ClassGetMethod == null) {
            try {
                Class clazz = class$16;
                if (clazz == null) {
                    try {
                        clazz = class$16 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[2];
                Class clazz2 = class$17;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$17 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class clazz3 = class$18;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$18 = Class.forName("[Ljava.lang.Class;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                ClassGetMethod = clazz.getMethod("getMethod", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        this.writeUnsignedShort(this.constantPool.literalIndex(ClassGetMethod));
    }

    private int genInvokeArgs(Class[] argTypes) {
        int argByteOffset = 1;
        int length = argTypes.length;
        if (length == 0) {
            this.writeUnsignedByte(1);
        } else {
            this.writeIntConstant(length);
            this.writeUnsignedByte(189);
            this.writeUnsignedShort(this.constantPool.typeIndex("java/lang/Object"));
            int i = 0;
            while (i < length) {
                this.writeUnsignedByte(89);
                this.writeIntConstant(i);
                argByteOffset = this.genInvokeArg(argTypes[i], argByteOffset);
                this.writeUnsignedByte(83);
                ++i;
            }
        }
        return argByteOffset;
    }

    private int genInvokeArg(Class type, int argByteOffset) {
        if (type.isPrimitive()) {
            this.writeUnsignedByte(187);
            this.writeUnsignedShort(this.constantPool.typeIndex(this.typeWrapperName(type)));
            this.writeUnsignedByte(89);
            if (argByteOffset > 255) {
                this.writeUnsignedByte(196);
            }
            if (type == Long.TYPE) {
                switch (argByteOffset) {
                    case 0: {
                        this.writeUnsignedByte(30);
                        break;
                    }
                    case 1: {
                        this.writeUnsignedByte(31);
                        break;
                    }
                    case 2: {
                        this.writeUnsignedByte(32);
                        break;
                    }
                    case 3: {
                        this.writeUnsignedByte(33);
                        break;
                    }
                    default: {
                        this.writeUnsignedByte(22);
                        if (argByteOffset > 255) {
                            this.writeUnsignedShort(argByteOffset);
                            break;
                        }
                        this.writeUnsignedByte(argByteOffset);
                    }
                }
                argByteOffset += 2;
            } else if (type == Float.TYPE) {
                switch (argByteOffset) {
                    case 0: {
                        this.writeUnsignedByte(34);
                        break;
                    }
                    case 1: {
                        this.writeUnsignedByte(35);
                        break;
                    }
                    case 2: {
                        this.writeUnsignedByte(36);
                        break;
                    }
                    case 3: {
                        this.writeUnsignedByte(37);
                        break;
                    }
                    default: {
                        this.writeUnsignedByte(23);
                        if (argByteOffset > 255) {
                            this.writeUnsignedShort(argByteOffset);
                            break;
                        }
                        this.writeUnsignedByte(argByteOffset);
                    }
                }
                ++argByteOffset;
            } else if (type == Double.TYPE) {
                switch (argByteOffset) {
                    case 0: {
                        this.writeUnsignedByte(38);
                        break;
                    }
                    case 1: {
                        this.writeUnsignedByte(39);
                        break;
                    }
                    case 2: {
                        this.writeUnsignedByte(40);
                        break;
                    }
                    case 3: {
                        this.writeUnsignedByte(41);
                        break;
                    }
                    default: {
                        this.writeUnsignedByte(24);
                        if (argByteOffset > 255) {
                            this.writeUnsignedShort(argByteOffset);
                            break;
                        }
                        this.writeUnsignedByte(argByteOffset);
                    }
                }
                argByteOffset += 2;
            } else {
                switch (argByteOffset) {
                    case 0: {
                        this.writeUnsignedByte(26);
                        break;
                    }
                    case 1: {
                        this.writeUnsignedByte(27);
                        break;
                    }
                    case 2: {
                        this.writeUnsignedByte(28);
                        break;
                    }
                    case 3: {
                        this.writeUnsignedByte(29);
                        break;
                    }
                    default: {
                        this.writeUnsignedByte(21);
                        if (argByteOffset > 255) {
                            this.writeUnsignedShort(argByteOffset);
                            break;
                        }
                        this.writeUnsignedByte(argByteOffset);
                    }
                }
                ++argByteOffset;
            }
            this.writeUnsignedByte(183);
            this.writeUnsignedShort(this.constantPool.literalIndex(this.typeInitMethod(type)));
        } else {
            this.genLoadArg(argByteOffset);
            ++argByteOffset;
        }
        return argByteOffset;
    }

    private void genCastReturnType(Class type) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                this.writeUnsignedByte(87);
                this.writeUnsignedByte(177);
            } else {
                this.writeUnsignedByte(192);
                this.writeUnsignedShort(this.constantPool.typeIndex(this.typeWrapperName(type)));
                this.writeUnsignedByte(182);
                this.writeUnsignedShort(this.constantPool.literalIndex(this.typeAccessMethod(type)));
                if (type == Long.TYPE) {
                    this.writeUnsignedByte(173);
                } else if (type == Float.TYPE) {
                    this.writeUnsignedByte(174);
                } else if (type == Double.TYPE) {
                    this.writeUnsignedByte(175);
                } else {
                    this.writeUnsignedByte(172);
                }
            }
        } else {
            this.writeUnsignedByte(192);
            this.writeUnsignedShort(this.constantPool.typeIndex(type.getName()));
            this.writeUnsignedByte(176);
        }
    }

    private void genCallClassForName(String typeName) {
        this.writeLdc(typeName);
        this.writeUnsignedByte(184);
        if (ClassForNameMethod == null) {
            try {
                Class clazz = class$16;
                if (clazz == null) {
                    try {
                        clazz = class$16 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[1];
                Class clazz2 = class$17;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$17 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                ClassForNameMethod = clazz.getMethod("forName", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        this.writeUnsignedShort(this.constantPool.literalIndex(ClassForNameMethod));
    }

    private void genLoadArg(int argByteOffset) {
        if (argByteOffset > 255) {
            this.writeUnsignedByte(196);
            this.writeUnsignedByte(25);
            this.writeUnsignedShort(argByteOffset);
        } else {
            switch (argByteOffset) {
                case 0: {
                    this.writeUnsignedByte(42);
                    break;
                }
                case 1: {
                    this.writeUnsignedByte(43);
                    break;
                }
                case 2: {
                    this.writeUnsignedByte(44);
                    break;
                }
                case 3: {
                    this.writeUnsignedByte(45);
                    break;
                }
                default: {
                    this.writeUnsignedByte(25);
                    this.writeUnsignedByte(argByteOffset);
                }
            }
        }
    }

    private void genStoreArg(int argByteOffset) {
        if (argByteOffset > 255) {
            this.writeUnsignedByte(196);
            this.writeUnsignedByte(58);
            this.writeUnsignedShort(argByteOffset);
        } else {
            switch (argByteOffset) {
                case 0: {
                    this.writeUnsignedByte(75);
                    break;
                }
                case 1: {
                    this.writeUnsignedByte(76);
                    break;
                }
                case 2: {
                    this.writeUnsignedByte(77);
                    break;
                }
                case 3: {
                    this.writeUnsignedByte(78);
                    break;
                }
                default: {
                    this.writeUnsignedByte(58);
                    this.writeUnsignedByte(argByteOffset);
                }
            }
        }
    }

    private byte[] getBytes() {
        byte[] fullContents = new byte[this.headerOffset + this.contentsOffset];
        System.arraycopy((Object)this.header, 0, (Object)fullContents, 0, this.headerOffset);
        System.arraycopy((Object)this.contents, 0, (Object)fullContents, this.headerOffset, this.contentsOffset);
        return fullContents;
    }

    private Method typeAccessMethod(Class baseType) {
        block40: {
            try {
                if (baseType == Integer.TYPE) {
                    Class clazz = class$19;
                    if (clazz == null) {
                        try {
                            clazz = class$19 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("intValue", null);
                }
                if (baseType == Short.TYPE) {
                    Class clazz = class$20;
                    if (clazz == null) {
                        try {
                            clazz = class$20 = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("shortValue", null);
                }
                if (baseType == Byte.TYPE) {
                    Class clazz = class$21;
                    if (clazz == null) {
                        try {
                            clazz = class$21 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("byteValue", null);
                }
                if (baseType == Boolean.TYPE) {
                    Class clazz = class$22;
                    if (clazz == null) {
                        try {
                            clazz = class$22 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("booleanValue", null);
                }
                if (baseType == Character.TYPE) {
                    Class clazz = class$23;
                    if (clazz == null) {
                        try {
                            clazz = class$23 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("charValue", null);
                }
                if (baseType == Long.TYPE) {
                    Class clazz = class$24;
                    if (clazz == null) {
                        try {
                            clazz = class$24 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("longValue", null);
                }
                if (baseType == Float.TYPE) {
                    Class clazz = class$25;
                    if (clazz == null) {
                        try {
                            clazz = class$25 = Class.forName("java.lang.Float");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getMethod("floatValue", null);
                }
                if (baseType != Double.TYPE) break block40;
                Class clazz = class$26;
                if (clazz == null) {
                    try {
                        clazz = class$26 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz.getMethod("doubleValue", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        return null;
    }

    private Field typeField(Class baseType) {
        block40: {
            try {
                if (baseType == Integer.TYPE) {
                    Class clazz = class$19;
                    if (clazz == null) {
                        try {
                            clazz = class$19 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType == Short.TYPE) {
                    Class clazz = class$20;
                    if (clazz == null) {
                        try {
                            clazz = class$20 = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType == Byte.TYPE) {
                    Class clazz = class$21;
                    if (clazz == null) {
                        try {
                            clazz = class$21 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType == Boolean.TYPE) {
                    Class clazz = class$22;
                    if (clazz == null) {
                        try {
                            clazz = class$22 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType == Character.TYPE) {
                    Class clazz = class$23;
                    if (clazz == null) {
                        try {
                            clazz = class$23 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType == Long.TYPE) {
                    Class clazz = class$24;
                    if (clazz == null) {
                        try {
                            clazz = class$24 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType == Float.TYPE) {
                    Class clazz = class$25;
                    if (clazz == null) {
                        try {
                            clazz = class$25 = Class.forName("java.lang.Float");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getField("TYPE");
                }
                if (baseType != Double.TYPE) break block40;
                Class clazz = class$26;
                if (clazz == null) {
                    try {
                        clazz = class$26 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz.getField("TYPE");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InternalError();
            }
        }
        return null;
    }

    private Constructor typeInitMethod(Class baseType) {
        block40: {
            try {
                if (baseType == Integer.TYPE) {
                    Class clazz = class$19;
                    if (clazz == null) {
                        try {
                            clazz = class$19 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Integer.TYPE});
                }
                if (baseType == Short.TYPE) {
                    Class clazz = class$20;
                    if (clazz == null) {
                        try {
                            clazz = class$20 = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Short.TYPE});
                }
                if (baseType == Byte.TYPE) {
                    Class clazz = class$21;
                    if (clazz == null) {
                        try {
                            clazz = class$21 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Byte.TYPE});
                }
                if (baseType == Boolean.TYPE) {
                    Class clazz = class$22;
                    if (clazz == null) {
                        try {
                            clazz = class$22 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Boolean.TYPE});
                }
                if (baseType == Character.TYPE) {
                    Class clazz = class$23;
                    if (clazz == null) {
                        try {
                            clazz = class$23 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Character.TYPE});
                }
                if (baseType == Long.TYPE) {
                    Class clazz = class$24;
                    if (clazz == null) {
                        try {
                            clazz = class$24 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Long.TYPE});
                }
                if (baseType == Float.TYPE) {
                    Class clazz = class$25;
                    if (clazz == null) {
                        try {
                            clazz = class$25 = Class.forName("java.lang.Float");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getConstructor(new Class[]{Float.TYPE});
                }
                if (baseType != Double.TYPE) break block40;
                Class clazz = class$26;
                if (clazz == null) {
                    try {
                        clazz = class$26 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz.getConstructor(new Class[]{Double.TYPE});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError();
            }
        }
        return null;
    }

    private String typeWrapperName(Class baseType) {
        if (baseType == Integer.TYPE) {
            return "java/lang/Integer";
        }
        if (baseType == Short.TYPE) {
            return "java/lang/Short";
        }
        if (baseType == Byte.TYPE) {
            return "java/lang/Byte";
        }
        if (baseType == Boolean.TYPE) {
            return "java/lang/Boolean";
        }
        if (baseType == Character.TYPE) {
            return "java/lang/Character";
        }
        if (baseType == Long.TYPE) {
            return "java/lang/Long";
        }
        if (baseType == Float.TYPE) {
            return "java/lang/Float";
        }
        if (baseType == Double.TYPE) {
            return "java/lang/Double";
        }
        return null;
    }

    private void writeIntConstant(int b) {
        switch (b) {
            case 0: {
                this.writeUnsignedByte(3);
                break;
            }
            case 1: {
                this.writeUnsignedByte(4);
                break;
            }
            case 2: {
                this.writeUnsignedByte(5);
                break;
            }
            case 3: {
                this.writeUnsignedByte(6);
                break;
            }
            case 4: {
                this.writeUnsignedByte(7);
                break;
            }
            case 5: {
                this.writeUnsignedByte(8);
                break;
            }
            default: {
                this.writeUnsignedByte(16);
                this.writeUnsignedByte(b);
            }
        }
    }

    private void writeLdc(String constant) {
        int index = this.constantPool.literalIndexForLdc(constant.toCharArray());
        if (index <= 0) {
            throw new InternalError();
        }
        if (index > 255) {
            this.writeUnsignedByte(19);
            this.writeUnsignedShort(index);
        } else {
            this.writeUnsignedByte(18);
            this.writeUnsignedByte(index);
        }
    }

    private void writeUnsignedByte(int b) {
        try {
            this.contents[this.contentsOffset++] = (byte)b;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int actualLength = this.contents.length;
            this.contents = new byte[actualLength + 250];
            System.arraycopy((Object)this.contents, 0, (Object)this.contents, 0, actualLength);
            this.contents[this.contentsOffset - 1] = (byte)b;
        }
    }

    private void writeUnsignedShort(int b) {
        this.writeUnsignedByte(b >>> 8);
        this.writeUnsignedByte(b);
    }

    private void writeUnsignedWord(int b) {
        this.writeUnsignedByte(b >>> 24);
        this.writeUnsignedByte(b >>> 16);
        this.writeUnsignedByte(b >>> 8);
        this.writeUnsignedByte(b);
    }
}

