/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.text;

import com.ibm.oti.text.Utility;
import com.ibm.oti.util.Msg;
import java.lang.reflect.Array;

public final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 5;
    private static final int BLOCKCOUNT = 32;
    private static final int INDEXSHIFT = 11;
    private static final int INDEXCOUNT = 2048;
    private static final int BLOCKMASK = 31;
    private char[] values;
    private char[] indices;
    private int[] hashes;
    private boolean isCompact;
    private char defaultValue;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CompactCharArray() {
        this('\u0000');
    }

    public CompactCharArray(char defaultValue) {
        this.values = new char[65536];
        this.indices = new char[2048];
        this.hashes = new int[2048];
        int i = 0;
        while (i < 65536) {
            this.values[i] = defaultValue;
            ++i;
        }
        i = 0;
        while (i < 2048) {
            this.indices[i] = (char)(i << 5);
            this.hashes[i] = 0;
            ++i;
        }
        this.isCompact = false;
        this.defaultValue = defaultValue;
    }

    public CompactCharArray(String indexArray, String valueArray) {
        this(Utility.RLEStringToCharArray(indexArray), Utility.RLEStringToCharArray(valueArray));
    }

    public CompactCharArray(char[] indexArray, char[] newValues) {
        if (indexArray.length != 2048) {
            throw new IllegalArgumentException(Msg.getString("K0013"));
        }
        int i = 0;
        while (i < 2048) {
            char index = indexArray[i];
            if (index < '\u0000' || index >= newValues.length + 32) {
                throw new IllegalArgumentException(Msg.getString("K0013"));
            }
            ++i;
        }
        this.indices = indexArray;
        this.values = newValues;
        this.isCompact = true;
    }

    public char elementAt(char index) {
        return this.values[(this.indices[index >> 5] & 0xFFFF) + (index & 0x1F)];
    }

    public void setElementAt(char index, char value) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[index] = value;
        this.touchBlock(index >> 5, value);
    }

    public void setElementAt(char start, char end, char value) {
        if (this.isCompact) {
            this.expand();
        }
        int i = start;
        while (i <= end) {
            this.values[i] = value;
            this.touchBlock(i >> 5, value);
            ++i;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int limitCompacted = 0;
            int iBlockStart = 0;
            int iUntouched = 65535;
            int i = 0;
            while (i < this.indices.length) {
                this.indices[i] = 65535;
                boolean touched = this.blockTouched(i);
                if (!touched && iUntouched != 65535) {
                    this.indices[i] = iUntouched;
                } else {
                    int jBlockStart = 0;
                    int j = 0;
                    j = 0;
                    while (j < limitCompacted) {
                        if (this.hashes[i] == this.hashes[j] && CompactCharArray.arrayRegionMatches(this.values, iBlockStart, this.values, jBlockStart, 32)) {
                            this.indices[i] = (char)jBlockStart;
                        }
                        ++j;
                        jBlockStart += 32;
                    }
                    if (this.indices[i] == '\uffff') {
                        System.arraycopy((Object)this.values, iBlockStart, (Object)this.values, jBlockStart, 32);
                        this.indices[i] = (char)jBlockStart;
                        this.hashes[j] = this.hashes[i];
                        ++limitCompacted;
                        if (!touched) {
                            iUntouched = (char)jBlockStart;
                        }
                    }
                }
                ++i;
                iBlockStart += 32;
            }
            int newSize = limitCompacted * 32;
            this.values = (char[])Utility.resizeArray(newSize, this.values, 0, newSize);
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(char[] source, int sourceStart, char[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (source[i] != target[i + delta]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final void touchBlock(int i, int value) {
        this.hashes[i] = this.hashes[i] + (value << 1) | 1;
    }

    private final boolean blockTouched(int i) {
        return this.hashes[i] != 0;
    }

    public char[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactCharArray other = (CompactCharArray)super.clone();
            other.values = (char[])this.values.clone();
            other.indices = (char[])this.indices.clone();
            if (this.hashes != null) {
                other.hashes = (int[])this.hashes.clone();
            }
            return other;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompactCharArray other = (CompactCharArray)obj;
        int i = 0;
        while (i < 65536) {
            if (this.elementAt((char)i) != other.elementAt((char)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        int increment = Math.min(3, this.values.length / 16);
        int i = 0;
        while (i < this.values.length) {
            result = result * 37 + this.values[i];
            i += increment;
        }
        return result;
    }

    private void expand() {
        if (this.isCompact) {
            char[] tempArray = (char[])Array.newInstance(Character.TYPE, 65536);
            this.hashes = (int[])Array.newInstance(Integer.TYPE, 2048);
            int i = 0;
            while (i < 65536) {
                char value;
                tempArray[i] = value = this.elementAt((char)i);
                this.touchBlock(i >> 5, value);
                ++i;
            }
            i = 0;
            while (i < 2048) {
                this.indices[i] = (char)(i << 5);
                ++i;
            }
            this.values = null;
            this.values = tempArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    private char getIndexArrayValue(int n) {
        return this.indices[n];
    }
}

