/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ASN1Encoder {
    private OutputStream output;

    public ASN1Encoder(OutputStream output) {
        this.output = output;
    }

    public static byte[] getEncoding(Object obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ASN1Encoder enc = new ASN1Encoder(out);
        try {
            enc.writeObject(obj);
        }
        catch (ASN1Exception aSN1Exception) {
            return null;
        }
        return out.toByteArray();
    }

    private static void writeByte(int oneByte, OutputStream out) throws ASN1Exception {
        try {
            out.write(oneByte);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private static void writeBytes(byte[] bytes, OutputStream out) throws ASN1Exception {
        try {
            out.write(bytes);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private static void writeTagNumber(int tag, OutputStream out) throws ASN1Exception {
        if (tag == 16 || tag == 17) {
            tag |= 0x20;
        }
        ASN1Encoder.writeByte(tag, out);
    }

    protected void writeTagNumber(int tag) throws ASN1Exception {
        ASN1Encoder.writeTagNumber(tag, this.output);
    }

    private static void writeInteger(BigInteger value, OutputStream out) throws ASN1Exception {
        byte[] representation = value.toByteArray();
        ASN1Encoder.writeTagNumber(2, out);
        ASN1Encoder.writeLength(representation.length, out);
        ASN1Encoder.writeBytes(representation, out);
    }

    private static void writeOctetString(byte[] bytes, OutputStream out) throws ASN1Exception {
        ASN1Encoder.writeTagNumber(4, out);
        ASN1Encoder.writeLength(bytes.length, out);
        ASN1Encoder.writeBytes(bytes, out);
    }

    protected void writeOctetString(byte[] bytes) throws ASN1Exception {
        ASN1Encoder.writeOctetString(bytes, this.output);
    }

    private static void writeBitString(ASN1Decoder.BitString bitString, OutputStream out) throws ASN1Exception {
        ASN1Encoder.writeTagNumber(3, out);
        ASN1Encoder.writeLength(bitString.data.length + 1, out);
        ASN1Encoder.writeByte(bitString.unusedBits, out);
        ASN1Encoder.writeBytes(bitString.data, out);
    }

    protected void writeBitString(ASN1Decoder.BitString bitString) throws ASN1Exception {
        ASN1Encoder.writeBitString(bitString, this.output);
    }

    private static void writeObjectIdentifier(int[] oid, OutputStream out) throws ASN1Exception {
        int i = 0;
        while (i < oid.length) {
            if (oid[i] < 0) {
                throw new ASN1Exception();
            }
            ++i;
        }
        if (oid.length < 2) {
            throw new ASN1Exception();
        }
        if (oid[1] > 39) {
            throw new ASN1Exception();
        }
        short firstByte = (short)(oid[0] * 40 + oid[1]);
        if (firstByte > 255 || firstByte < 0) {
            throw new ASN1Exception();
        }
        short[] bytesToWrite = new short[oid.length * 5];
        int byteIndex = 0;
        int i2 = oid.length - 1;
        while (i2 > 1) {
            int current = oid[i2];
            bytesToWrite[byteIndex++] = (short)(current & 0x7F);
            current /= 128;
            while (current > 0) {
                bytesToWrite[byteIndex++] = (short)((current & 0x7F) + 128);
                current /= 128;
            }
            --i2;
        }
        bytesToWrite[byteIndex] = firstByte;
        ASN1Encoder.writeTagNumber(6, out);
        ASN1Encoder.writeLength(byteIndex + 1, out);
        while (byteIndex >= 0) {
            ASN1Encoder.writeByte(bytesToWrite[byteIndex--], out);
        }
    }

    protected void writeObjectIdentifier(int[] oid) throws ASN1Exception {
        ASN1Encoder.writeObjectIdentifier(oid, this.output);
    }

    private static void writeLength(int len, OutputStream out) throws ASN1Exception {
        if (len < 128) {
            ASN1Encoder.writeByte(len, out);
            return;
        }
        short[] representation = new short[5];
        int i = 0;
        while (len > 0) {
            representation[i++] = (short)(len & 0xFF);
            len >>>= 8;
        }
        ASN1Encoder.writeByte(i | 0x80, out);
        while (--i >= 0) {
            ASN1Encoder.writeByte(representation[i], out);
        }
    }

    protected void writeLength(int len) throws ASN1Exception {
        ASN1Encoder.writeLength(len, this.output);
    }

    protected void writeInteger(BigInteger value) throws ASN1Exception {
        ASN1Encoder.writeInteger(value, this.output);
    }

    public void writeIntegers(BigInteger[] values) throws ASN1Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);
        int i = 0;
        while (i < values.length) {
            ASN1Encoder.writeInteger(values[i], buffer);
            ++i;
        }
        ASN1Encoder.writeTagNumber(16, this.output);
        ASN1Encoder.writeLength(buffer.size(), this.output);
        try {
            buffer.writeTo(this.output);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    protected void writeSequence(Object[] values) throws ASN1Exception {
        ASN1Encoder.writeSequence(values, this.output);
    }

    private static void writeSequence(Object[] values, OutputStream out) throws ASN1Exception {
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        int i = 0;
        while (i < values.length) {
            ASN1Encoder.writeObject(values[i], newOut);
            ++i;
        }
        ASN1Encoder.writeTagNumber(16, out);
        ASN1Encoder.writeLength(newOut.size(), out);
        try {
            newOut.writeTo(out);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    public void writeObject(Object value) throws ASN1Exception {
        ASN1Encoder.writeObject(value, this.output);
    }

    private static void writeObject(Object value, OutputStream out) throws ASN1Exception {
        if (value == null) {
            ASN1Encoder.writeTagNumber(5, out);
            ASN1Encoder.writeLength(0, out);
            return;
        }
        if (value instanceof BigInteger) {
            ASN1Encoder.writeInteger((BigInteger)value, out);
            return;
        }
        if (value instanceof byte[]) {
            ASN1Encoder.writeOctetString((byte[])value, out);
            return;
        }
        if (value instanceof int[]) {
            ASN1Encoder.writeObjectIdentifier((int[])value, out);
            return;
        }
        if (value instanceof Object[]) {
            ASN1Encoder.writeSequence((Object[])value, out);
            return;
        }
        if (value instanceof ASN1Decoder.BitString) {
            ASN1Encoder.writeBitString((ASN1Decoder.BitString)value, out);
            return;
        }
        if (value instanceof ASN1Decoder.UTCTime) {
            ASN1Encoder.writeUTCTime(((ASN1Decoder.UTCTime)value).utcTime, out);
            return;
        }
        if (value instanceof ASN1Decoder.GeneralizedTime) {
            ASN1Encoder.writeGeneralizedTime(((ASN1Decoder.GeneralizedTime)value).generalizedTime, out);
            return;
        }
        if (value instanceof ASN1Decoder.Set) {
            ASN1Encoder.writeSet(((ASN1Decoder.Set)value).sequence, out);
            return;
        }
        if (value instanceof ASN1Decoder.Set2) {
            ASN1Encoder.writeSet2(((ASN1Decoder.Set2)value).sequence, out);
            return;
        }
        if (value instanceof ASN1Decoder.CertificateSet) {
            ASN1Encoder.writeCertificateSet(((ASN1Decoder.CertificateSet)value).sequence, out);
            return;
        }
        if (value instanceof ASN1Decoder.Explicit) {
            ASN1Encoder.writeExplicit(((ASN1Decoder.Explicit)value).type, out);
            return;
        }
        if (value instanceof ASN1Decoder.BMPString) {
            ASN1Encoder.writeBMPString(((ASN1Decoder.BMPString)value).bmpString, out);
            return;
        }
        if (value instanceof String) {
            ASN1Encoder.writeUTF8String((String)value, out);
            return;
        }
        if (value instanceof ASN1Decoder.Data) {
            ASN1Encoder.writeBytes(((ASN1Decoder.Data)value).data, out);
            return;
        }
        if (value instanceof ASN1Decoder.ImplicitSet) {
            ASN1Encoder.writeImplicitSet(((ASN1Decoder.ImplicitSet)value).set, out, ((ASN1Decoder.ImplicitSet)value).tag);
            return;
        }
        ASN1Encoder.writeObjectTypeExtensions(value, out);
        throw new ASN1Exception();
    }

    private static StringBuffer getDateString(int[] date, int yearLength) {
        StringBuffer buf = new StringBuffer();
        if (yearLength > 4) {
            buf.append(date[0]);
        } else {
            if (date[0] < 10) {
                buf.append("0");
            }
            buf.append(date[0]);
        }
        int i = 1;
        while (i < date.length) {
            if (date[i] < 10) {
                buf.append("0");
            }
            buf.append(date[i]);
            ++i;
        }
        return buf;
    }

    private static void writeGeneralizedTime(Date generalizedTime, OutputStream out) throws ASN1Exception {
        int[] date = new int[6];
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(generalizedTime);
        date[0] = cal.get(1);
        date[1] = cal.get(2);
        date[2] = cal.get(5);
        date[3] = cal.get(2);
        date[4] = cal.get(12);
        date[5] = cal.get(13);
        StringBuffer buf = ASN1Encoder.getDateString(date, 4);
        String timeZoneName = "Z";
        buf.append(timeZoneName);
        ASN1Encoder.writeTagNumber(24, out);
        try {
            byte[] bytes = buf.toString().getBytes("ISO8859_1");
            ASN1Encoder.writeLength(bytes.length, out);
            ASN1Encoder.writeBytes(bytes, out);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void writeGeneralizedTime(Date generalizedTime) throws ASN1Exception {
        ASN1Encoder.writeGeneralizedTime(generalizedTime, this.output);
    }

    private static void writePrintableString(String string, OutputStream out) throws ASN1Exception {
        ASN1Encoder.writeTagNumber(19, out);
        try {
            byte[] bytes = string.getBytes("ISO8859_1");
            ASN1Encoder.writeLength(bytes.length, out);
            ASN1Encoder.writeBytes(bytes, out);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void writePrintableString(String string) throws ASN1Exception {
        ASN1Encoder.writePrintableString(string, this.output);
    }

    private static void writeUTF8String(String string, OutputStream out) throws ASN1Exception {
        ASN1Encoder.writeTagNumber(12, out);
        try {
            byte[] bytes = string.getBytes("UTF8");
            ASN1Encoder.writeLength(bytes.length, out);
            ASN1Encoder.writeBytes(bytes, out);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void writeUTF8String(String string) throws ASN1Exception {
        ASN1Encoder.writeUTF8String(string, this.output);
    }

    private static void writeSet(Object[] sequence, OutputStream out) throws ASN1Exception {
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        ASN1Encoder.writeSequence(sequence, newOut);
        ASN1Encoder.writeTagNumber(17, out);
        ASN1Encoder.writeLength(newOut.size(), out);
        try {
            newOut.writeTo(out);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private static void writeCertificateSet(Object[] sequence, OutputStream out) throws ASN1Exception {
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        int i = 0;
        while (i < sequence.length) {
            ASN1Encoder.writeObject(sequence[i], newOut);
            ++i;
        }
        ASN1Encoder.writeTagNumber(160, out);
        ASN1Encoder.writeLength(newOut.size(), out);
        try {
            newOut.writeTo(out);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private static void writeSet2Save(Object[] sequence, OutputStream out) throws ASN1Exception {
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        int i = 0;
        while (i < sequence.length) {
            ASN1Encoder.writeObject(sequence[i], newOut);
            ++i;
        }
        ASN1Encoder.writeTagNumber(17, out);
        ASN1Encoder.writeLength(newOut.size(), out);
        try {
            newOut.writeTo(out);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    private static void writeSet2(Object[] sequence, OutputStream out) throws ASN1Exception {
        new ByteArrayOutputStream();
        Object[] encodings = new Object[sequence.length];
        int encodedLength = 0;
        int i = 0;
        while (i < sequence.length) {
            ByteArrayOutputStream elementOut = new ByteArrayOutputStream();
            ASN1Encoder.writeObject(sequence[i], elementOut);
            encodings[i] = elementOut.toByteArray();
            encodedLength += elementOut.size();
            ++i;
        }
        Object[] sortedEncodings = new Object[encodings.length];
        int i2 = 0;
        while (i2 < sortedEncodings.length) {
            byte[] smallestEncoding = null;
            int smallestEncodingIndex = -1;
            int j = 0;
            while (j < encodings.length) {
                byte[] newSmallestEncoding = ASN1Encoder.getSmallestEncoding(smallestEncoding, (byte[])encodings[j]);
                if (newSmallestEncoding != smallestEncoding) {
                    smallestEncoding = newSmallestEncoding;
                    smallestEncodingIndex = j;
                }
                ++j;
            }
            encodings[smallestEncodingIndex] = null;
            sortedEncodings[i2] = smallestEncoding;
            ++i2;
        }
        ASN1Encoder.writeTagNumber(17, out);
        ASN1Encoder.writeLength(encodedLength, out);
        i2 = 0;
        while (i2 < sortedEncodings.length) {
            try {
                out.write((byte[])sortedEncodings[i2]);
            }
            catch (IOException iOException) {}
            ++i2;
        }
    }

    private static void writeImplicitSet(ASN1Decoder.Set2 set, OutputStream out, int tag) throws ASN1Exception {
        Object[] sequence = set.sequence;
        new ByteArrayOutputStream();
        Object[] encodings = new Object[sequence.length];
        int encodedLength = 0;
        int i = 0;
        while (i < sequence.length) {
            ByteArrayOutputStream elementOut = new ByteArrayOutputStream();
            ASN1Encoder.writeObject(sequence[i], elementOut);
            encodings[i] = elementOut.toByteArray();
            encodedLength += elementOut.size();
            ++i;
        }
        Object[] sortedEncodings = new Object[encodings.length];
        int i2 = 0;
        while (i2 < sortedEncodings.length) {
            byte[] smallestEncoding = null;
            int smallestEncodingIndex = -1;
            int j = 0;
            while (j < encodings.length) {
                byte[] newSmallestEncoding = ASN1Encoder.getSmallestEncoding(smallestEncoding, (byte[])encodings[j]);
                if (newSmallestEncoding != smallestEncoding) {
                    smallestEncoding = newSmallestEncoding;
                    smallestEncodingIndex = j;
                }
                ++j;
            }
            encodings[smallestEncodingIndex] = null;
            sortedEncodings[i2] = smallestEncoding;
            ++i2;
        }
        ASN1Encoder.writeTagNumber(160 + tag, out);
        ASN1Encoder.writeLength(encodedLength, out);
        i2 = 0;
        while (i2 < sortedEncodings.length) {
            try {
                out.write((byte[])sortedEncodings[i2]);
            }
            catch (IOException iOException) {}
            ++i2;
        }
    }

    private static void writeBMPString(String bmpString, OutputStream out) throws ASN1Exception {
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            bytes = bmpString.getBytes("UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ASN1Exception(Msg.getString("K018f", uee));
        }
        ASN1Encoder.writeTagNumber(30, out);
        ASN1Encoder.writeLength(bytes.length, out);
        ASN1Encoder.writeBytes(bytes, out);
        try {
            newOut.writeTo(out);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    protected void writeSet(Object[] sequence) throws ASN1Exception {
        ASN1Encoder.writeSet(sequence, this.output);
    }

    protected void writeSet2(Object[] sequence) throws ASN1Exception {
        ASN1Encoder.writeSet2(sequence, this.output);
    }

    protected void writeImplicitSet(ASN1Decoder.Set2 set, int tag) throws ASN1Exception {
        ASN1Encoder.writeImplicitSet(set, this.output, tag);
    }

    protected void writeCertificateSet(Object[] sequence) throws ASN1Exception {
        ASN1Encoder.writeCertificateSet(sequence, this.output);
    }

    private static void writeUTCTime(Date utcTime, OutputStream out) throws ASN1Exception {
        int[] date = new int[6];
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(utcTime);
        date[0] = cal.get(1);
        date[0] = date[0] >= 2000 ? date[0] - 2000 : date[0] - 1900;
        date[1] = cal.get(2) + 1;
        date[2] = cal.get(5);
        date[3] = cal.get(11);
        date[4] = cal.get(12);
        date[5] = cal.get(13);
        StringBuffer buf = ASN1Encoder.getDateString(date, 2);
        buf.append("Z");
        ASN1Encoder.writeTagNumber(23, out);
        try {
            byte[] bytes = buf.toString().getBytes("ISO8859_1");
            ASN1Encoder.writeLength(bytes.length, out);
            ASN1Encoder.writeBytes(bytes, out);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void writeUTCTime(Date utcTime) throws ASN1Exception {
        ASN1Encoder.writeUTCTime(utcTime, this.output);
    }

    private static void writeExplicit(Object type, OutputStream out) throws ASN1Exception {
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        ASN1Encoder.writeObject(type, newOut);
        try {
            ASN1Encoder.writeTagNumber(160, out);
            ASN1Encoder.writeLength(newOut.size(), out);
            newOut.writeTo(out);
        }
        catch (IOException ioe) {
            throw new ASN1Exception(ioe.toString());
        }
    }

    public static byte[] encodeNode(ASN1Decoder.Node node) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ASN1Encoder.encodeNode(node, out);
        }
        catch (ASN1Exception aSN1Exception) {
            return null;
        }
        return out.toByteArray();
    }

    private static void encodeNode(ASN1Decoder.Node node, OutputStream out) throws ASN1Exception {
        if (node.originalType == -1) {
            node.originalType = node.type;
        }
        if (node.tagtype == 2) {
            ASN1Encoder.writeTagNumber(node.originalType | 0xA0, out);
            if (node.type != -1) {
                ASN1Decoder.Node realNode = new ASN1Decoder.Node();
                realNode.data = node.data;
                realNode.isPrimitive = node.isPrimitive;
                realNode.type = node.type;
                realNode.originalType = node.type;
                realNode.tagtype = 1;
                ByteArrayOutputStream elementOut = new ByteArrayOutputStream();
                ASN1Encoder.encodeNode(realNode, elementOut);
                ASN1Encoder.writeLength(elementOut.size(), out);
                try {
                    out.write(elementOut.toByteArray());
                }
                catch (IOException iOException) {}
            } else {
                ASN1Encoder.writeLength(0, out);
            }
        } else {
            if (node.type == 17) {
                ASN1Decoder.Node[] elements = (ASN1Decoder.Node[])node.data;
                Object[] encodings = new Object[elements.length];
                int encodedLength = 0;
                int i = 0;
                while (i < elements.length) {
                    ByteArrayOutputStream elementOut = new ByteArrayOutputStream();
                    ASN1Encoder.encodeNode(elements[i], elementOut);
                    encodings[i] = elementOut.toByteArray();
                    encodedLength += elementOut.size();
                    ++i;
                }
                Object[] sortedEncodings = new Object[encodings.length];
                int i2 = 0;
                while (i2 < sortedEncodings.length) {
                    byte[] smallestEncoding = null;
                    int smallestEncodingIndex = -1;
                    int j = 0;
                    while (j < encodings.length) {
                        byte[] newSmallestEncoding = ASN1Encoder.getSmallestEncoding(smallestEncoding, (byte[])encodings[j]);
                        if (newSmallestEncoding != smallestEncoding) {
                            smallestEncoding = newSmallestEncoding;
                            smallestEncodingIndex = j;
                        }
                        ++j;
                    }
                    encodings[smallestEncodingIndex] = null;
                    sortedEncodings[i2] = smallestEncoding;
                    ++i2;
                }
                ASN1Encoder.writeTagNumber(17, out);
                ASN1Encoder.writeLength(encodedLength, out);
                i2 = 0;
                while (i2 < sortedEncodings.length) {
                    try {
                        out.write((byte[])sortedEncodings[i2]);
                    }
                    catch (IOException iOException) {}
                    ++i2;
                }
                return;
            }
            if (node.type == 16) {
                ASN1Decoder.Node[] elements = (ASN1Decoder.Node[])node.data;
                Object[] elementEncodings = new Object[elements.length];
                int encodedLength = 0;
                int i = 0;
                while (i < elements.length) {
                    ByteArrayOutputStream elementOut = new ByteArrayOutputStream();
                    ASN1Encoder.encodeNode(elements[i], elementOut);
                    elementEncodings[i] = elementOut.toByteArray();
                    encodedLength += elementOut.size();
                    ++i;
                }
                ASN1Encoder.writeTagNumber(16, out);
                ASN1Encoder.writeLength(encodedLength, out);
                i = 0;
                while (i < elementEncodings.length) {
                    try {
                        out.write((byte[])elementEncodings[i]);
                    }
                    catch (IOException iOException) {}
                    ++i;
                }
                return;
            }
            if (node.type == 6) {
                ASN1Encoder.writeObjectIdentifier((int[])node.data, out);
                return;
            }
            if (node.type == 23) {
                ASN1Encoder.writeUTCTime((Date)node.data, out);
                return;
            }
            if (node.type == 4) {
                ASN1Encoder.writeOctetString((byte[])node.data, out);
                return;
            }
            if (node.type == 5) {
                ASN1Encoder.writeTagNumber(5, out);
                ASN1Encoder.writeLength(0, out);
                return;
            }
            if (node.type == 2) {
                ASN1Encoder.writeInteger((BigInteger)node.data, out);
                return;
            }
            if (node.type == 3) {
                ASN1Encoder.writeBitString((ASN1Decoder.BitString)node.data, out);
                return;
            }
            if (node.type == 19) {
                ASN1Encoder.writePrintableString((String)node.data, out);
                return;
            }
            if (node.type == 12) {
                ASN1Encoder.writeUTF8String((String)node.data, out);
                return;
            }
            throw new ASN1Exception();
        }
    }

    private static byte[] getSmallestEncoding(byte[] e1, byte[] e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        int i = 0;
        while (i != e1.length) {
            if (i == e2.length) {
                return e1;
            }
            if (e1[i] < e2[i]) {
                return e1;
            }
            if (e2[i] < e1[i]) {
                return e2;
            }
            ++i;
        }
        return e2;
    }

    protected static void writeObjectTypeExtensions(Object value, OutputStream out) throws ASN1Exception {
    }
}

