/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

public final class FloatingPointParser {
    private static native double parseDblImpl(String var0, int var1);

    private static native float parseFltImpl(String var0, int var1);

    private static StringExponentPair initialParse(String s, int length) {
        boolean negative = false;
        int e = 0;
        int start = 0;
        if (length == 0) {
            throw new NumberFormatException(s);
        }
        char c = s.charAt(length - 1);
        if ((c == 'D' || c == 'd' || c == 'F' || c == 'f') && --length == 0) {
            throw new NumberFormatException(s);
        }
        int end = Math.max(s.indexOf(69), s.indexOf(101));
        if (end > -1) {
            if (end + 1 == length) {
                throw new NumberFormatException(s);
            }
            e = s.charAt(end + 1) == '+' ? Integer.parseInt(s.substring(end + 2, length)) : Integer.parseInt(s.substring(end + 1, length));
        } else {
            end = length;
        }
        if (length == 0) {
            throw new NumberFormatException(s);
        }
        c = s.charAt(start);
        if (c == '-') {
            ++start;
            --length;
            negative = true;
        } else if (c == '+') {
            ++start;
            --length;
        }
        if (length == 0) {
            throw new NumberFormatException(s);
        }
        int decimal = s.indexOf(46);
        if (decimal > -1) {
            e -= end - decimal - 1;
            s = String.valueOf(s.substring(start, decimal)) + s.substring(decimal + 1, end);
        } else {
            s = s.substring(start, end);
        }
        length = s.length();
        if (length == 0) {
            throw new NumberFormatException();
        }
        end = length;
        while (end > 1 && s.charAt(end - 1) == '0') {
            --end;
        }
        start = 0;
        while (start < end - 1 && s.charAt(start) == '0') {
            ++start;
        }
        if (end != length || start != 0) {
            e += length - end;
            s = s.substring(start, end);
        }
        return new StringExponentPair(s, e, negative);
    }

    private static double parseDblName(String namedDouble, int length) {
        if (length != 3 && length != 4 && length != 8 && length != 9) {
            throw new NumberFormatException();
        }
        boolean negative = false;
        int cmpstart = 0;
        switch (namedDouble.charAt(0)) {
            case '-': {
                negative = true;
            }
            case '+': {
                cmpstart = 1;
            }
        }
        if (namedDouble.regionMatches(false, cmpstart, "Infinity", 0, 8)) {
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (namedDouble.regionMatches(false, cmpstart, "NaN", 0, 3)) {
            return Double.NaN;
        }
        throw new NumberFormatException();
    }

    private static float parseFltName(String namedFloat, int length) {
        if (length != 3 && length != 4 && length != 8 && length != 9) {
            throw new NumberFormatException();
        }
        boolean negative = false;
        int cmpstart = 0;
        switch (namedFloat.charAt(0)) {
            case '-': {
                negative = true;
            }
            case '+': {
                cmpstart = 1;
            }
        }
        if (namedFloat.regionMatches(false, cmpstart, "Infinity", 0, 8)) {
            return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (namedFloat.regionMatches(false, cmpstart, "NaN", 0, 3)) {
            return Float.NaN;
        }
        throw new NumberFormatException();
    }

    public static double parseDouble(String s) {
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new NumberFormatException(s);
        }
        char last = s.charAt(length - 1);
        if (last == 'y' || last == 'N') {
            return FloatingPointParser.parseDblName(s, length);
        }
        StringExponentPair info = FloatingPointParser.initialParse(s, length);
        double result = FloatingPointParser.parseDblImpl(info.s, info.e);
        if (info.negative) {
            result = -result;
        }
        return result;
    }

    public static float parseFloat(String s) {
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new NumberFormatException(s);
        }
        char last = s.charAt(length - 1);
        if (last == 'y' || last == 'N') {
            return FloatingPointParser.parseFltName(s, length);
        }
        StringExponentPair info = FloatingPointParser.initialParse(s, length);
        float result = FloatingPointParser.parseFltImpl(info.s, info.e);
        if (info.negative) {
            result = -result;
        }
        return result;
    }

    private static final class StringExponentPair {
        String s;
        int e;
        boolean negative;

        StringExponentPair(String s, int e, boolean negative) {
            this.s = s;
            this.e = e;
            this.negative = negative;
        }
    }
}

