/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

public class IdentityHashtable
implements Cloneable {
    public static final Object ABSENT_FLAG = new Object();
    int elementCount;
    Object[] elementKeys;
    Object[] elementData;
    private int loadFactor;
    private int maxSize;
    private static final int DEFAULT_SIZE = 101;
    private static final int DEFAULT_LOAD_FACTOR = 50;

    public IdentityHashtable() {
        this(101);
    }

    public IdentityHashtable(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementKeys = new Object[capacity];
        this.elementData = new Object[capacity];
        this.loadFactor = 50;
        this.computeMaxSize();
    }

    public IdentityHashtable(int capacity, int loadFactor) {
        this(capacity);
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public synchronized void clear() {
        this.elementCount = 0;
        int i = 0;
        while (i < this.elementKeys.length) {
            this.elementData[i] = null;
            this.elementKeys[i] = null;
            ++i;
        }
    }

    public synchronized Object clone() {
        try {
            IdentityHashtable hashtable = (IdentityHashtable)super.clone();
            hashtable.elementKeys = (Object[])this.elementKeys.clone();
            hashtable.elementData = (Object[])this.elementData.clone();
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.maxSize = (int)((long)this.elementKeys.length * (long)this.loadFactor / 100L);
    }

    public synchronized boolean contains(Object object) {
        if (object != null) {
            int i = 0;
            while (i < this.elementData.length) {
                if (this.elementData[i] == object) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        throw new NullPointerException();
    }

    public synchronized boolean containsKey(Object object) {
        return this.get(object, ABSENT_FLAG) != ABSENT_FLAG;
    }

    private int findIndex(Object object, Object[] array) {
        Object key;
        int index;
        int length = array.length;
        int i = index = (System.identityHashCode(object) & Integer.MAX_VALUE) % length;
        while (i < length) {
            key = array[i];
            if (key == null || key == object) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < index) {
            key = array[i];
            if (key == null || key == object) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException();
    }

    public synchronized Object get(Object key) {
        return this.get(key, null);
    }

    public synchronized Object get(Object key, Object returnIfMissing) {
        int index = this.findIndex(key, this.elementKeys);
        if (this.elementKeys[index] != null) {
            return this.elementData[index];
        }
        return returnIfMissing;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized void iterate(Iterator iterator) {
        int i = 0;
        while (i < this.elementKeys.length) {
            Object key = this.elementKeys[i];
            if (key != null) {
                iterator.iterate(key, this.elementData[i]);
            }
            ++i;
        }
    }

    public synchronized Object put(Object key, Object value) {
        if (key != null) {
            int index = this.findIndex(key, this.elementKeys);
            Object object = this.elementData[index];
            if (this.elementKeys[index] == null && ++this.elementCount > this.maxSize) {
                this.rehash();
                index = this.findIndex(key, this.elementKeys);
            }
            this.elementKeys[index] = key;
            this.elementData[index] = value;
            return object;
        }
        throw new NullPointerException();
    }

    protected void rehash() {
        int length = this.elementKeys.length << 1;
        Object[] newKeys = new Object[length];
        Object[] newData = new Object[length];
        int i = 0;
        while (i < this.elementKeys.length) {
            Object key = this.elementKeys[i];
            if (key != null) {
                int index = this.findIndex(key, newKeys);
                newKeys[index] = key;
                newData[index] = this.elementData[i];
            }
            ++i;
        }
        this.elementKeys = newKeys;
        this.elementData = newData;
        this.computeMaxSize();
    }

    public synchronized Object remove(Object key) {
        Object object;
        int next = this.findIndex(key, this.elementKeys);
        int index = next;
        Object result = this.elementData[index];
        if (result == null) {
            return null;
        }
        int length = this.elementKeys.length;
        while ((object = this.elementKeys[next = (next + 1) % length]) != null) {
            boolean hashedOk;
            int hash = (System.identityHashCode(object) & Integer.MAX_VALUE) % length;
            boolean bl = hashedOk = hash > index;
            if (next < index) {
                hashedOk = hashedOk || hash <= next;
            } else {
                boolean bl2 = hashedOk = hashedOk && hash <= next;
            }
            if (hashedOk) continue;
            this.elementKeys[index] = object;
            this.elementData[index] = this.elementData[next];
            index = next;
        }
        --this.elementCount;
        this.elementData[index] = null;
        this.elementKeys[index] = null;
        return result;
    }

    public int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        int count = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        int i = 0;
        while (i < this.elementKeys.length) {
            Object key = this.elementKeys[i];
            if (key != null) {
                buffer.append(key);
                buffer.append('=');
                buffer.append(this.elementData[i]);
                if (++count < this.elementCount) {
                    buffer.append(',');
                }
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static interface Iterator {
        public void iterate(Object var1, Object var2);
    }
}

