/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util.semaphore;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.semaphore.CreateSemaphorePermission;
import java.util.Hashtable;

abstract class Semaphore {
    private static Hashtable existingSemaphores = new Hashtable();
    private String name = null;
    private static long semaphoreHandle = 0L;

    private static native long init(String var0, int var1);

    private static native void closeSemaphore(long var0);

    private static native boolean waitOnSemaphore(long var0);

    private static native boolean postOnSemaphore(long var0);

    Semaphore(String name, int count) {
        this.initializeSemaphore(name, count);
    }

    Semaphore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeSemaphore(String name, int count) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(CreateSemaphorePermission.CreateSemaphorePermission);
        }
        Hashtable hashtable = existingSemaphores;
        synchronized (hashtable) {
            if (existingSemaphores.containsKey(name)) {
                throw new IllegalArgumentException(Msg.getString("K037c"));
            }
            existingSemaphores.put(name, name);
            semaphoreHandle = Semaphore.init(name, count);
            if (semaphoreHandle == 0L) {
                throw new RuntimeException(Msg.getString("K0353"));
            }
            this.name = name;
        }
    }

    public boolean waitSemaphore() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(CreateSemaphorePermission.CreateSemaphorePermission);
        }
        if (semaphoreHandle != 0L) {
            return Semaphore.waitOnSemaphore(semaphoreHandle);
        }
        throw new IllegalStateException(Msg.getString("K0352"));
    }

    public boolean postSemaphore() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(CreateSemaphorePermission.CreateSemaphorePermission);
        }
        if (semaphoreHandle != 0L) {
            return Semaphore.postOnSemaphore(semaphoreHandle);
        }
        throw new IllegalStateException(Msg.getString("K0352"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(CreateSemaphorePermission.CreateSemaphorePermission);
        }
        Hashtable hashtable = existingSemaphores;
        synchronized (hashtable) {
            if (semaphoreHandle != 0L) {
                if (existingSemaphores.containsKey(this.name)) {
                    existingSemaphores.remove(this.name);
                }
            } else {
                throw new IllegalStateException(Msg.getString("K0352"));
            }
            Semaphore.closeSemaphore(semaphoreHandle);
            semaphoreHandle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

