/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.OSMemoryAccessor;
import java.io.IOException;
import java.io.InputStream;

class MemInputStream
extends InputStream
implements OSMemoryAccessor {
    private long pointer;
    private int size;
    private int offset;
    private int mark;
    private Jxe jxe;

    MemInputStream(long pointer, int size, Jxe jxe) {
        this.pointer = pointer;
        this.size = size;
        this.offset = 0;
        this.jxe = jxe;
    }

    public int available() throws IOException {
        if (this.pointer == 0L) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (this.offset >= this.size) {
            return 0;
        }
        return this.size - this.offset;
    }

    public void close() throws IOException {
        this.pointer = 0L;
    }

    public long getPointer() {
        return this.pointer;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.offset;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.pointer == 0L) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (this.offset >= this.size) {
            return -1;
        }
        if (this.jxe != null && this.jxe.getJxePointer() == 0L) {
            throw new IOException(Msg.getString("K0059"));
        }
        return this.nativeGetByte(this.pointer, this.offset++) & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pointer == 0L) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (off >= 0 && len >= 0 && len <= b.length - off) {
            if (this.offset >= this.size) {
                return -1;
            }
            int read = MemInputStream.min(len, this.size - this.offset);
            if (this.jxe != null && this.jxe.getJxePointer() == 0L) {
                throw new IOException(Msg.getString("K0059"));
            }
            this.nativeMemcpy(b, off, this.pointer + (long)this.offset, read);
            this.offset += read;
            return read;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public synchronized void reset() {
        this.offset = this.mark;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.pointer == 0L) {
            throw new IOException(Msg.getString("K0059"));
        }
        int skipped = MemInputStream.min((int)n, this.size - this.offset);
        this.offset += skipped;
        return skipped;
    }

    static int min(int x, int y) {
        return x < y ? x : y;
    }

    private native byte nativeGetByte(long var1, int var3);

    private native void nativeMemcpy(byte[] var1, int var2, long var3, int var5);
}

