/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;

public abstract class URLSystemClassLoader
extends URLClassLoader {
    private boolean checkingPackageAccess = false;
    private static final RuntimePermission permissionToExitVM = new RuntimePermission("exitVM");

    URLSystemClassLoader() {
        super((URL[])null);
    }

    URLSystemClassLoader(URL[] path, ClassLoader parent) {
        super(path, parent);
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class newClass = super.findClass(className);
        return newClass;
    }

    protected synchronized Class loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        int index;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !this.checkingPackageAccess && (index = className.lastIndexOf(46)) > 0) {
            try {
                this.checkingPackageAccess = true;
                sm.checkPackageAccess(className.substring(0, index));
            }
            finally {
                this.checkingPackageAccess = false;
            }
        }
        return super.loadClass(className, resolveClass);
    }

    abstract boolean addExitPermission();

    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = super.getPermissions(codesource);
        if (this.addExitPermission()) {
            pc.add(permissionToExitVM);
        }
        return pc;
    }
}

