/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    private Thread lastReader;
    private Thread lastWriter;
    private boolean isClosed = false;
    protected byte[] buffer;
    protected int in = -1;
    protected int out = 0;
    protected static final int PIPE_SIZE = 1024;
    boolean isConnected = false;

    public PipedInputStream() {
    }

    public PipedInputStream(PipedOutputStream out) throws IOException {
        this.connect(out);
    }

    public synchronized int available() throws IOException {
        if (this.buffer == null || this.in == -1) {
            return 0;
        }
        return this.in <= this.out ? this.buffer.length - this.out + this.in : this.in - this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            if (this.buffer != null) {
                this.buffer = null;
            }
        }
    }

    public void connect(PipedOutputStream src) throws IOException {
        src.connect(this);
    }

    public synchronized int read() throws IOException {
        if (this.isConnected) {
            if (this.buffer != null) {
                this.lastReader = Thread.currentThread();
                try {
                    boolean first = true;
                    while (this.in == -1) {
                        if (this.isClosed) {
                            return -1;
                        }
                        if (!first && this.lastWriter != null && !this.lastWriter.isAlive()) {
                            throw new IOException(Msg.getString("K0076"));
                        }
                        first = false;
                        this.notifyAll();
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                byte result = this.buffer[this.out++];
                if (this.out == this.buffer.length) {
                    this.out = 0;
                }
                if (this.out == this.in) {
                    this.in = -1;
                    this.out = 0;
                }
                return result & 0xFF;
            }
            throw new IOException(Msg.getString("K0075"));
        }
        throw new IOException(Msg.getString("K0074"));
    }

    public synchronized int read(byte[] bytes, int offset, int count) throws IOException {
        if (bytes != null && offset >= 0 && offset <= bytes.length && count >= 0 && count <= bytes.length - offset) {
            if (count == 0) {
                return 0;
            }
            if (this.isConnected && this.buffer != null) {
                this.lastReader = Thread.currentThread();
                try {
                    boolean first = true;
                    while (this.in == -1) {
                        if (this.isClosed) {
                            return -1;
                        }
                        if (!first && this.lastWriter != null && !this.lastWriter.isAlive()) {
                            throw new IOException(Msg.getString("K0076"));
                        }
                        first = false;
                        this.notifyAll();
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                int copyLength = 0;
                if (this.out >= this.in) {
                    copyLength = count > this.buffer.length - this.out ? this.buffer.length - this.out : count;
                    System.arraycopy((Object)this.buffer, this.out, (Object)bytes, offset, copyLength);
                    this.out += copyLength;
                    if (this.out == this.buffer.length) {
                        this.out = 0;
                    }
                    if (this.out == this.in) {
                        this.in = -1;
                        this.out = 0;
                    }
                }
                if (copyLength == count || this.in == -1) {
                    return copyLength;
                }
                int bytesCopied = copyLength;
                copyLength = this.in - this.out > count - bytesCopied ? count - bytesCopied : this.in - this.out;
                System.arraycopy((Object)this.buffer, this.out, (Object)bytes, offset + bytesCopied, copyLength);
                this.out += copyLength;
                if (this.out == this.in) {
                    this.in = -1;
                    this.out = 0;
                }
                return bytesCopied + copyLength;
            }
            if (!this.isConnected) {
                throw new IOException(Msg.getString("K0074"));
            }
            throw new IOException(Msg.getString("K0075"));
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    protected synchronized void receive(int oneByte) throws IOException {
        if (this.buffer != null && !this.isClosed) {
            this.lastWriter = Thread.currentThread();
            try {
                if (this.out == this.in) {
                    do {
                        this.notifyAll();
                        this.wait(1000L);
                        if (this.lastReader == null || this.lastReader.isAlive()) continue;
                        throw new IOException(Msg.getString("K0076"));
                    } while (this.buffer != null && this.out == this.in);
                } else if (this.lastReader != null && !this.lastReader.isAlive()) {
                    throw new IOException(Msg.getString("K0076"));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (this.buffer != null) {
                if (this.in == -1) {
                    this.in = 0;
                }
                this.buffer[this.in++] = (byte)oneByte;
                if (this.in == this.buffer.length) {
                    this.in = 0;
                }
                return;
            }
        }
        throw new IOException(Msg.getString("K0078"));
    }

    synchronized void done() {
        this.isClosed = true;
        this.notifyAll();
    }
}

