/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;

public class PrintWriter
extends Writer {
    protected Writer out;
    boolean ioError = false;
    boolean autoflush = false;
    private final String lineSeparator = (String)AccessController.doPrivileged(new PriviAction("line.separator"));

    public PrintWriter(OutputStream out) {
        this(new OutputStreamWriter(out), false);
    }

    public PrintWriter(OutputStream out, boolean autoflush) {
        this(new OutputStreamWriter(out), autoflush);
    }

    public PrintWriter(Writer wr) {
        this(wr, false);
    }

    public PrintWriter(Writer wr, boolean autoflush) {
        super(wr);
        this.autoflush = autoflush;
        this.out = wr;
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.ioError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.setError();
                }
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.setError();
                }
            } else {
                this.setError();
            }
        }
    }

    private void newline() {
        this.print(this.lineSeparator);
        if (this.autoflush) {
            this.flush();
        }
    }

    public void print(char[] charArray) {
        this.print(new String(charArray, 0, charArray.length));
    }

    public void print(char ch) {
        this.print(String.valueOf(ch));
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum));
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum));
    }

    public void print(int inum) {
        this.print(String.valueOf(inum));
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum));
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String str) {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.write(str != null ? str : String.valueOf(null));
                }
                catch (IOException iOException) {
                    this.setError();
                }
            } else {
                this.setError();
            }
        }
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.newline();
        }
    }

    public void println(char[] charArray) {
        this.println(new String(charArray, 0, charArray.length));
    }

    public void println(char ch) {
        this.println(String.valueOf(ch));
    }

    public void println(double dnum) {
        this.println(String.valueOf(dnum));
    }

    public void println(float fnum) {
        this.println(String.valueOf(fnum));
    }

    public void println(int inum) {
        this.println(String.valueOf(inum));
    }

    public void println(long lnum) {
        this.println(String.valueOf(lnum));
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String str) {
        Object object = this.lock;
        synchronized (object) {
            this.print(str);
            this.newline();
        }
    }

    public void println(boolean bool) {
        this.println(String.valueOf(bool));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError() {
        Object object = this.lock;
        synchronized (object) {
            this.ioError = true;
        }
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int count) {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.write(buf, offset, count);
                }
                catch (IOException iOException) {
                    this.setError();
                }
            } else {
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            this.write(new char[]{(char)oneChar}, 0, 1);
        }
    }

    public void write(String str) {
        this.print(str);
    }

    public void write(String str, int offset, int count) {
        this.print(str.substring(offset, offset + count));
    }
}

