/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String str;
    private int markpos = -1;
    private int pos = 0;
    private int count;

    public StringReader(String str) {
        super(str);
        this.str = str;
        this.count = str.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.str = null;
            }
        }
    }

    private boolean isOpen() {
        return this.str != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        if (readLimit >= 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException(Msg.getString("K0083"));
                }
                this.markpos = this.pos;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.isOpen()) break block5;
                if (this.pos != this.count) {
                    return this.str.charAt(this.pos++);
                }
                return -1;
            }
            throw new IOException(Msg.getString("K0083"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] buf, int offset, int count) throws IOException {
        if (offset < 0 || offset > buf.length || count < 0 || count > buf.length - offset) throw new ArrayIndexOutOfBoundsException();
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K0083"));
                if (this.pos != this.count) break block4;
                return -1;
            }
            int end = this.pos + count > this.count ? this.count : this.pos + count;
            this.str.getChars(this.pos, end, buf, offset);
            int read = end - this.pos;
            this.pos = end;
            return read;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.isOpen()) break block4;
                return true;
            }
            throw new IOException(Msg.getString("K0083"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K0083"));
            }
            this.pos = this.markpos != -1 ? this.markpos : 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K0083"));
                if (count > 0L) break block5;
                return 0L;
            }
            long skipped = 0L;
            if (count < (long)(this.count - this.pos)) {
                this.pos += (int)count;
                return count;
            }
            skipped = this.count - this.pos;
            this.pos = this.count;
            return skipped;
        }
    }
}

