/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    private static final long serialVersionUID = 4290774380558885855L;
    final long value;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final Class TYPE = new long[0].getClass().getComponentType();

    public Long(long value) {
        this.value = value;
    }

    public Long(String string) throws NumberFormatException {
        this(Long.parseLong(string));
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public int compareTo(Long object) {
        return this.value > object.value ? 1 : (this.value < object.value ? -1 : 0);
    }

    public int compareTo(Object object) {
        return this.compareTo((Long)object);
    }

    public static Long decode(String string) throws NumberFormatException {
        boolean negative;
        int length = string.length();
        int i = 0;
        if (length == 0) {
            throw new NumberFormatException();
        }
        char firstDigit = string.charAt(i);
        boolean bl = negative = firstDigit == '-';
        if (negative) {
            if (length == 1) {
                throw new NumberFormatException(string);
            }
            firstDigit = string.charAt(++i);
        }
        int base = 10;
        if (firstDigit == '0') {
            if (++i == length) {
                return new Long(0L);
            }
            firstDigit = string.charAt(i);
            if (firstDigit == 'x' || firstDigit == 'X') {
                if (i == length) {
                    throw new NumberFormatException(string);
                }
                ++i;
                base = 16;
            } else {
                base = 8;
            }
        } else if (firstDigit == '#') {
            if (i == length) {
                throw new NumberFormatException(string);
            }
            ++i;
            base = 16;
        }
        long result = Long.parse(string, i, base, negative);
        return new Long(result);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Long && this.value == ((Long)o).value;
    }

    public float floatValue() {
        return this.value;
    }

    public static Long getLong(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String prop = System.getProperty(string);
        if (prop == null) {
            return null;
        }
        try {
            return Long.decode(prop);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long getLong(String string, long defaultValue) {
        if (string == null || string.length() == 0) {
            return new Long(defaultValue);
        }
        String prop = System.getProperty(string);
        if (prop == null) {
            return new Long(defaultValue);
        }
        try {
            return Long.decode(prop);
        }
        catch (NumberFormatException numberFormatException) {
            return new Long(defaultValue);
        }
    }

    public static Long getLong(String string, Long defaultValue) {
        if (string == null || string.length() == 0) {
            return defaultValue;
        }
        String prop = System.getProperty(string);
        if (prop == null) {
            return defaultValue;
        }
        try {
            return Long.decode(prop);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int radix) throws NumberFormatException {
        boolean negative;
        if (string == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int length = string.length();
        int i = 0;
        if (length == 0) {
            throw new NumberFormatException(string);
        }
        boolean bl = negative = string.charAt(i) == '-';
        if (negative && ++i == length) {
            throw new NumberFormatException(string);
        }
        return Long.parse(string, i, radix, negative);
    }

    private static long parse(String string, int offset, int radix, boolean negative) {
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        long length = string.length();
        while ((long)offset < length) {
            int digit;
            if ((digit = Character.digit(string.charAt(offset++), radix)) == -1) {
                throw new NumberFormatException(string);
            }
            if (max > result) {
                throw new NumberFormatException(string);
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(string);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(string);
        }
        return result;
    }

    public short shortValue() {
        return (short)this.value;
    }

    /*
     * Unable to fully structure code
     */
    public static String toBinaryString(long l) {
        block2: {
            count = 1;
            j = l;
            if (l >= 0L) ** GOTO lbl7
            count = 64;
            break block2;
lbl-1000:
            // 1 sources

            {
                ++count;
lbl7:
                // 2 sources

                ** while ((j >>= 1) != 0L)
            }
        }
        buffer = new char[count];
        do {
            buffer[--count] = (char)((l & 1L) + 48L);
            l >>= 1;
        } while (count > 0);
        return new String(0, buffer.length, buffer);
    }

    /*
     * Unable to fully structure code
     */
    public static String toHexString(long l) {
        block2: {
            count = 1;
            j = l;
            if (l >= 0L) ** GOTO lbl7
            count = 16;
            break block2;
lbl-1000:
            // 1 sources

            {
                ++count;
lbl7:
                // 2 sources

                ** while ((j >>= 4) != 0L)
            }
        }
        buffer = new char[count];
        do {
            t = (t = (int)(l & 15L)) > 9 ? t - 10 + 97 : (t += 48);
            buffer[--count] = (char)t;
            l >>= 4;
        } while (count > 0);
        return new String(0, buffer.length, buffer);
    }

    /*
     * Unable to fully structure code
     */
    public static String toOctalString(long l) {
        block2: {
            count = 1;
            j = l;
            if (l >= 0L) ** GOTO lbl7
            count = 22;
            break block2;
lbl-1000:
            // 1 sources

            {
                ++count;
lbl7:
                // 2 sources

                ** while ((j >>>= 3) != 0L)
            }
        }
        buffer = new char[count];
        do {
            buffer[--count] = (char)((l & 7L) + 48L);
            l >>>= 3;
        } while (count > 0);
        return new String(0, buffer.length, buffer);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long l) {
        return Long.toString(l, 10);
    }

    public static String toString(long l, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (l == 0L) {
            return "0";
        }
        int count = 2;
        long j = l;
        boolean bl = negative = l < 0L;
        if (!negative) {
            count = 1;
            j = -l;
        }
        while ((l /= (long)radix) != 0L) {
            ++count;
        }
        char[] buffer = new char[count];
        do {
            int ch;
            ch = (ch = 0 - (int)(j % (long)radix)) > 9 ? ch - 10 + 97 : (ch += 48);
            buffer[--count] = (char)ch;
        } while ((j /= (long)radix) != 0L);
        if (negative) {
            buffer[0] = 45;
        }
        return new String(0, buffer.length, buffer);
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return new Long(Long.parseLong(string));
    }

    public static Long valueOf(String string, int radix) throws NumberFormatException {
        return new Long(Long.parseLong(string, radix));
    }
}

