/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Inet6Util;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -7204263841984476862L;
    static final int SP_CONNECT = 1;
    static final int SP_LISTEN = 2;
    static final int SP_ACCEPT = 4;
    static final int SP_RESOLVE = 8;
    private static final String[] actionNames = new String[]{"", "connect", "listen", "", "accept", "", "", "", "resolve"};
    private transient boolean isPartialWild = false;
    private transient boolean isWild = false;
    private static final int HIGHEST_PORT = 65535;
    private static final int LOWEST_PORT = 0;
    transient String hostName;
    transient String ipString;
    transient boolean resolved = false;
    transient int portMin = 0;
    transient int portMax = 65535;
    private String actions;
    transient int actionsMask = 8;

    public SocketPermission(String host, String action) {
        super(host.equals("") ? "localhost" : host);
        this.hostName = this.getHostString(host);
        if (action == null) {
            throw new NullPointerException();
        }
        if (action.equals("")) {
            throw new IllegalArgumentException();
        }
        this.setActions(action);
        this.actions = this.toCanonicalActionString(action);
        this.parsePort(host);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SocketPermission sp = (SocketPermission)o;
        if (!(this.hostName.equals(sp.hostName) || this.getIPString() != null && this.ipString.equals(sp.getIPString()))) {
            return false;
        }
        if (this.portMin != sp.portMin) {
            return false;
        }
        if (this.portMax != sp.portMax) {
            return false;
        }
        return this.actionsMask == sp.actionsMask;
    }

    public int hashCode() {
        return this.hostName.hashCode() ^ this.actionsMask ^ this.portMin ^ this.portMax;
    }

    public String getActions() {
        return this.actions;
    }

    private void setActions(String actions) throws IllegalArgumentException {
        if (actions.equals("")) {
            return;
        }
        boolean parsing = true;
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        int length = actions.length();
        while (parsing) {
            String action;
            char c;
            sb.setLength(0);
            while (pos < length && (c = actions.charAt(pos++)) != ',') {
                sb.append(c);
            }
            if (pos == length) {
                parsing = false;
            }
            if ((action = sb.toString().trim().toLowerCase()).equals(actionNames[1])) {
                this.actionsMask |= 1;
                continue;
            }
            if (action.equals(actionNames[2])) {
                this.actionsMask |= 2;
                continue;
            }
            if (action.equals(actionNames[4])) {
                this.actionsMask |= 4;
                continue;
            }
            if (action.equals(actionNames[8])) continue;
            throw new IllegalArgumentException(Msg.getString("K0048", action));
        }
    }

    public boolean implies(Permission p) {
        SocketPermission sp;
        try {
            sp = (SocketPermission)p;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if ((this.actionsMask & sp.actionsMask) != sp.actionsMask) {
            return false;
        }
        if (!(p.getActions().equals("resolve") || sp.portMin >= this.portMin && sp.portMax <= this.portMax)) {
            return false;
        }
        return this.checkHost(sp);
    }

    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private void parsePort(String hostString) throws IllegalArgumentException {
        int negidx = -1;
        int len = -1;
        int lastIdx = hostString.lastIndexOf(58);
        int idx = hostString.indexOf(58);
        int endOfIPv6Addr = hostString.lastIndexOf(93);
        if (endOfIPv6Addr == -1 && idx != lastIdx) {
            if (Inet6Util.isValidIP6Address(hostString)) {
                return;
            }
            String tmp = hostString.substring(0, lastIdx);
            if (Inet6Util.isValidIP6Address(tmp)) {
                hostString = "[" + tmp + "]" + hostString.substring(lastIdx, hostString.length());
                endOfIPv6Addr = tmp.length() + 2;
            } else {
                throw new IllegalArgumentException(Msg.getString("K004a"));
            }
        }
        if (lastIdx > -1 && lastIdx > endOfIPv6Addr) {
            try {
                len = hostString.length();
                negidx = hostString.indexOf(45, lastIdx);
                if (negidx == lastIdx + 1) {
                    this.portMax = Integer.parseInt(hostString.substring(lastIdx + 2, len));
                } else if (negidx != -1 && negidx != len - 1) {
                    this.portMin = Integer.parseInt(hostString.substring(lastIdx + 1, negidx));
                    this.portMax = Integer.parseInt(hostString.substring(negidx + 1, len));
                } else if (negidx == -1) {
                    this.portMax = this.portMin = Integer.parseInt(hostString.substring(lastIdx + 1, len));
                } else {
                    this.portMin = Integer.parseInt(hostString.substring(lastIdx + 1, negidx));
                }
                if (this.portMax < this.portMin) {
                    throw new IllegalArgumentException(Msg.getString("K0049"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K004a"));
            }
        }
    }

    private String toCanonicalActionString(String action) {
        if (action == null || action.equals("") || this.actionsMask == 8) {
            return actionNames[8];
        }
        StringBuffer sb = new StringBuffer();
        if ((this.actionsMask & 1) == 1) {
            sb.append(',');
            sb.append(actionNames[1]);
        }
        if ((this.actionsMask & 2) == 2) {
            sb.append(',');
            sb.append(actionNames[2]);
        }
        if ((this.actionsMask & 4) == 4) {
            sb.append(',');
            sb.append(actionNames[4]);
        }
        sb.append(',');
        sb.append(actionNames[8]);
        this.actions = sb.substring(1, sb.length());
        return this.actions;
    }

    private String getIPString() {
        if (!this.resolved) {
            try {
                this.ipString = InetAddress.getHostNameInternal(this.hostName);
            }
            catch (UnknownHostException unknownHostException) {}
            this.resolved = true;
        }
        return this.ipString;
    }

    private String getHostString(String host) throws IllegalArgumentException {
        int idx = -1;
        idx = host.indexOf(58);
        this.isPartialWild = host.length() > 0 && host.charAt(0) == '*';
        if (this.isPartialWild) {
            this.resolved = true;
            this.isWild = host.length() == 1;
            if (this.isWild) {
                return host;
            }
            if (idx > -1) {
                host = host.substring(0, idx);
            }
            return host.toLowerCase();
        }
        int lastIdx = host.lastIndexOf(58);
        if (idx > -1 && idx == lastIdx) {
            host = host.substring(0, idx);
        } else if (lastIdx != -1) {
            if (Inet6Util.isValidIP6Address(host)) {
                return host.toLowerCase();
            }
            if (Inet6Util.isValidIP6Address(host.substring(0, lastIdx))) {
                host = host.substring(0, lastIdx);
            } else {
                throw new IllegalArgumentException(Msg.getString("K004a"));
            }
        }
        return host.toLowerCase();
    }

    boolean checkHost(SocketPermission sp) {
        if (this.isPartialWild) {
            if (this.isWild) {
                return true;
            }
            int length = this.hostName.length() - 1;
            return sp.hostName.regionMatches(sp.hostName.length() - length, this.hostName, 1, length);
        }
        return this.getIPString() != null && this.ipString.equals(sp.getIPString()) || this.hostName.equals(sp.hostName);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.isPartialWild = false;
        this.isWild = false;
        this.portMin = 0;
        this.portMax = 65535;
        this.actionsMask = 8;
        this.hostName = this.getHostString(this.getName());
        this.parsePort(this.getName());
        this.setActions(this.actions);
    }
}

