/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

final class SocketPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 2787186408602843674L;
    public Vector permissions = new Vector();

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (!(permission instanceof SocketPermission)) {
            throw new IllegalArgumentException(permission.toString());
        }
        this.permissions.addElement(permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission argPerm = (SocketPermission)permission;
        int pmask = argPerm.actionsMask;
        int allMask = 0;
        int i = 0;
        int count = this.permissions.size();
        while (i < count && (allMask & pmask) != pmask) {
            SocketPermission sp = (SocketPermission)this.permissions.elementAt(i);
            if (sp.checkHost(argPerm)) {
                if ((sp.actionsMask & 8) == 8) {
                    allMask |= 8;
                }
                if (argPerm.portMin >= sp.portMin && argPerm.portMax <= sp.portMax) {
                    if ((sp.actionsMask & 1) == 1) {
                        allMask |= 1;
                    }
                    if ((sp.actionsMask & 4) == 4) {
                        allMask |= 4;
                    }
                    if ((sp.actionsMask & 2) == 2) {
                        allMask |= 2;
                    }
                }
            }
            ++i;
        }
        return (allMask & pmask) == pmask;
    }
}

