/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.UnsupportedEncodingException;

public class URLEncoder {
    static final String digits = "0123456789ABCDEF";

    private URLEncoder() {
    }

    public static String encode(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ".-*_".indexOf(ch) > -1) {
                buf.append(ch);
            } else if (ch == ' ') {
                buf.append('+');
            } else {
                byte[] bytes = new String(new char[]{ch}).getBytes();
                int j = 0;
                while (j < bytes.length) {
                    buf.append('%');
                    buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
                    buf.append(digits.charAt(bytes[j] & 0xF));
                    ++j;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        if (enc == null) {
            throw new NullPointerException();
        }
        "".getBytes(enc);
        StringBuffer buf = new StringBuffer();
        int start = -1;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || " .-*_".indexOf(ch) > -1) {
                if (start >= 0) {
                    URLEncoder.convert(s.substring(start, i), buf, enc);
                    start = -1;
                }
                if (ch != ' ') {
                    buf.append(ch);
                } else {
                    buf.append('+');
                }
            } else if (start < 0) {
                start = i;
            }
            ++i;
        }
        if (start >= 0) {
            URLEncoder.convert(s.substring(start, s.length()), buf, enc);
        }
        return buf.toString();
    }

    private static void convert(String s, StringBuffer buf, String enc) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(enc);
        int j = 0;
        while (j < bytes.length) {
            buf.append('%');
            buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
            buf.append(digits.charAt(bytes[j] & 0xF));
            ++j;
        }
    }
}

