/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public class AlgorithmParameterGenerator {
    private static final String KEY_PREFIX = "AlgorithmParameterGenerator.";
    private String algorithmName;
    private Provider provider;
    private AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi paramGenSpi, Provider provider, String algName) {
        this.setProvider(provider);
        this.setAlgorithm(algName);
        this.algorithmParameterGeneratorSpi = paramGenSpi;
    }

    private static AlgorithmParameterGenerator createAlgorithmParameterGenerator(Provider provider, Class algorithmClass, String algName) throws NoSuchAlgorithmException {
        try {
            AlgorithmParameterGeneratorSpi providedAlgorithmParameterGenerator = (AlgorithmParameterGeneratorSpi)algorithmClass.newInstance();
            return new AlgorithmParameterGenerator(providedAlgorithmParameterGenerator, provider, algName);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        throw new NoSuchAlgorithmException(algName);
    }

    public final AlgorithmParameters generateParameters() {
        return this.algorithmParameterGeneratorSpi.engineGenerateParameters();
    }

    public final String getAlgorithm() {
        return this.algorithmName;
    }

    public static AlgorithmParameterGenerator getInstance(String algorithmName) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        return AlgorithmParameterGenerator.toAlgorithmParameterGeneratorImplementation(algorithmName);
    }

    public static AlgorithmParameterGenerator getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null || algorithmName == null) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return AlgorithmParameterGenerator.toAlgorithmParameterGeneratorImplementation(algorithmName, provider);
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return AlgorithmParameterGenerator.toAlgorithmParameterGeneratorImplementation(algorithm, provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int size) {
        this.algorithmParameterGeneratorSpi.engineInit(size, new SecureRandom());
    }

    public final void init(int size, SecureRandom random) {
        this.algorithmParameterGeneratorSpi.engineInit(size, random);
    }

    public final void init(AlgorithmParameterSpec genParamSpec) throws InvalidAlgorithmParameterException {
        this.algorithmParameterGeneratorSpi.engineInit(genParamSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.algorithmParameterGeneratorSpi.engineInit(genParamSpec, random);
    }

    void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    private static AlgorithmParameterGenerator toAlgorithmParameterGeneratorImplementation(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return AlgorithmParameterGenerator.toAlgorithmParameterGeneratorImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    private static AlgorithmParameterGenerator toAlgorithmParameterGeneratorImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        String algorithmParameterGeneratorClassName;
        try {
            algorithmParameterGeneratorClassName = provider.lookupProperty(KEY_PREFIX, algorithmName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        if (algorithmParameterGeneratorClassName == null) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        try {
            Class algorithmParameterGeneratorClass = Class.forName(algorithmParameterGeneratorClassName, true, provider.getClass().getClassLoader());
            return AlgorithmParameterGenerator.createAlgorithmParameterGenerator(provider, algorithmParameterGeneratorClass, algorithmName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
    }
}

