/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.text.CompactIntArray;
import com.ibm.oti.text.ComposedCharIter;
import com.ibm.oti.text.IntHashtable;
import com.ibm.oti.text.Normalizer;
import com.ibm.oti.util.Msg;
import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.text.RBCollationTables;
import java.util.Vector;

final class RBTableBuilder {
    static final int CHARINDEX = 0x70000000;
    private static final int IGNORABLEMASK = 65535;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    private RBCollationTables.BuildAPI tables = null;
    private MergeCollation mPattern = null;
    private boolean isOverIgnore = false;
    private StringBuffer key = new StringBuffer(5);
    private IntHashtable contractFlags = new IntHashtable(100);
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private CompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBTableBuilder(RBCollationTables.BuildAPI tables) {
        this.tables = tables;
    }

    public void build(String pattern, int decmp) throws ParseException {
        int i = 0;
        if (pattern.length() == 0) {
            throw new ParseException(Msg.getString("K01ad"), 0);
        }
        this.mapping = new CompactIntArray(-1);
        Normalizer.Mode mode = Normalizer.getMode(decmp);
        pattern = Normalizer.normalize(pattern, mode, 0, true);
        this.mPattern = new MergeCollation(pattern);
        int order = 0;
        i = 0;
        while (i < this.mPattern.getCount()) {
            PatternEntry entry = this.mPattern.getItemAt(i);
            if (entry != null) {
                String groupChars = entry.getChars();
                if (groupChars.length() > 1) {
                    switch (groupChars.charAt(groupChars.length() - 1)) {
                        case '@': {
                            this.frenchSec = true;
                            groupChars = groupChars.substring(0, groupChars.length() - 1);
                            break;
                        }
                        case '!': {
                            this.seAsianSwapping = true;
                            groupChars = groupChars.substring(0, groupChars.length() - 1);
                        }
                    }
                }
                order = this.increment(entry.getStrength(), order);
                String expChars = entry.getExtension();
                if (expChars.length() != 0) {
                    this.addExpandOrder(groupChars, expChars, order);
                } else if (groupChars.length() > 1) {
                    this.addContractOrder(groupChars, order);
                } else {
                    char ch = groupChars.charAt(0);
                    this.addOrder(ch, order);
                }
            }
            ++i;
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
        this.tables.fillInTables(this.frenchSec, this.seAsianSwapping, this.mapping, this.contractTable, this.expandTable, this.contractFlags, this.maxSecOrder, this.maxTerOrder);
    }

    private void addComposedChars() throws ParseException {
        StringBuffer buf = new StringBuffer(1);
        ComposedCharIter iter = new ComposedCharIter(false, 1);
        while (iter.hasNext()) {
            char c = iter.next();
            if (this.getCharOrder(c) != -1) continue;
            String s = iter.decomposition();
            int contractOrder = this.getContractOrder(s);
            if (contractOrder != -1) {
                this.addOrder(c, contractOrder);
                continue;
            }
            boolean allThere = true;
            int i = 0;
            while (i < s.length()) {
                if (this.getCharOrder(s.charAt(i)) == -1) {
                    allThere = false;
                    break;
                }
                ++i;
            }
            if (!allThere) continue;
            buf.setLength(0);
            buf.append(c);
            this.addExpandOrder(buf.toString(), s, -1);
        }
    }

    private final void commit() {
        if (this.expandTable != null) {
            int i = 0;
            while (i < this.expandTable.size()) {
                int[] valueList = (int[])this.expandTable.elementAt(i);
                int j = 0;
                while (j < valueList.length) {
                    int order = valueList[j];
                    if (order < 0x7E000000 && order > 0x70000000) {
                        char ch = (char)(order - 0x70000000);
                        int realValue = this.getCharOrder(ch);
                        valueList[j] = realValue == -1 ? 0xFFFF & ch : realValue;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private final int increment(int aStrength, int lastValue) {
        switch (aStrength) {
            case 0: {
                lastValue += 65536;
                lastValue &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                lastValue += 256;
                lastValue &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++lastValue;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
            }
        }
        return lastValue;
    }

    private final void addOrder(char ch, int anOrder) {
        int order = this.mapping.elementAt(ch);
        if (order >= 0x7F000000) {
            this.key.setLength(0);
            this.key.append(ch);
            this.addContractOrder(this.key.toString(), anOrder);
        } else {
            this.mapping.setElementAt(ch, anOrder);
        }
    }

    private final void addContractOrder(String groupChars, int anOrder) {
        this.addContractOrder(groupChars, anOrder, true);
    }

    private final void addContractOrder(String groupChars, int anOrder, boolean fwd) {
        int index;
        int entry;
        Vector entryTable;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((entryTable = this.getContractValues((entry = this.mapping.elementAt(groupChars.charAt(0))) - 0x7F000000)) == null) {
            int tableIndex = 0x7F000000 + this.contractTable.size();
            entryTable = new Vector(20);
            this.contractTable.addElement(entryTable);
            entryTable.addElement(new EntryPair(groupChars.substring(0, 1), entry));
            this.mapping.setElementAt(groupChars.charAt(0), tableIndex);
        }
        if ((index = RBCollationTables.getEntry(entryTable, groupChars, fwd)) != -1) {
            EntryPair pair = (EntryPair)entryTable.elementAt(index);
            pair.value = anOrder;
        } else {
            EntryPair pair = (EntryPair)entryTable.lastElement();
            if (groupChars.length() > pair.entryName.length()) {
                entryTable.addElement(new EntryPair(groupChars, anOrder, fwd));
            } else {
                entryTable.insertElementAt(new EntryPair(groupChars, anOrder, fwd), entryTable.size() - 1);
            }
        }
        if (fwd && groupChars.length() > 1) {
            this.addContractFlags(groupChars);
            this.addContractOrder(new StringBuffer(groupChars).reverse().toString(), anOrder, false);
        }
    }

    private int getContractOrder(String groupChars) {
        int index;
        Vector entryTable;
        int result = -1;
        if (this.contractTable != null && (entryTable = this.getContractValues(groupChars.charAt(0))) != null && (index = RBCollationTables.getEntry(entryTable, groupChars, true)) != -1) {
            EntryPair pair = (EntryPair)entryTable.elementAt(index);
            result = pair.value;
        }
        return result;
    }

    private final int getCharOrder(char ch) {
        int order = this.mapping.elementAt(ch);
        if (order >= 0x7F000000) {
            Vector groupList = this.getContractValues(order - 0x7F000000);
            EntryPair pair = (EntryPair)groupList.firstElement();
            order = pair.value;
        }
        return order;
    }

    Vector getContractValues(char ch) {
        int index = this.mapping.elementAt(ch);
        return this.getContractValues(index - 0x7F000000);
    }

    Vector getContractValues(int index) {
        if (index >= 0) {
            return (Vector)this.contractTable.elementAt(index);
        }
        return null;
    }

    private final void addExpandOrder(String contractChars, String expandChars, int anOrder) throws ParseException {
        int tableIndex = this.addExpansion(anOrder, expandChars);
        if (contractChars.length() > 1) {
            this.addContractOrder(contractChars, tableIndex);
        } else {
            this.addOrder(contractChars.charAt(0), tableIndex);
        }
    }

    private int addExpansion(int anOrder, String expandChars) {
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int offset = anOrder == -1 ? 0 : 1;
        int[] valueList = new int[expandChars.length() + offset];
        if (offset == 1) {
            valueList[0] = anOrder;
        }
        int i = 0;
        while (i < expandChars.length()) {
            char ch = expandChars.charAt(i);
            int mapValue = this.getCharOrder(ch);
            valueList[i + offset] = mapValue != -1 ? mapValue : 0x70000000 + ch;
            ++i;
        }
        int tableIndex = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(valueList);
        return tableIndex;
    }

    private void addContractFlags(String chars) {
        int len = chars.length();
        int i = 0;
        while (i < len) {
            char c = chars.charAt(i);
            this.contractFlags.put(c, 1);
            ++i;
        }
    }
}

