/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.Msg;
import java.io.Serializable;

public class BitSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7997698588986878753L;
    private long[] bits;
    private static final int ELM_SIZE = 64;

    public BitSet() {
        this(64);
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[nbits / 64 + (nbits % 64 > 0 ? 1 : 0)];
    }

    private BitSet(long[] bits) {
        this.bits = bits;
    }

    public Object clone() {
        try {
            BitSet clone = (BitSet)super.clone();
            clone.bits = (long[])this.bits.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BitSet) {
            int length1 = this.bits.length;
            long[] bsBits = ((BitSet)obj).bits;
            int length2 = bsBits.length;
            if (length1 <= length2) {
                int i = 0;
                while (i < length1) {
                    if (this.bits[i] != bsBits[i]) {
                        return false;
                    }
                    ++i;
                }
                i = length1;
                while (i < length2) {
                    if (bsBits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length2) {
                    if (this.bits[i] != bsBits[i]) {
                        return false;
                    }
                    ++i;
                }
                i = length2;
                while (i < length1) {
                    if (this.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private void growBits(int pos) {
        long[] tempBits = new long[++pos / 64 + (pos % 64 > 0 ? 1 : 0)];
        System.arraycopy((Object)this.bits, 0, (Object)tempBits, 0, this.bits.length);
        this.bits = tempBits;
    }

    public int hashCode() {
        long x = 1234L;
        int i = 0;
        int length = this.bits.length;
        while (i < length) {
            x ^= this.bits[i] * (long)(i + 1);
            ++i;
        }
        return (int)(x >> 32 ^ x);
    }

    public boolean get(int pos) {
        if (pos >= 0) {
            if (pos < this.bits.length * 64) {
                return (this.bits[pos / 64] & 1L << pos % 64) != 0L;
            }
            return false;
        }
        throw new IndexOutOfBoundsException(Msg.getString("K0006"));
    }

    public BitSet get(int pos1, int pos2) {
        if (pos1 >= 0 && pos2 >= 0 && pos2 >= pos1) {
            int last = this.bits.length * 64;
            if (pos1 >= last || pos1 == pos2) {
                return new BitSet(0);
            }
            if (pos2 > last) {
                pos2 = last;
            }
            int idx1 = pos1 / 64;
            int idx2 = (pos2 - 1) / 64;
            long factor1 = -1L << pos1 % 64;
            long factor2 = -1L >>> 64 - pos2 % 64;
            if (idx1 == idx2) {
                long result = (this.bits[idx1] & (factor1 & factor2)) >>> pos1 % 64;
                return new BitSet(new long[]{result});
            }
            long[] newbits = new long[idx2 - idx1 + 1];
            newbits[0] = this.bits[idx1] & factor1;
            newbits[newbits.length - 1] = this.bits[idx2] & factor2;
            int i = 1;
            while (i < idx2 - idx1) {
                newbits[i] = this.bits[idx1 + i];
                ++i;
            }
            int numBitsToShift = pos1 % 64;
            if (numBitsToShift != 0) {
                int i2 = 0;
                while (i2 < newbits.length) {
                    newbits[i2] = newbits[i2] >>> numBitsToShift;
                    if (i2 != newbits.length - 1) {
                        int n = i2;
                        newbits[n] = newbits[n] | newbits[i2 + 1] << 64 - numBitsToShift;
                    }
                    ++i2;
                }
            }
            return new BitSet(newbits);
        }
        throw new IndexOutOfBoundsException(Msg.getString("K0006"));
    }

    public void set(int pos) {
        if (pos >= 0) {
            if (pos >= this.bits.length * 64) {
                this.growBits(pos);
            }
        } else {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n = pos / 64;
        this.bits[n] = this.bits[n] | 1L << pos % 64;
    }

    public void set(int pos, boolean val) {
        if (val) {
            this.set(pos);
        } else {
            this.clear(pos);
        }
    }

    public void set(int pos1, int pos2) {
        if (pos1 >= 0 && pos2 >= 0 && pos2 >= pos1) {
            if (pos1 == pos2) {
                return;
            }
            if (pos2 >= this.bits.length * 64) {
                this.growBits(pos2);
            }
            int idx1 = pos1 / 64;
            int idx2 = (pos2 - 1) / 64;
            long factor1 = -1L << pos1 % 64;
            long factor2 = -1L >>> 64 - pos2 % 64;
            if (idx1 == idx2) {
                int n = idx1;
                this.bits[n] = this.bits[n] | factor1 & factor2;
            } else {
                int n = idx1;
                this.bits[n] = this.bits[n] | factor1;
                int n2 = idx2;
                this.bits[n2] = this.bits[n2] | factor2;
                int i = idx1 + 1;
                while (i < idx2) {
                    int n3 = i++;
                    this.bits[n3] = this.bits[n3] | 0xFFFFFFFFFFFFFFFFL;
                }
            }
        } else {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
    }

    public void set(int pos1, int pos2, boolean val) {
        if (val) {
            this.set(pos1, pos2);
        } else {
            this.clear(pos1, pos2);
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    public void clear(int pos) {
        if (pos >= 0) {
            if (pos < this.bits.length * 64) {
                int n = pos / 64;
                this.bits[n] = this.bits[n] & (1L << pos % 64 ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
    }

    public void clear(int pos1, int pos2) {
        if (pos1 >= 0 && pos2 >= 0 && pos2 >= pos1) {
            int last = this.bits.length * 64;
            if (pos1 >= last || pos1 == pos2) {
                return;
            }
            if (pos2 > last) {
                pos2 = last;
            }
            int idx1 = pos1 / 64;
            int idx2 = (pos2 - 1) / 64;
            long factor1 = -1L << pos1 % 64;
            long factor2 = -1L >>> 64 - pos2 % 64;
            if (idx1 == idx2) {
                int n = idx1;
                this.bits[n] = this.bits[n] & (factor1 & factor2 ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                int n = idx1;
                this.bits[n] = this.bits[n] & (factor1 ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = idx2;
                this.bits[n2] = this.bits[n2] & (factor2 ^ 0xFFFFFFFFFFFFFFFFL);
                int i = idx1 + 1;
                while (i < idx2) {
                    this.bits[i] = 0L;
                    ++i;
                }
            }
        } else {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
    }

    public void flip(int pos) {
        if (pos >= 0) {
            if (pos >= this.bits.length * 64) {
                this.growBits(pos);
            }
        } else {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
        int n = pos / 64;
        this.bits[n] = this.bits[n] ^ 1L << pos % 64;
    }

    public void flip(int pos1, int pos2) {
        if (pos1 >= 0 && pos2 >= 0 && pos2 >= pos1) {
            if (pos1 == pos2) {
                return;
            }
            if (pos2 >= this.bits.length * 64) {
                this.growBits(pos2);
            }
            int idx1 = pos1 / 64;
            int idx2 = (pos2 - 1) / 64;
            long factor1 = -1L << pos1 % 64;
            long factor2 = -1L >>> 64 - pos2 % 64;
            if (idx1 == idx2) {
                int n = idx1;
                this.bits[n] = this.bits[n] ^ factor1 & factor2;
            } else {
                int n = idx1;
                this.bits[n] = this.bits[n] ^ factor1;
                int n2 = idx2;
                this.bits[n2] = this.bits[n2] ^ factor2;
                int i = idx1 + 1;
                while (i < idx2) {
                    int n3 = i++;
                    this.bits[n3] = this.bits[n3] ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        } else {
            throw new IndexOutOfBoundsException(Msg.getString("K0006"));
        }
    }

    public boolean intersects(BitSet bs) {
        int length1 = this.bits.length;
        long[] bsBits = bs.bits;
        int length2 = bsBits.length;
        if (length1 <= length2) {
            int i = 0;
            while (i < length1) {
                if ((this.bits[i] & bsBits[i]) != 0L) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < length2) {
                if ((this.bits[i] & bsBits[i]) != 0L) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void and(BitSet bs) {
        int length1 = this.bits.length;
        long[] bsBits = bs.bits;
        int length2 = bsBits.length;
        if (length1 <= length2) {
            int i = 0;
            while (i < length1) {
                int n = i;
                this.bits[n] = this.bits[n] & bsBits[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < length2) {
                int n = i;
                this.bits[n] = this.bits[n] & bsBits[i];
                ++i;
            }
            i = length2;
            while (i < length1) {
                this.bits[i] = 0L;
                ++i;
            }
        }
    }

    public void andNot(BitSet bs) {
        long[] bsBits = bs.bits;
        int range = this.bits.length < bsBits.length ? this.bits.length : bsBits.length;
        int i = 0;
        while (i < range) {
            int n = i;
            this.bits[n] = this.bits[n] & (bsBits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public void or(BitSet bs) {
        int nbits = bs.length();
        int length = nbits / 64 + (nbits % 64 > 0 ? 1 : 0);
        if (length > this.bits.length) {
            this.growBits(nbits - 1);
        }
        long[] bsBits = bs.bits;
        int i = 0;
        while (i < length) {
            int n = i;
            this.bits[n] = this.bits[n] | bsBits[i];
            ++i;
        }
    }

    public void xor(BitSet bs) {
        int nbits = bs.length();
        int length = nbits / 64 + (nbits % 64 > 0 ? 1 : 0);
        if (length > this.bits.length) {
            this.growBits(nbits - 1);
        }
        long[] bsBits = bs.bits;
        int i = 0;
        while (i < length) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bsBits[i];
            ++i;
        }
    }

    public int size() {
        return this.bits.length * 64;
    }

    public int length() {
        int idx = this.bits.length - 1;
        while (idx >= 0 && this.bits[idx] == 0L) {
            --idx;
        }
        if (idx == -1) {
            return 0;
        }
        int i = 63;
        long val = this.bits[idx];
        while ((val & 1L << i) == 0L && i > 0) {
            --i;
        }
        return idx * 64 + i + 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.bits.length / 2);
        int bitCount = 0;
        sb.append('{');
        boolean comma = false;
        int i = 0;
        while (i < this.bits.length) {
            if (this.bits[i] == 0L) {
                bitCount += 64;
            } else {
                int j = 0;
                while (j < 64) {
                    if ((this.bits[i] & 1L << j) != 0L) {
                        if (comma) {
                            sb.append(", ");
                        }
                        sb.append(bitCount);
                        comma = true;
                    }
                    ++bitCount;
                    ++j;
                }
            }
            ++i;
        }
        sb.append('}');
        return sb.toString();
    }

    public int nextSetBit(int pos) {
        if (pos >= 0) {
            int j;
            if (pos >= this.bits.length * 64) {
                return -1;
            }
            int idx = pos / 64;
            if (this.bits[idx] != 0L) {
                j = pos % 64;
                while (j < 64) {
                    if ((this.bits[idx] & 1L << j) != 0L) {
                        return idx * 64 + j;
                    }
                    ++j;
                }
            }
            ++idx;
            while (idx < this.bits.length && this.bits[idx] == 0L) {
                ++idx;
            }
            if (idx == this.bits.length) {
                return -1;
            }
            j = 0;
            while (j < 64) {
                if ((this.bits[idx] & 1L << j) != 0L) {
                    return idx * 64 + j;
                }
                ++j;
            }
            return -1;
        }
        throw new IndexOutOfBoundsException(Msg.getString("K0006"));
    }

    public int nextClearBit(int pos) {
        if (pos >= 0) {
            int j;
            int bssize = this.bits.length * 64;
            if (pos >= bssize) {
                return pos;
            }
            int idx = pos / 64;
            if (this.bits[idx] != -1L) {
                j = pos % 64;
                while (j < 64) {
                    if ((this.bits[idx] & 1L << j) == 0L) {
                        return idx * 64 + j;
                    }
                    ++j;
                }
            }
            ++idx;
            while (idx < this.bits.length && this.bits[idx] == -1L) {
                ++idx;
            }
            if (idx == this.bits.length) {
                return bssize;
            }
            j = 0;
            while (j < 64) {
                if ((this.bits[idx] & 1L << j) == 0L) {
                    return idx * 64 + j;
                }
                ++j;
            }
            return bssize;
        }
        throw new IndexOutOfBoundsException(Msg.getString("K0006"));
    }

    public boolean isEmpty() {
        int idx = 0;
        while (idx < this.bits.length) {
            if (this.bits[idx] != 0L) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public int cardinality() {
        int count = 0;
        int idx = 0;
        while (idx < this.bits.length) {
            long temp = this.bits[idx];
            if (temp != 0L) {
                int i = 0;
                while (i < 64) {
                    if ((temp & 1L << i) != 0L) {
                        ++count;
                    }
                    ++i;
                }
            }
            ++idx;
        }
        return count;
    }
}

