/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;
import java.util.StringTokenizer;

public final class PropertyPermission
extends BasicPermission {
    private static final long serialVersionUID = 885438825399942851L;
    private transient boolean read;
    private transient boolean write;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[1];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("actions", clazz);
        serialPersistentFields = objectStreamFieldArray;
    }

    public PropertyPermission(String name, String actions) {
        super(name);
        this.decodeActions(actions);
    }

    private void decodeActions(String actions) {
        StringTokenizer tokenizer = new StringTokenizer(actions.toLowerCase(), " \t\n\r,");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("read")) {
                this.read = true;
                continue;
            }
            if (token.equals("write")) {
                this.write = true;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (!this.read && !this.write) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            PropertyPermission pp = (PropertyPermission)o;
            return this.read == pp.read && this.write == pp.write;
        }
        return false;
    }

    public String getActions() {
        return this.read ? (this.write ? "read,write" : "read") : "write";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean implies(Permission permission) {
        if (super.implies(permission)) {
            PropertyPermission pp = (PropertyPermission)permission;
            return !(!this.read && pp.read || !this.write && pp.write);
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("actions", this.getActions());
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        String actions = (String)fields.get("actions", "");
        this.decodeActions(actions);
    }
}

