/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarEntry
extends ZipEntry {
    private Attributes attributes;
    JarFile parentJar;
    Certificate[] certificates;

    public JarEntry(String name) {
        super(name);
    }

    public JarEntry(ZipEntry entry) {
        super(entry);
    }

    public Attributes getAttributes() throws IOException {
        if (this.attributes != null || this.parentJar == null) {
            return this.attributes;
        }
        Manifest manifest = this.parentJar.getManifest();
        if (manifest == null) {
            return null;
        }
        this.attributes = manifest.getAttributes(this.getName());
        return this.attributes;
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    void setAttributes(Attributes attrib) {
        this.attributes = attrib;
    }

    public JarEntry(JarEntry je) {
        super(je);
        this.parentJar = je.parentJar;
        this.attributes = je.attributes;
        this.certificates = je.certificates;
    }
}

