/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.InitManifest;

public class Manifest
implements Cloneable {
    private Attributes mainAttributes = new Attributes();
    private HashMap entryAttributes = new HashMap();
    private HashMap chunks;

    public Manifest() {
    }

    public Manifest(InputStream is) throws IOException {
        this.read(is);
    }

    Manifest(InputStream is, boolean readChunks) throws IOException {
        if (readChunks) {
            this.chunks = new HashMap();
        }
        this.read(is);
    }

    public void clear() {
        this.entryAttributes.clear();
        this.mainAttributes.clear();
    }

    public Attributes getAttributes(String name) {
        return (Attributes)this.getEntries().get(name);
    }

    public Map getEntries() {
        return this.entryAttributes;
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    public Manifest(Manifest man) {
        this.mainAttributes = (Attributes)man.mainAttributes.clone();
        this.entryAttributes = (HashMap)man.entryAttributes.clone();
    }

    public Object clone() {
        return new Manifest(this);
    }

    public void write(OutputStream os) throws IOException {
        new WriteManifest().write(this, os);
    }

    public void read(InputStream is) throws IOException {
        new InitManifest(is, this.mainAttributes, this.entryAttributes, this.chunks, null);
    }

    public int hashCode() {
        return this.mainAttributes.hashCode() ^ this.entryAttributes.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mainAttributes.equals(((Manifest)o).mainAttributes)) {
            return false;
        }
        return this.entryAttributes.equals(((Manifest)o).entryAttributes);
    }

    byte[] getChunk(String name) {
        return (byte[])this.chunks.get(name);
    }

    void removeChunks() {
        this.chunks = null;
    }

    static class WriteManifest {
        private static final int LIMIT = 70;
        private static byte[] sepBuf = new byte[]{13, 10};
        private static Attributes.Name nameAttribute = new Attributes.Name("Name", false);
        byte[] oneByte = new byte[1];
        char[] oneChar = new char[1];
        private CharacterConverter converter;
        private byte[] outBuf = new byte[70];
        OutputStream os;

        WriteManifest() {
        }

        private void writeEntry(Attributes.Name name, String value) throws IOException {
            int offset = 0;
            int limit = 70;
            byte[] out = (String.valueOf(name.toString()) + ": ").getBytes("ISO8859_1");
            if (out.length > limit) {
                while (out.length - offset >= limit) {
                    int len = out.length - offset;
                    if (len > limit) {
                        len = limit;
                    }
                    if (offset > 0) {
                        this.os.write(32);
                    }
                    this.os.write(out, offset, len);
                    this.os.write(sepBuf);
                    offset += len;
                    limit = 69;
                }
            }
            int size = out.length - offset;
            System.arraycopy((Object)out, offset, (Object)this.outBuf, 0, size);
            int i = 0;
            while (i < value.length()) {
                byte[] buf;
                this.oneChar[0] = value.charAt(i);
                if (this.oneChar[0] < '\u0080' || this.converter == null) {
                    this.oneByte[0] = (byte)this.oneChar[0];
                    buf = this.oneByte;
                } else {
                    buf = this.converter.convert(this.oneChar, 0, 1);
                }
                if (size + buf.length > limit) {
                    if (limit != 70) {
                        this.os.write(32);
                    }
                    this.os.write(this.outBuf, 0, size);
                    this.os.write(sepBuf);
                    limit = 69;
                    size = 0;
                }
                if (buf.length == 1) {
                    this.outBuf[size] = buf[0];
                } else {
                    System.arraycopy((Object)buf, 0, (Object)this.outBuf, size, buf.length);
                }
                size += buf.length;
                ++i;
            }
            if (size > 0) {
                if (limit != 70) {
                    this.os.write(32);
                }
                this.os.write(this.outBuf, 0, size);
                this.os.write(sepBuf);
            }
        }

        void write(Manifest manifest, OutputStream out) throws IOException {
            String version;
            this.os = out;
            String encoding = (String)AccessController.doPrivileged(new PriviAction("manifest.write.encoding"));
            if (encoding != null) {
                if ("".equals(encoding)) {
                    encoding = "UTF8";
                }
                this.converter = CharacterConverter.getConverter(encoding);
                if (this.converter == null) {
                    throw new UnsupportedEncodingException(encoding);
                }
            }
            if ((version = manifest.mainAttributes.getValue(Attributes.Name.MANIFEST_VERSION)) != null) {
                this.writeEntry(Attributes.Name.MANIFEST_VERSION, version);
                Iterator entries = manifest.mainAttributes.keySet().iterator();
                while (entries.hasNext()) {
                    Attributes.Name name = (Attributes.Name)entries.next();
                    if (name.equals(Attributes.Name.MANIFEST_VERSION)) continue;
                    this.writeEntry(name, manifest.mainAttributes.getValue(name));
                }
            }
            this.os.write(sepBuf);
            Iterator i = manifest.entryAttributes.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.writeEntry(nameAttribute, key);
                Attributes attrib = (Attributes)manifest.entryAttributes.get(key);
                Iterator entries = attrib.keySet().iterator();
                while (entries.hasNext()) {
                    Attributes.Name name = (Attributes.Name)entries.next();
                    this.writeEntry(name, attrib.getValue(name));
                }
                this.os.write(sepBuf);
            }
        }
    }
}

