/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream os) throws IOException {
        this(os, 512);
    }

    public GZIPOutputStream(OutputStream os, int size) throws IOException {
        super(os, new Deflater(-1, true), size);
        this.writeShort(35615);
        this.out.write(8);
        this.out.write(0);
        this.writeLong(0L);
        this.out.write(0);
        this.out.write(0);
    }

    public void finish() throws IOException {
        super.finish();
        this.writeLong(this.crc.getValue());
        this.writeLong(this.crc.tbytes);
    }

    public void close() throws IOException {
        if (!this.done) {
            this.finish();
        }
        super.close();
    }

    public void write(byte[] buf, int off, int nbytes) throws IOException {
        super.write(buf, off, nbytes);
        this.crc.update(buf, off, nbytes);
    }

    private int writeShort(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >> 8 & 0xFF);
        return i;
    }

    private long writeLong(long i) throws IOException {
        this.out.write((int)(i & 0xFFL));
        this.out.write((int)(i >> 8) & 0xFF);
        this.out.write((int)(i >> 16) & 0xFF);
        this.out.write((int)(i >> 24) & 0xFF);
        return i;
    }
}

