/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.Msg;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    Cipher cipher = null;
    byte[] internalBuffer = new byte[0];
    int internalBufferIndex = 0;
    private static final int DATA_READ_SIZE = 64;
    private boolean inputExhausted = false;
    private boolean closed = false;

    public CipherInputStream(InputStream is, Cipher cipher) {
        super(is);
        if (cipher == null) {
            throw new NullPointerException();
        }
        this.cipher = cipher;
    }

    protected CipherInputStream(InputStream is) {
        super(is);
        this.cipher = new NullCipher();
    }

    public int read() throws IOException {
        byte[] result = new byte[1];
        int readResult = this.read(result, 0, 1);
        if (readResult == -1) {
            return readResult;
        }
        return result[0] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("JCE005"));
        }
        if (start < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        if (this.inputExhausted && this.bytesInInternalBuffer() == 0) {
            return -1;
        }
        if (length <= this.bytesInInternalBuffer()) {
            if (buffer != null) {
                System.arraycopy((Object)this.internalBuffer, this.internalBufferIndex, (Object)buffer, start, length);
            }
            this.internalBufferIndex += length;
            return length;
        }
        if (buffer != null) {
            System.arraycopy((Object)this.internalBuffer, this.internalBufferIndex, (Object)buffer, start, this.bytesInInternalBuffer());
        }
        int bufferIndex = start + this.bytesInInternalBuffer();
        int bytesLeft = length - this.bytesInInternalBuffer();
        this.clearInternalBuffer();
        if (this.inputExhausted) {
            return length - bytesLeft;
        }
        int bytesRead = 0;
        byte[] inputBuffer = new byte[64];
        while (bytesLeft > 0) {
            bytesRead = this.fillFromStream(inputBuffer);
            byte[] processedData = null;
            if (this.inputExhausted) {
                try {
                    if (bytesRead == -1) {
                        processedData = this.cipher.doFinal();
                    }
                    processedData = this.cipher.doFinal(inputBuffer, 0, bytesRead);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                processedData = this.cipher.update(inputBuffer, 0, bytesRead);
            }
            if (processedData != null) {
                if (processedData.length >= bytesLeft) {
                    if (buffer != null) {
                        System.arraycopy((Object)processedData, 0, (Object)buffer, bufferIndex, bytesLeft);
                    }
                    this.internalBuffer = new byte[processedData.length - bytesLeft];
                    this.internalBufferIndex = 0;
                    System.arraycopy((Object)processedData, bytesLeft, (Object)this.internalBuffer, 0, processedData.length - bytesLeft);
                    return length;
                }
                if (buffer != null) {
                    System.arraycopy((Object)processedData, 0, (Object)buffer, bufferIndex, processedData.length);
                }
                bufferIndex += processedData.length;
                bytesLeft -= processedData.length;
            } else if (this.inputExhausted) {
                return -1;
            }
            if (!this.inputExhausted) continue;
            return length - bytesLeft;
        }
        throw new InternalError();
    }

    private int fillFromStream(byte[] buffer) throws IOException {
        int bytesRequested = buffer.length;
        int bytesRead = this.in.read(buffer);
        if (bytesRead == -1) {
            this.inputExhausted = true;
            return -1;
        }
        int secondChanceBytesRead = 0;
        if (bytesRead < bytesRequested && (secondChanceBytesRead = this.in.read(buffer, bytesRead, bytesRequested - bytesRead)) == -1) {
            this.inputExhausted = true;
            return bytesRead;
        }
        return bytesRead + secondChanceBytesRead;
    }

    public long skip(long len) throws IOException {
        if (len < 0L) {
            return 0L;
        }
        if (len < (long)this.bytesInInternalBuffer()) {
            this.internalBufferIndex = (int)((long)this.internalBufferIndex + len);
            return len;
        }
        int result = this.bytesInInternalBuffer();
        this.clearInternalBuffer();
        return result;
    }

    public int available() throws IOException {
        byte[] availableData = this.getProcessedDataWithoutBlocking();
        if (availableData.length > 0) {
            byte[] newInternalBuffer = new byte[this.bytesInInternalBuffer() + availableData.length];
            System.arraycopy((Object)this.internalBuffer, this.internalBufferIndex, (Object)newInternalBuffer, 0, this.bytesInInternalBuffer());
            System.arraycopy((Object)availableData, 0, (Object)newInternalBuffer, this.bytesInInternalBuffer(), availableData.length);
            this.internalBuffer = newInternalBuffer;
            this.internalBufferIndex = 0;
        }
        return this.bytesInInternalBuffer();
    }

    public void close() throws IOException {
        this.in.close();
        this.cipher = null;
        this.internalBuffer = null;
        this.closed = true;
    }

    public boolean markSupported() {
        return false;
    }

    private byte[] getProcessedDataWithoutBlocking() throws IOException {
        int availableOnStream = this.in.available();
        if (availableOnStream == 0) {
            return new byte[0];
        }
        byte[] unprocessedData = new byte[availableOnStream];
        int bytesRead = 0;
        int i = 0;
        while (i < availableOnStream) {
            bytesRead = this.in.read(unprocessedData, i, availableOnStream - i);
            if (bytesRead == -1) {
                throw new IOException();
            }
            i += bytesRead;
        }
        byte[] result = this.cipher.update(unprocessedData);
        if (result == null) {
            return new byte[0];
        }
        return result;
    }

    private int bytesInInternalBuffer() {
        if (this.internalBuffer == null) {
            return 0;
        }
        return this.internalBuffer.length - this.internalBufferIndex;
    }

    private void clearInternalBuffer() {
        this.internalBuffer = new byte[0];
        this.internalBufferIndex = 0;
    }
}

