/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;

public class PBEKeySpec
implements KeySpec {
    private char[] password = null;
    private byte[] salt = null;
    private int iterationCount = 0;
    private int keyLength = 0;
    private boolean clearCalled = false;

    public PBEKeySpec(char[] password) {
        this.password = password == null ? new char[0] : password;
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount) {
        if (salt == null) {
            throw new NullPointerException();
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException();
        }
        this.salt = (byte[])salt.clone();
        if (iterationCount < 1) {
            throw new IllegalArgumentException();
        }
        this.iterationCount = iterationCount;
        this.password = password == null ? new char[0] : password;
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount, int keyLength) {
        if (salt == null) {
            throw new NullPointerException();
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException();
        }
        this.salt = (byte[])salt.clone();
        if (iterationCount < 1) {
            throw new IllegalArgumentException();
        }
        this.iterationCount = iterationCount;
        if (keyLength < 1) {
            throw new IllegalArgumentException();
        }
        this.keyLength = keyLength;
        this.password = password == null ? new char[0] : (char[])password.clone();
    }

    public final void clearPassword() {
        if (this.password != null) {
            int i = 0;
            while (i < this.password.length) {
                this.password[i] = '\u0000';
                ++i;
            }
        }
        this.clearCalled = true;
    }

    public final char[] getPassword() {
        if (this.clearCalled) {
            throw new IllegalStateException();
        }
        return (char[])this.password.clone();
    }

    public final byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        return (byte[])this.salt.clone();
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }
}

