/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.alarmlist.controller.impl;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import se.ericsson.cello.em.fm.alarmlist.AlarmList;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmListener;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmSuppressionMonitor;
import se.ericsson.cello.em.fm.alarmlist.view.impl.AlarmListView;
import se.ericsson.cello.em.fm.common.config.ifc.Configuration;
import se.ericsson.cello.em.fm.common.config.ifc.PrintingService;
import se.ericsson.cello.em.fm.common.controller.ifc.ToolController;
import se.ericsson.cello.em.fm.common.details.controller.impl.DetailsController;
import se.ericsson.cello.em.fm.common.model.ifc.SelectedObjectInterface;
import se.ericsson.cello.em.fm.common.model.impl.EventType;
import se.ericsson.cello.em.fm.common.model.impl.NealAlarmParser;
import se.ericsson.cello.em.fm.common.model.impl.NonEditableSortedTableModel;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.model.impl.Severity;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmError;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;
import se.ericsson.cello.em.fm.common.utils.impl.TimeConverter;
import se.ericsson.cello.em.fm.common.view.impl.AbstractActions;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmListController
implements SelectedObjectInterface,
ToolController {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final Dimension DEFAULT_DIMENSION = new Dimension(800, 500);
    private static final EnumMap<Severity, Integer> SUMMARY_CLEAR = new EnumMap(Severity.class);
    private AlarmListener alarmListener;
    private AlarmListView view;
    private DetailsController detailsController;
    private FmService fmService;
    private NealAlarmParser parser;
    private NonEditableSortedTableModel model;
    private ToolService toolService;
    private AlarmSuppressionMonitor alarmSuppressionMonitor;
    private Beeper beeper;
    protected PrintingService printingService;
    private Launchable alarmList;

    public AlarmListController(Launchable launchable, ToolService toolService) {
        SUMMARY_CLEAR.put(Severity.CLEARED, 0);
        SUMMARY_CLEAR.put(Severity.CRITICAL, 0);
        SUMMARY_CLEAR.put(Severity.INDETERMINATE, 0);
        SUMMARY_CLEAR.put(Severity.MAJOR, 0);
        SUMMARY_CLEAR.put(Severity.MINOR, 0);
        SUMMARY_CLEAR.put(Severity.UNKNOWN_SEVERITY, 0);
        SUMMARY_CLEAR.put(Severity.WARNING, 0);
        this.detailsController = null;
        this.printingService = null;
        this.alarmList = null;
        this.toolService = toolService;
        this.alarmList = launchable;
    }

    public ToolService getToolService() {
        return this.toolService;
    }

    @Override
    public void init() {
        LOG.info("Initializing alarm list controller and view...", new Object[0]);
        this.model = new NonEditableSortedTableModel(FmType.ALARM_LIST);
        this.parser = new NealAlarmParser();
        this.beeper = new Beeper();
        SwingUtilities.invokeLater(new GuiThread(Action.CREATE_VIEW));
        try {
            this.fmService = this.toolService.getNodeServices().getNode().getFmService();
        }
        catch (Exception e) {
            FmError.NODE_SERVICES_NOT_AVAILABLE.displayError(this.view.getView(), e, new Object[0]);
            return;
        }
        this.alarmListener = new AlarmListener(this, this.fmService);
        this.processAlarmList();
        SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
        this.alarmListener.startListening();
        this.alarmSuppressionMonitor = new AlarmSuppressionMonitor(this);
    }

    @Override
    public void bringGuiToFront() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.view.bringToFront();
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.BRING2FRONT));
        }
    }

    @Override
    public RecordContent getSelectedObject() {
        return this.model.getRow(this.view.getSelectedRow());
    }

    @Override
    public void disposeDetailWindow() {
        this.detailsController = null;
    }

    @Override
    public JFrame getView() {
        return this.view == null ? null : this.view.getView();
    }

    public AlarmListView getAlarmListView() {
        return this.view;
    }

    public void addAlarm(Alarm alarm) {
        RecordContent recordContent = this.parser.parse(alarm);
        if (recordContent.isOk()) {
            this.model.addRow(recordContent);
            SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
            this.beeper.newAlarm(recordContent);
        } else {
            LOG.info("Received an alarm notification with a faulty alarm.", new Object[0]);
        }
    }

    public void updateAlarm(Alarm alarm) {
        this.removeAlarm(alarm);
        this.addAlarm(alarm);
    }

    public void removeAlarm(Alarm alarm) {
        String alarmId = alarm.getAlarmId();
        if (alarmId != null) {
            int rows = this.model.getNonFilteredRowCount();
            for (int i = 0; i < rows; ++i) {
                RecordContent recordContent = this.model.getNonFilteredRow(i);
                if (!alarmId.equals(recordContent.get((Object)LogPart.ALARM_ID))) continue;
                this.model.removeRow(i);
                SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
            }
        }
    }

    public void rebuildAlarmList() {
        this.model.removeAllRows();
        this.processAlarmList();
        SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
    }

    @Override
    public void rowSelected() {
        RecordContent recordContent = this.getSelectedObject();
        ((AlarmList)this.alarmList).sendEmNotification("se.ericsson.cello.em.fm.alarmlist.ALARM_SELECTED", recordContent.getAsProperties(), this);
    }

    private void processAlarmList() {
        Alarm[] alarms;
        LOG.info("Processing alarm list...", new Object[0]);
        for (Alarm alarm : alarms = this.fmService.getAlarmList()) {
            RecordContent recordContent = this.parser.parse(alarm);
            if (recordContent.isOk()) {
                this.model.addRowNoUpdate(recordContent);
                this.beeper.newAlarm(recordContent);
                continue;
            }
            FmError.XML.displayError(this.view.getView(), null, new Object[0]);
        }
    }

    private void updateView() {
        this.view.sortTable();
        this.view.setNoOfAlarms(this.model.getNonFilteredRowCount(), this.model.getRowCount());
        this.view.setTimeStamp(new TimeConverter().getCurrentTime());
        this.view.setAlarmSummary(this.getSummary());
        if (this.alarmList instanceof AlarmList) {
            ((AlarmList)this.alarmList).sendEmNotification(GuiTestEventTypes.ALARMLIST_UPDATED, null, this);
        }
    }

    private EnumMap<Severity, Integer> getSummary() {
        EnumMap<Severity, Integer> summary = new EnumMap<Severity, Integer>(SUMMARY_CLEAR);
        List<RecordContent> data = this.model.getVisibleData();
        for (RecordContent recordContent : data) {
            Severity severity = (Severity)((Object)recordContent.get((Object)LogPart.PERCEIVED_SEVERITY));
            summary.put(severity, summary.get((Object)severity) + 1);
        }
        return summary;
    }

    private void exit() {
        LOG.info("Closing Alarm List main window...", new Object[0]);
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.detailsController != null) {
                this.detailsController.exit();
            }
            this.view.disposeWindow();
            if (this.alarmSuppressionMonitor != null) {
                this.alarmSuppressionMonitor.destroy();
            }
            this.detailsController = null;
            this.view = null;
            this.alarmList.exit();
            LOG.info("Alarm List Tool closed.", new Object[0]);
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.EXIT));
        }
    }

    private void addHyperToolActionsToView() {
        List<Configuration.Tool> hyperTools = this.toolService.getConfiguration().getHyperTools();
        if (!hyperTools.isEmpty()) {
            ArrayList<javax.swing.Action> hyperToolActions = new ArrayList<javax.swing.Action>(hyperTools.size());
            for (Configuration.Tool hyperTool : hyperTools) {
                HyperToolAction hyperToolAction = new HyperToolAction(hyperTool.getName(), hyperTool.getConfigFile());
                hyperToolActions.add(hyperToolAction);
            }
            this.view.addHyperToolActions(hyperToolActions);
        }
    }

    class SoundAction
    extends AbstractActions.AbstractSoundAction {
        private static final long serialVersionUID = 1L;

        SoundAction() {
        }

        public void actionPerformed(ActionEvent event) {
            AbstractButton abstractButton = (AbstractButton)event.getSource();
            AlarmListController.this.beeper.setBeepState(abstractButton.getModel().isSelected());
        }
    }

    class RefreshAction
    extends AbstractActions.AbstractRefreshAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmListController.this.rebuildAlarmList();
        }
    }

    class PrintAction
    extends AbstractActions.AbstractPrintAction {
        private static final long serialVersionUID = 1L;

        PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.print(AlarmListController.this.view.getTable(), AlarmListController.this.toolService);
        }
    }

    class PageSetupAction
    extends AbstractActions.AbstractPageSetupAction {
        private static final long serialVersionUID = 1L;

        PageSetupAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.pageSetup(AlarmListController.this.view, AlarmListController.this.toolService);
        }
    }

    class HyperToolAction
    extends AbstractActions.AbstractHyperToolAction {
        private static final long serialVersionUID = 1L;

        public HyperToolAction(String name, String configFile) {
            super(name, configFile);
        }

        public void actionPerformed(ActionEvent event) {
            RecordContent row = AlarmListController.this.getSelectedObject();
            String ldn = (String)row.get((Object)LogPart.MANAGED_OBJECT_INSTANCE);
            Properties props = AlarmListController.this.toolService.getConfiguration().getSupersedingProperties();
            props.setProperty("LDNs", ldn);
            AlarmListController.this.toolService.launchTool(this.cfgFileName, this.toolName, props);
        }
    }

    class HelpOnAlarmAction
    extends AbstractActions.AbstractHelpOnAlarmAction {
        private static final long serialVersionUID = 1L;

        HelpOnAlarmAction() {
        }

        public void actionPerformed(ActionEvent event) {
            RecordContent row = AlarmListController.this.getSelectedObject();
            String helpDoc = (String)row.get((Object)LogPart.SPECIFIC_PROBLEM);
            AlarmListController.this.toolService.displayAlexHelp(helpDoc, "");
        }
    }

    class FilterAction
    extends AbstractActions.AbstractFilterAction {
        private static final long serialVersionUID = 1L;

        public FilterAction(EventType eventType) {
            super(eventType.PRESENTATION_STRING);
        }

        public void actionPerformed(ActionEvent event) {
            AlarmListController.this.model.setFilter(AlarmListController.this.view.getFilter());
            SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
        }
    }

    class ExportAction
    extends AbstractActions.AbstractExportAction {
        private static final long serialVersionUID = 1L;

        ExportAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.export(FmType.ALARM_LIST, AlarmListController.this.view, AlarmListController.this.model);
        }
    }

    class DetailsAction
    extends AbstractActions.AbstractDetailsAction {
        private static final long serialVersionUID = 1L;

        DetailsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (AlarmListController.this.detailsController == null) {
                AlarmListController.this.detailsController = new DetailsController(FmType.ALARM_LIST, AlarmListController.this, AlarmListController.this.toolService);
                AlarmListController.this.detailsController.createView();
            } else {
                AlarmListController.this.detailsController.refreshView();
            }
        }
    }

    class CloseAction
    extends AbstractActions.AbstractCloseAction {
        private static final long serialVersionUID = 1L;

        CloseAction() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmListController.this.exit();
        }
    }

    class WindowClosingListener
    extends WindowAdapter {
        WindowClosingListener() {
        }

        public void windowClosing(WindowEvent e) {
            AlarmListController.this.exit();
        }
    }

    class GuiThread
    implements Runnable {
        private Action action;

        GuiThread(Action action) {
            this.action = action;
        }

        public void run() {
            switch (this.action) {
                case CREATE_VIEW: {
                    AlarmListController.this.view = new AlarmListView(AlarmListController.this.toolService);
                    AlarmListController.this.addHyperToolActionsToView();
                    AlarmListController.this.view.init(DEFAULT_DIMENSION);
                    AlarmListController.this.view.addRowSelectedListener(AlarmListController.this);
                    AlarmListController.this.view.addWindowClosingListener(new WindowClosingListener());
                    AlarmListController.this.view.addCloseAction(new CloseAction());
                    AlarmListController.this.view.addDetailsAction(new DetailsAction());
                    AlarmListController.this.view.addExportAction(new ExportAction());
                    AlarmListController.this.view.addFilterCommunicationAction(new FilterAction(EventType.COMMUNICATIONS_ALARM));
                    AlarmListController.this.view.addFilterEnvironmentalAction(new FilterAction(EventType.ENVIRONMENTAL_ALARM));
                    AlarmListController.this.view.addFilterEquipmentAction(new FilterAction(EventType.EQUIPMENT_ALARM));
                    AlarmListController.this.view.addFilterProcessingErrorAction(new FilterAction(EventType.PROCESSING_ERROR_ALARM));
                    AlarmListController.this.view.addFilterQosAction(new FilterAction(EventType.QUALITY_OF_SERVICE_ALARM));
                    AlarmListController.this.view.addHelpOnAlarmAction(new HelpOnAlarmAction());
                    AlarmListController.this.view.addPageSetupAction(new PageSetupAction());
                    AlarmListController.this.view.addPrintAction(new PrintAction());
                    AlarmListController.this.view.addRefreshAction(new RefreshAction());
                    AlarmListController.this.view.addSoundAction(new SoundAction());
                    AlarmListController.this.view.setModel(AlarmListController.this.model);
                    LOG.info("Alarm List controller and view are initialized.", new Object[0]);
                    break;
                }
                case BRING2FRONT: {
                    AlarmListController.this.bringGuiToFront();
                    break;
                }
                case EXIT: {
                    AlarmListController.this.exit();
                    break;
                }
                case UPDATE_TABLE: {
                    AlarmListController.this.updateView();
                    break;
                }
                default: {
                    LOG.severe("Unhandled GUI action: " + this.action.name(), new Object[0]);
                }
            }
        }
    }

    class Beeper {
        private boolean soundOn = false;
        private boolean preventBeep = false;
        private Timer delayedStartTimer;
        private Timer preventBeepTimer;

        Beeper() {
            this.delayedStartTimer = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LOG.fine("Start timer has expired and there should be a beeeeeep.", new Object[0]);
                    Beeper.this.delayedStartTimer.stop();
                    Toolkit.getDefaultToolkit().beep();
                }
            });
            this.preventBeepTimer = new Timer(10000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Beeper.this.preventBeepTimer.stop();
                    Beeper.this.preventBeep = false;
                }
            });
        }

        void newAlarm(RecordContent recordContent) {
            EventType eventType;
            Severity severity;
            LOG.fine("A new alarm has been raised, let's check if it qualifies for a beeeeeep.", new Object[0]);
            if (this.soundOn && !this.preventBeep && (severity = (Severity)((Object)recordContent.get((Object)LogPart.PERCEIVED_SEVERITY))) == Severity.CRITICAL && ((eventType = (EventType)((Object)recordContent.get((Object)LogPart.EVENT_TYPE))) == EventType.COMMUNICATIONS_ALARM || eventType == EventType.ENVIRONMENTAL_ALARM)) {
                LOG.fine("Yezzz it is qualified for a beeeeeep.", new Object[0]);
                this.preventBeep = true;
                this.preventBeepTimer.start();
                this.delayedStartTimer.start();
            }
        }

        void setBeepState(boolean soundOn) {
            if (!soundOn) {
                this.delayedStartTimer.stop();
                this.preventBeepTimer.stop();
            }
            this.soundOn = soundOn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        BRING2FRONT,
        CREATE_VIEW,
        EXIT,
        UPDATE_TABLE;

    }
}

