/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import se.ericsson.cello.em.fm.common.model.ifc.FmTableModel;
import se.ericsson.cello.em.fm.common.model.impl.EventType;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonEditableSortedTableModel
extends AbstractTableModel
implements FmTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<LogPart> columns = new ArrayList();
    private List<RecordContent> completeData = new ArrayList<RecordContent>();
    private List<RecordContent> visibleData = new ArrayList<RecordContent>();
    private EnumSet<EventType> filter = EnumSet.allOf(EventType.class);

    public NonEditableSortedTableModel(FmType logToolType) {
        TreeSet<LogPart> tmpColumns = LogPart.getColumns(logToolType);
        for (LogPart logPart : tmpColumns) {
            this.columns.add(logPart);
        }
    }

    public void addRow(RecordContent record) {
        this.completeData.add(record);
        if (this.filter.contains(record.get((Object)LogPart.EVENT_TYPE))) {
            this.visibleData.add(record);
        }
        this.fireTableRowsInserted(this.completeData.size() - 1, this.completeData.size());
    }

    public void addRowNoUpdate(RecordContent record) {
        this.completeData.add(record);
        if (this.filter.contains(record.get((Object)LogPart.EVENT_TYPE))) {
            this.visibleData.add(record);
        }
    }

    @Override
    public RecordContent getRow(int rowNumber) {
        return this.visibleData.get(rowNumber);
    }

    public RecordContent getNonFilteredRow(int rowNumber) {
        return this.completeData.get(rowNumber);
    }

    public void removeRow(int rowNumber) {
        this.completeData.remove(rowNumber);
        this.filter();
        this.fireTableRowsDeleted(rowNumber, rowNumber);
    }

    public void removeAllRows() {
        this.completeData.clear();
        this.visibleData.clear();
        int nrOfRows = this.getNonFilteredRowCount();
        if (nrOfRows > 0) {
            this.fireTableRowsDeleted(0, nrOfRows - 1);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        RecordContent rowData = this.visibleData.get(row);
        return rowData.get((Object)this.columns.get(col));
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public String getColumnName(int col) {
        return this.columns.get((int)col).COLUMN_TITLE;
    }

    @Override
    public int getRowCount() {
        return this.visibleData.size();
    }

    public int getNonFilteredRowCount() {
        return this.completeData.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public void dispose() {
        this.columns = null;
        this.removeAllRows();
    }

    public List<RecordContent> getVisibleData() {
        return this.visibleData;
    }

    @Override
    public void setFilter(EnumSet<EventType> eventType) {
        this.filter.clear();
        this.filter.addAll(eventType);
        this.filter();
    }

    private void filter() {
        this.visibleData.clear();
        for (RecordContent record : this.completeData) {
            if (!this.filter.contains(record.get((Object)LogPart.EVENT_TYPE))) continue;
            this.visibleData.add(record);
        }
    }
}

