/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cipher.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.security.cipher.CipherMgr;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsChdInd;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsGetCfm;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsGetReq;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsInitiateServiceCfm;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsInitiateServiceReq;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsNotifySubscribeReq;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsSubscribeReq;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsTerminateServiceCfm;
import se.ericsson.security.cipher.proxy.IpomCsucjiTlsTerminateServiceReq;

public class CipherProxy
implements SubscriptionObserver,
SignalObserver {
    static final int CORBA_ID = 2;
    private static CipherProxy instance;
    private CipherMgr myCipherMgr = null;
    private SignalPort signalPort = PortManager.instance();
    private static OseProcess op;
    private static boolean initiated;
    private static boolean allowedSubscribe;
    private static boolean subscribed;
    private static boolean getDone;
    private static String supportedCiphers;
    private static final int MAX_NO_OF_RETRIES = 5;
    private static final String SERVICE_NAME = "IPOM_CSUCJI_TLS_SERVICE_NAME";
    private static final Class CIPHER_CHANGE_IND;
    private static final int PV_FIRST = 1;
    private static final int PV_SECOND = 1;
    private static final int PV_THIRD = 1;
    private static final int IPOM_CSUCJI_TLS_OK = 0;
    private static final int IPOM_CSUCJI_TLS_INVALID_PV = 1;
    private static final int TRACEGROUP = 5;
    private static final int RECEIVE_TIMEOUT = 15000;

    public synchronized void serviceAdded(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)"serviceAdded: IPOM_CSUCJI_TLS_SERVICE_NAME");
        if (op != null) {
            if (op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) {
                MessageLog.trace((int)5, this.getClass(), (String)"Old service exists and shall be terminated.");
                this.sendIpomCsucjiTlsTerminateServiceReq();
            }
        }
        if (initiated = this.init()) {
            MessageLog.trace((int)5, this.getClass(), (String)"init() called successfully.");
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)"init() returned false, retrying.");
            initiated = this.retryNegotiation();
            if (!initiated) {
                MessageLog.traceError(this.getClass(), (String)"Failed to initiate CSUCJI-TLS service, Cipher Configuration indications will not be received. ORB will not be restarted if Cipher Configuration changes.");
                subscribed = false;
            }
        }
        MessageLog.trace((int)5, this.getClass(), (String)(" serviceAdded(), initiated: " + initiated + "."));
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void serviceRemoved(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)" serviceRemoved: IPOM_CSUCJI_TLS_SERVICE_NAME");
        if (op != null) {
            if (op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) {
                MessageLog.trace((int)5, this.getClass(), (String)" serviceAdded came before serviceRemoved. Do nothing!");
                return;
            }
        }
        op = null;
        initiated = false;
        subscribed = false;
        MessageLog.trace((int)5, this.getClass(), (String)(" serviceRemoved(), initiated: " + initiated + ", subscribed: " + subscribed + "."));
    }

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)5, this.getClass(), (String)("signalReceived: " + inSignal.getClass()));
        if (inSignal.getClass().equals(CIPHER_CHANGE_IND)) {
            int n = ((IpomCsucjiTlsChdInd)inSignal).getClientId();
            String string = ((IpomCsucjiTlsChdInd)inSignal).getEnabledCiphers();
            MessageLog.trace((int)5, this.getClass(), (String)(" signalReceived(), initiated: " + initiated + ", subscribed: " + subscribed + ", getDone: " + getDone + ", clientID: " + n + "."));
            if (!subscribed) {
                MessageLog.info(this.getClass(), (String)"Indication signal received in unsubscribed state!");
                return;
            }
            if (!getDone) {
                MessageLog.trace((int)5, this.getClass(), (String)"Indication signal received before getReq was sent!");
                return;
            }
            if (n != 2) {
                MessageLog.traceError(this.getClass(), (String)("Indication signal received with unexpected cliend ID = " + n + ". Expected client ID is " + 2));
                return;
            }
            if (this.myCipherMgr != null) {
                this.myCipherMgr.notifyCipherChanged(string);
            } else {
                MessageLog.info(this.getClass(), (String)"Failed to notify CipherMgr about Cipher Change notifications, no subscription has been made.");
            }
        } else {
            MessageLog.info(this.getClass(), (String)("Received unknown signal: " + inSignal.getClass()));
        }
    }

    public void subscribe(CipherMgr cipherMgr) {
        this.myCipherMgr = cipherMgr;
    }

    public static CipherProxy instance() {
        if (instance == null) {
            instance = new CipherProxy();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnabledCiphers() {
        if (!initiated) {
            int n = 100;
            CipherProxy cipherProxy = this;
            synchronized (cipherProxy) {
                if (!initiated) {
                    try {
                        this.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        MessageLog.trace((int)5, this.getClass(), (String)(" getEnabledCiphers(), initiated: " + initiated + ", subscribed: " + subscribed + "."));
        if (initiated) {
            return this.sendIpomCsucjiTlsGetReq();
        }
        MessageLog.trace((int)5, this.getClass(), (String)"getEnabledCiphers(): return value empty. CSUCJI-TLS service has not been initiated. Cipher Configuration information will not be received.");
        return "";
    }

    private CipherProxy() {
        this.signalPort.addSignalObserver((SignalObserver)this, CIPHER_CHANGE_IND);
        OseNameServer.addSubscriptionObserver((String)SERVICE_NAME, (SubscriptionObserver)this);
    }

    private synchronized boolean init() {
        boolean bl = true;
        OseProcess oseProcess = null;
        oseProcess = OseNameServer.lookup((String)SERVICE_NAME);
        op = oseProcess;
        MessageLog.trace((int)5, this.getClass(), (String)("In init(), op = : " + op));
        if (oseProcess == null) {
            MessageLog.trace((int)5, this.getClass(), (String)"init(), op == null");
            bl = false;
        } else {
            bl = this.sendIpomCsucjiTlsInitiateServiceReq();
            if (bl) {
                this.sendIpomCsucjiTlsNotifySubscribeReq();
                MessageLog.trace((int)5, this.getClass(), (String)(" init(). subscribed: " + subscribed + ", supportedCiphers: " + supportedCiphers + "."));
                if (!subscribed && !supportedCiphers.equals("")) {
                    allowedSubscribe = true;
                    this.sendIpomCsucjiTlsSubscribeReq(supportedCiphers);
                    allowedSubscribe = false;
                }
            }
        }
        return bl;
    }

    private synchronized boolean retryNegotiation() {
        boolean bl = this.init();
        for (int i = 0; !bl && i < 5; ++i) {
            try {
                Thread.sleep(5000L);
                bl = this.init();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    protected boolean sendIpomCsucjiTlsInitiateServiceReq() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        Signal signal = null;
        int n3 = 2;
        IpomCsucjiTlsInitiateServiceReq ipomCsucjiTlsInitiateServiceReq = new IpomCsucjiTlsInitiateServiceReq(1, 1, 1, n3);
        try {
            signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomCsucjiTlsInitiateServiceReq, (Class)IpomCsucjiTlsInitiateServiceCfm.class, (int)15000);
        }
        catch (NullPointerException nullPointerException) {
            MessageLog.traceError(this.getClass(), (String)" sendIpomCsucjiTlsInitiateServiceReq(). No response signal in 15000seconds");
        }
        if (signal != null) {
            if (signal instanceof IpomCsucjiTlsInitiateServiceCfm) {
                MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsInitiateServiceReq() confirmed, pv = : " + ((IpomCsucjiTlsInitiateServiceCfm)signal).getPreferredPV()));
                n2 = ((IpomCsucjiTlsInitiateServiceCfm)signal).getPreferredPV();
                n = ((IpomCsucjiTlsInitiateServiceCfm)signal).getResult();
                if (n != 0) {
                    bl = false;
                    MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsInitiateServiceReq(), received result = : " + ((IpomCsucjiTlsInitiateServiceCfm)signal).getResult() + " ,preferred PV = : " + n2));
                }
            } else if (signal instanceof AttachSignal) {
                bl = false;
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomCsucjiTlsInitiateServiceReq(), receiver process terminated: IPOM_CSUCJI_TLS_SERVICE_NAME");
            } else {
                MessageLog.info(this.getClass(), (String)(" sendIpomCsucjiTlsInitiateServiceReq(), received rspSig:  " + signal.getClass()));
                bl = false;
            }
        }
        return bl;
    }

    protected void sendIpomCsucjiTlsTerminateServiceReq() {
        Signal signal = null;
        int n = 2;
        IpomCsucjiTlsTerminateServiceReq ipomCsucjiTlsTerminateServiceReq = new IpomCsucjiTlsTerminateServiceReq(n);
        try {
            signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomCsucjiTlsTerminateServiceReq, (Class)IpomCsucjiTlsTerminateServiceCfm.class, (int)15000);
        }
        catch (NullPointerException nullPointerException) {
            MessageLog.traceError(this.getClass(), (String)" IpomCsucjiTlsTerminateServiceReq(). No response signal in 15000seconds");
        }
        if (signal != null) {
            if (signal instanceof IpomCsucjiTlsTerminateServiceCfm) {
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomCsucjiTlsTerminateServiceReq(), received IpomCsucjiTlsTerminateServiceCfm");
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomCsucjiTlsTerminateServiceReq(), receiver process terminated: IPOM_CSUCJI_TLS_SERVICE_NAME");
            } else {
                MessageLog.info(this.getClass(), (String)(" sendIpomCsucjiTlsTerminateServiceReq(), received rspSig:  " + signal.getClass()));
            }
        }
        initiated = false;
        subscribed = false;
        MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsTerminateServiceReq(), initiated: " + initiated + ", subscribed: " + subscribed + "."));
    }

    public void sendIpomCsucjiTlsNotifySubscribeReq() {
        int n = 2;
        IpomCsucjiTlsNotifySubscribeReq ipomCsucjiTlsNotifySubscribeReq = new IpomCsucjiTlsNotifySubscribeReq(n);
        OseProcess oseProcess = this.signalPort.getOseProcess();
        SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)ipomCsucjiTlsNotifySubscribeReq);
        MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsNotifySubscribeReq(), receiver: " + op + ", sender: " + oseProcess + "."));
    }

    public void sendIpomCsucjiTlsSubscribeReq(String string) {
        int n = 2;
        MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsSubscribeReq(), initiated: " + initiated + ", allowedSubscribe: " + allowedSubscribe + ", subscribed: " + subscribed + "."));
        if ((initiated || allowedSubscribe) && !subscribed) {
            supportedCiphers = string;
            IpomCsucjiTlsSubscribeReq ipomCsucjiTlsSubscribeReq = new IpomCsucjiTlsSubscribeReq(n, string);
            MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsSubscribeReq(), receiver: " + op + "."));
            SignalHelper.send((OseProcess)op, (Signal)ipomCsucjiTlsSubscribeReq);
            subscribed = true;
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)" sendIpomCsucjiTlsSubscribeReq(), not initiated or already subscribed.");
        }
    }

    public String sendIpomCsucjiTlsGetReq() {
        String string = "";
        int n = 2;
        Signal signal = null;
        IpomCsucjiTlsGetReq ipomCsucjiTlsGetReq = new IpomCsucjiTlsGetReq(n);
        try {
            signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomCsucjiTlsGetReq, (Class)IpomCsucjiTlsGetCfm.class, (int)15000);
        }
        catch (NullPointerException nullPointerException) {
            MessageLog.info(this.getClass(), (String)" No signals received in 15000 seconds. Expected IpomCsucjiTlsGetCfm.");
        }
        if (signal != null) {
            if (signal instanceof IpomCsucjiTlsGetCfm) {
                n = ((IpomCsucjiTlsGetCfm)signal).getClientId();
                MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsGetReq(), received IpomCsucjiTlsGetCfm(), clientId: " + n + ", enabledCiphers: " + ((IpomCsucjiTlsGetCfm)signal).getEnabledCiphers()));
                if (n != 2) {
                    MessageLog.traceError(this.getClass(), (String)("GetCfm signal received with unexpected cliend ID = " + n + ". Expected client ID is " + 2));
                } else {
                    string = ((IpomCsucjiTlsGetCfm)signal).getEnabledCiphers();
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)5, this.getClass(), (String)" sendIpomCsucjiTlsGetReq(), receiver process terminated: IPOM_CSUCJI_TLS_SERVICE_NAME");
            } else {
                MessageLog.info(this.getClass(), (String)(" sendIpomCsucjiTlsGetReq(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)" NOT received expected IpomCsucjiTlsGetCfm() in 15000seconds");
        }
        getDone = true;
        MessageLog.trace((int)5, this.getClass(), (String)(" sendIpomCsucjiTlsGetReq(), getDone: " + getDone + "."));
        return string;
    }

    static {
        op = null;
        initiated = false;
        allowedSubscribe = false;
        subscribed = false;
        getDone = false;
        supportedCiphers = "";
        CIPHER_CHANGE_IND = IpomCsucjiTlsChdInd.class;
    }
}

