/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.RestartNode;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.ExchangeTerminalMoImpl;
import se.ericsson.cello.pdhsdhtrans.MspgExtendedMo;
import se.ericsson.cello.pdhsdhtrans.Os155SpiTtpMo;
import se.ericsson.cello.pdhsdhtrans.Os155SpiTtpMoImpl;
import se.ericsson.cello.pdhsdhtrans.phy_MspgExtended_mi;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class MspgExtendedMoImpl
extends CelloMao
implements MspgExtendedMo,
FroInfo {
    private MoData data;
    private FroProxy mspgExtendedProxy;
    private MaoFroIndicationHandler indHandler;
    private ReferenceAttribute os155SpiWorkingRef;
    private ReferenceAttribute os155SpiProtectionRef;
    private StringAttribute userLabel;
    private IntegerAttribute mspgExtendedFroId;
    private static Class[] os155SpiClassName = new Class[]{Os155SpiTtpMo.class};
    static final String OS155_SPI_WORKING_ID = "os155SpiWorkingId";
    static final String OS155_SPI_PROTECTION_ID = "os155SpiProtectionId";
    private static final String MSPGEXTENDED_FRO_ID = "mspgExtendedFroId";
    private static final boolean BIDIRECTIONAL_DEFAULT = true;
    private static final boolean REVERTIVE_DEFAULT = false;
    private static final int WAIT_TO_RESTORE_TIME_DEFAULT = 5;
    private static final int WAIT_TO_RESTORE_TIME_MINVALUE = 5;
    private static final int WAIT_TO_RESTORE_TIME_MAXVALUE = 12;
    private static final int ACTION_CLEAR = 0;
    private static final int ACTION_FORCED_SWITCH = 1;
    private static final int ACTION_MANUAL_SWITCH = 2;
    private static final int ACTION_EXERCISE = 3;
    private static final int ACTION_LOCKOUT_OF_PROTECTION = 4;
    static final String SIGNAL_NUMBER = "signalNumber";
    static final String ACTION_RESULT = "actionResult";
    private static final int PROTECTION_SWITCH = 1;
    private static TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(phy_MspgExtended_mi.class.getName()));
    private static final int MO_DATA_REVISION_5100 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"MspgExtended", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"MspgExtended", (int)128, (int)0);
        Os155SpiTtpMo os155SpiTtpMo = (Os155SpiTtpMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"os155SpiWorkingRef", (AttrList)attrList, (boolean)true, (Class[])os155SpiClassName, (String)"MspgExtended");
        Os155SpiTtpMo os155SpiTtpMo2 = (Os155SpiTtpMo)MoAttributeValidator.checkAndGetReferenceAttribute((String)"os155SpiProtectionRef", (AttrList)attrList, (boolean)true, (Class[])os155SpiClassName, (String)"MspgExtended");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"bidirectional", (AttrList)attrList, (boolean)false, (boolean)true, (String)"MspgExtended");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"revertive", (AttrList)attrList, (boolean)false, (boolean)false, (String)"MspgExtended");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"waitToRestoreTime", (AttrList)attrList, (boolean)false, (int)5, (int)5, (int)12, (String)"MspgExtended");
        MspgExtendedMoImpl.checkPhyPorts(coordinator, os155SpiTtpMo, os155SpiTtpMo2);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"MspgExtended");
        return new MspgExtendedMoImpl(managedObject, string, string2, os155SpiTtpMo, os155SpiTtpMo2, bl, bl2, n, coordinator, froProxy, maoFroIndicationHandler);
    }

    private MspgExtendedMoImpl(ManagedObject managedObject, String string, String string2, Os155SpiTtpMo os155SpiTtpMo, Os155SpiTtpMo os155SpiTtpMo2, boolean bl, boolean bl2, int n, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "MspgExtended", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.mspgExtendedProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        ((Reservable)os155SpiTtpMo).reserve((ManagedObject)this, coordinator);
        ((Reservable)os155SpiTtpMo2).reserve((ManagedObject)this, coordinator);
        int n2 = this.createMspgExtendedFro(coordinator, os155SpiTtpMo, os155SpiTtpMo2, bl, bl2, n);
        this.mspgExtendedFroId = new IntegerAttribute(MSPGEXTENDED_FRO_ID, false, n2);
        this.data.registerPersistentAttr((Attribute)this.mspgExtendedFroId);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.os155SpiWorkingRef = new ReferenceAttribute(OS155_SPI_WORKING_ID, false, (ManagedObject)os155SpiTtpMo);
        this.data.registerPersistentAttr((Attribute)this.os155SpiWorkingRef);
        this.os155SpiProtectionRef = new ReferenceAttribute(OS155_SPI_PROTECTION_ID, false, (ManagedObject)os155SpiTtpMo2);
        this.data.registerPersistentAttr((Attribute)this.os155SpiProtectionRef);
        this.data.setRevision(5100);
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.mspgExtendedFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public MspgExtendedMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.mspgExtendedProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        if (this.data.getRevision() == 5100) {
            this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
            this.mspgExtendedFroId = (IntegerAttribute)moData.getAttribute(MSPGEXTENDED_FRO_ID);
            this.os155SpiWorkingRef = (ReferenceAttribute)moData.getAttribute(OS155_SPI_WORKING_ID);
            this.os155SpiProtectionRef = (ReferenceAttribute)moData.getAttribute(OS155_SPI_PROTECTION_ID);
            RestartNode.restartIfNull((Object)this.userLabel, (String)"Recovered attribute is null: userLabel");
            RestartNode.restartIfNull((Object)this.mspgExtendedFroId, (String)"Recovered attribute is null: mspgExtendedFroId");
            RestartNode.restartIfNull((Object)this.os155SpiWorkingRef, (String)"Recovered attribute is null: os155SpiWorkingRef");
            RestartNode.restartIfNull((Object)this.os155SpiProtectionRef, (String)"Recovered attribute is null: os155SpiProtectionRef");
        } else {
            RestartNode.restartIfNull(null, (String)("Wrong Mo data revision for MspgExtended  Revision = " + this.data.getRevision()));
        }
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(MSPGEXTENDED_FRO_ID)).getValue(null));
    }

    private int createMspgExtendedFro(Coordinator coordinator, Os155SpiTtpMo os155SpiTtpMo, Os155SpiTtpMo os155SpiTtpMo2, boolean bl, boolean bl2, int n) throws MoAccessException {
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("os155SpiWorkingRef", os155SpiTtpMo.getFroId(coordinator)));
        arrayList.add(new SignedIntParameter("os155SpiProtectionRef", os155SpiTtpMo2.getFroId(coordinator)));
        arrayList.add(new SignedIntParameter("bidirectional", bl));
        arrayList.add(new SignedIntParameter("revertive", bl2));
        arrayList.add(new SignedIntParameter("waitToRestoreTime", n));
        FroData froData = this.mspgExtendedProxy.create(coordinator, arrayList);
        return froData.getFroId();
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((Reservable)this.os155SpiWorkingRef.getValue(coordinator)).release((ManagedObject)this, coordinator);
        ((Reservable)this.os155SpiProtectionRef.getValue(coordinator)).release((ManagedObject)this, coordinator);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.mspgExtendedProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(MSPGEXTENDED_FRO_ID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("bidirectional")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("bidirectional");
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("revertive")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("revertive");
                objectArray[i] = signedIntParameter.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("waitToRestoreTime")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("waitToRestoreTime");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("os155SpiWorkingRef")) {
                objectArray[i] = this.os155SpiWorkingRef.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("os155SpiProtectionRef")) {
                objectArray[i] = this.os155SpiProtectionRef.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("selectedPort")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("selectedPort");
                objectArray[i] = this.getMoForSelectedPortFroId(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "MspgExtended", "selectedPort");
            }
            if (stringArray[i].equalsIgnoreCase("selectedBoard")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("selectedBoard");
                objectArray[i] = this.getMoForSelectedBoardFroId(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "MspgExtended", "selectedBoard");
            }
            if (stringArray[i].equalsIgnoreCase("protectionStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("protectionStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("opBidirectionalMode")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("bidirectional");
                boolean bl = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                objectArray[i] = bl;
                Os155SpiTtpMoImpl os155SpiTtpMoImpl = (Os155SpiTtpMoImpl)this.getOs155SpiWorkingRef(coordinator);
                if (!bl || os155SpiTtpMoImpl.getStandardMode(coordinator) != 0) continue;
                signedIntParameter = (SignedIntParameter)map.get("opBidirectionalMode");
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "MspgExtended");
        }
        return objectArray;
    }

    public ManagedObject getMoForSelectedPortFroId(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Os155SpiTtpMo os155SpiTtpMo = null;
        Os155SpiTtpMo os155SpiTtpMo2 = (Os155SpiTtpMo)this.getAttribute("os155SpiWorkingRef", coordinator);
        Os155SpiTtpMo os155SpiTtpMo3 = (Os155SpiTtpMo)this.getAttribute("os155SpiProtectionRef", coordinator);
        if (n == os155SpiTtpMo2.getFroId(coordinator)) {
            os155SpiTtpMo = os155SpiTtpMo2;
        } else if (n == os155SpiTtpMo3.getFroId(coordinator)) {
            os155SpiTtpMo = os155SpiTtpMo3;
        }
        return os155SpiTtpMo;
    }

    private ManagedObject getMoForSelectedBoardFroId(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Os155SpiTtpMoImpl os155SpiTtpMoImpl = (Os155SpiTtpMoImpl)this.getAttribute("os155SpiWorkingRef", coordinator);
        Os155SpiTtpMoImpl os155SpiTtpMoImpl2 = (Os155SpiTtpMoImpl)this.getAttribute("os155SpiProtectionRef", coordinator);
        ManagedObject managedObject = os155SpiTtpMoImpl.getParent();
        ManagedObject managedObject2 = os155SpiTtpMoImpl2.getParent();
        int n2 = ((ExchangeTerminalMoImpl)managedObject).getFroId(coordinator);
        int n3 = ((ExchangeTerminalMoImpl)managedObject2).getFroId(coordinator);
        ManagedObject managedObject3 = null;
        if (n == n2) {
            managedObject3 = managedObject;
        } else if (n == n3) {
            managedObject3 = managedObject2;
        }
        return managedObject3;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Integer n = null;
        Boolean bl = null;
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "MspgExtended");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"MspgExtended", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("waitToRestoreTime")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("waitToRestoreTime", "MspgExtended");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"waitToRestoreTime", (int)n, (int)5, (int)12, (String)"MspgExtended");
                arrayList.add(new SignedIntParameter("waitToRestoreTime", n));
                this.sendNotification("waitToRestoreTime", n, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("bidirectional")) {
                if (!(objectArray[i] instanceof Boolean)) {
                    throw new WrongAttributeTypeException("bidirectional", "MspgExtended");
                }
                bl = (Boolean)objectArray[i];
                arrayList.add(new SignedIntParameter("bidirectional", bl));
                this.sendNotification("bidirectional", bl, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("revertive")) {
                if (!(objectArray[i] instanceof Boolean)) {
                    throw new WrongAttributeTypeException("revertive", "MspgExtended");
                }
                bl = (Boolean)objectArray[i];
                arrayList.add(new SignedIntParameter("revertive", bl));
                this.sendNotification("revertive", bl, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "MspgExtended");
        }
        if (arrayList.size() > 0) {
            this.mspgExtendedProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public int actionClear(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Map map = this.mspgExtendedProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 0, null);
        SignedIntParameter signedIntParameter = (SignedIntParameter)map.get(ACTION_RESULT);
        return signedIntParameter.getValue();
    }

    public int actionExercise(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Map map = this.mspgExtendedProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 3, null);
        SignedIntParameter signedIntParameter = (SignedIntParameter)map.get(ACTION_RESULT);
        return signedIntParameter.getValue();
    }

    public int actionLockoutOfProtection(Coordinator coordinator) throws MoAccessException {
        return this.actionLockOutOfProtection(coordinator);
    }

    public int actionLockOutOfProtection(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Map map = this.mspgExtendedProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 4, null);
        SignedIntParameter signedIntParameter = (SignedIntParameter)map.get(ACTION_RESULT);
        return signedIntParameter.getValue();
    }

    public int actionForcedSwitch(int n, Coordinator coordinator) throws MoAccessException {
        return this.actionForcedSwitch(new Integer(n), coordinator);
    }

    public int actionForcedSwitch(Integer n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException(SIGNAL_NUMBER, "MspgExtended");
        }
        arrayList.add(new SignedIntParameter(SIGNAL_NUMBER, n));
        Map map = this.mspgExtendedProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 1, arrayList);
        SignedIntParameter signedIntParameter = (SignedIntParameter)map.get(ACTION_RESULT);
        return signedIntParameter.getValue();
    }

    public int actionManualSwitch(int n, Coordinator coordinator) throws MoAccessException {
        return this.actionManualSwitch(new Integer(n), coordinator);
    }

    public int actionManualSwitch(Integer n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException(SIGNAL_NUMBER, "MspgExtended");
        }
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter(SIGNAL_NUMBER, n));
        Map map = this.mspgExtendedProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 2, arrayList);
        SignedIntParameter signedIntParameter = (SignedIntParameter)map.get(ACTION_RESULT);
        return signedIntParameter.getValue();
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.mspgExtendedProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public String getType() {
        return "MspgExtended";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getMspgExtendedId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("MspgExtendedId", coordinator);
    }

    public int getWaitToRestoreTime(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("waitToRestoreTime", coordinator);
    }

    public void setWaitToRestoreTime(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("waitToRestoreTime", new Integer(n), coordinator);
    }

    public boolean getBidirectional(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("bidirectional", coordinator);
    }

    public void setBidirectional(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("bidirectional", bl, coordinator);
    }

    public boolean getRevertive(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("revertive", coordinator);
    }

    public void setRevertive(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("revertive", bl, coordinator);
    }

    public ManagedObject getOs155SpiProtectionRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("os155SpiProtectionRef", coordinator);
    }

    public ManagedObject getOs155SpiWorkingRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("os155SpiWorkingRef", coordinator);
    }

    public ManagedObject getSelectedPort(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("selectedPort", coordinator);
    }

    public ManagedObject getSelectedBoard(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("selectedBoard", coordinator);
    }

    public int getProtectionStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("protectionStatus", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public boolean getOpBidirectionalMode(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("opBidirectionalMode", coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    static void checkPhyPorts(Coordinator coordinator, Os155SpiTtpMo os155SpiTtpMo, Os155SpiTtpMo os155SpiTtpMo2) throws MoAccessException {
        if (os155SpiTtpMo == os155SpiTtpMo2) {
            throw new ValueOutOfRangeException("Same physical path termination instance is being used", "MspgExtended");
        }
        if (os155SpiTtpMo.getStandardMode(coordinator) != os155SpiTtpMo2.getStandardMode(coordinator)) {
            throw new ValueOutOfRangeException("StandardMode for Os155SpiWorking and os155SpiProtection  not configured equal", "MspgExtended");
        }
        if (os155SpiTtpMo2.getMuxMode(coordinator) != 0) {
            throw new ValueOutOfRangeException("Os155SpiStandby, muxMode not set to standBy ", "MspgExtended");
        }
        if (os155SpiTtpMo.getMuxMode(coordinator) == 0) {
            throw new ValueOutOfRangeException("Os155SpiWorking, muxMode set to standBy ", "MspgExtended");
        }
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        if (maoFroGenericEventInd instanceof MaoFroGenericEventInd) {
            MaoFroGenericEventInd maoFroGenericEventInd2 = maoFroGenericEventInd;
            if (maoFroGenericEventInd2.getSpecificEvent() == 1) {
                try {
                    Map map = maoFroGenericEventInd2.getParameters(TagNameDictionaries.getDefault());
                    AdditionalInfo[] additionalInfoArray = null;
                    int n = 0;
                    if (map.containsKey("additionalInfoArray")) {
                        ArrayParameter arrayParameter = (ArrayParameter)map.get("additionalInfoArray");
                        additionalInfoArray = new AdditionalInfo[arrayParameter.size()];
                        for (int i = 0; i < arrayParameter.size(); ++i) {
                            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
                            String string = ((StringParameter)structParameter.get("additionalInfoName")).getValue();
                            String string2 = ((StringParameter)structParameter.get("additionalInfoValue")).getValue();
                            additionalInfoArray[i + n] = new AdditionalInfo(string, string2);
                        }
                    } else {
                        additionalInfoArray = new AdditionalInfo[]{null};
                    }
                    AlarmManager.getReporter().reportEvent(24, (ManagedObject)this, "", "", additionalInfoArray);
                }
                catch (MoAccessException moAccessException) {
                    MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
                }
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown event type sent to MspgExtended");
            }
        } else {
            MessageLog.traceError(this.getClass(), (String)"Unknown event signal sent to MspgExtended");
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("opBidirectionalMode");
            if (signedIntParameter != null) {
                String[] stringArray = new String[]{"opBidirectionalMode"};
                Object[] objectArray = new Object[1];
                Boolean bl = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                objectArray[0] = bl;
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"parameterChanged(), attribute not in property file");
        }
    }
}

