/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import java.util.Arrays;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.InvalidObservationClassException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.NoSuchIdException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.NumberOfMonitorsExceededException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortal;
import se.ericsson.cello.pms.generic.ProcessingErrorException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmCounterRegistrationItem;
import se.ericsson.crbs.cat.pmcommon.PmLists;
import se.ericsson.crbs.cat.pmpms.PmStatPredefinedScannerItem;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounter;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounterRegistration;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmMoClassCounterType;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmPredefinedScannerType;

public class PmStateListenerImpl
extends PmBase
implements PmStateListener,
PmCounterRegistration {
    private PmsPortal m_pmsPortal;
    private BasicScannerFactory m_scannerFactory;
    private Callback m_callback;
    private PmThreadSwitcherI m_threadSwitcher;
    private PmLists.PmCounterRegistrationItemList m_counterRegistrationItems;
    private PmLists.PmStatPredefinedScannerItemList m_predefinedScannerItems;

    public PmStateListenerImpl(Callback callback, PmsPortal pmsPortal, BasicScannerFactory scannerFactory, PmThreadSwitcherI threadSwitcher) {
        this.info("PmStateListener created");
        this.m_pmsPortal = pmsPortal;
        this.m_scannerFactory = scannerFactory;
        this.m_callback = callback;
        this.m_threadSwitcher = threadSwitcher;
        this.m_counterRegistrationItems = new PmLists.PmCounterRegistrationItemList();
        this.m_predefinedScannerItems = new PmLists.PmStatPredefinedScannerItemList();
        this.m_callback.stateListener_mopplet_startEvent();
    }

    public synchronized void init() {
        this.enter("init");
        this.general("Processing counter registrations");
        for (int i = 0; i < this.m_counterRegistrationItems.size(); ++i) {
            PmCounterRegistrationItem counterRegistrationItem = this.m_counterRegistrationItems.get(i);
            String moClassName = counterRegistrationItem.moClassName;
            PmCounter[] pmCounters = counterRegistrationItem.pmCounters;
            String[] counterNames = new String[pmCounters.length];
            int[] counterMultiplicities = new int[pmCounters.length];
            for (int j = 0; j < counterNames.length; ++j) {
                counterNames[j] = pmCounters[j].getCounterName();
                counterMultiplicities[j] = pmCounters[j].getMultiplicity();
            }
            this.m_pmsPortal.registerCounterTypes(moClassName, counterNames, counterMultiplicities, this.m_scannerFactory);
        }
        this.info("PmsiAdaptor registered counters for " + this.m_counterRegistrationItems.size() + " MO classes to PMS");
    }

    public void start() {
        this.enter("start");
        RegistrationCompleteRunnable registrationCompleteRunnable = new RegistrationCompleteRunnable();
        this.m_threadSwitcher.executeInMainThread(registrationCompleteRunnable);
    }

    private static void appendKeyValue(StringBuffer buffer, String key, String value) {
        int length;
        if (value == null) {
            length = 0;
            value = "<NULL>";
        } else {
            length = value.length();
        }
        buffer.append("\n");
        buffer.append(key);
        buffer.append(": (");
        buffer.append(length);
        buffer.append(")'");
        buffer.append(value);
        buffer.append("'");
    }

    private static void appendKeyValue(StringBuffer buffer, String key, long value) {
        buffer.append("\n");
        buffer.append(key);
        buffer.append(": ");
        buffer.append(value);
    }

    public boolean registerCounters(PmMoClassCounterType[] counterTypes) {
        this.enter("registerCounters");
        this.debug("No pre-defined Scanner");
        return this.registerCounters(null, counterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerCounters(PmPredefinedScannerType predefScannerType, PmMoClassCounterType[] counterTypes) {
        this.enter("registerCounters");
        boolean validCounterTypes = true;
        boolean validScannerType = true;
        boolean countersIncludedInScannerExists = false;
        block5: for (int i = 0; i < counterTypes.length; ++i) {
            PmMoClassCounterType pmCounterType = counterTypes[i];
            String moClassName = pmCounterType.getMoClassName();
            PmCounter[] pmCounters = pmCounterType.getPmCounters();
            if (moClassName.equals("")) {
                this.error("Empty moClassName name.");
                validCounterTypes = false;
                break;
            }
            for (int j = 0; j < pmCounters.length; ++j) {
                PmCounter pmCounter = pmCounters[j];
                String pmCounterName = pmCounter.getCounterName();
                int counterMultiplicity = pmCounter.getMultiplicity();
                boolean isIncludedInPredefinedScanner = pmCounter.isIncludedInPredefinedScanner();
                if (pmCounterName.equals("")) {
                    this.error("Found empty counter name for moClassName (" + moClassName + ").");
                    validCounterTypes = false;
                    continue block5;
                }
                if (counterMultiplicity < 1 || counterMultiplicity > 256) {
                    this.error("Found invalid counter multiplicity (" + counterMultiplicity + ") for pmCounterName (" + pmCounterName + "), moClassName (" + moClassName + ")." + " Minimum is 1 and maximum is " + 256);
                    validCounterTypes = false;
                }
                if (!isIncludedInPredefinedScanner) continue;
                countersIncludedInScannerExists = true;
            }
        }
        if (countersIncludedInScannerExists) {
            if (null == predefScannerType || null == predefScannerType.getScannerName() || predefScannerType.getScannerName().equals("")) {
                this.error("Counters included in a pre-defined Scanner exist, but no Scanner is supplied!");
                validScannerType = false;
            }
        } else if (null != predefScannerType && null != predefScannerType.getScannerName() && !predefScannerType.getScannerName().equals("")) {
            this.error("Pre-defined Scanner " + predefScannerType.getScannerName() + " supplied, but it contains no counters!");
            validScannerType = false;
        }
        boolean countersRegistered = false;
        if (validCounterTypes && validScannerType) {
            StoreCounterTypesRunnable storeCounterTypesRunnable = new StoreCounterTypesRunnable(counterTypes, predefScannerType);
            this.m_threadSwitcher.executeInMainThread(storeCounterTypesRunnable);
            StoreCounterTypesRunnable storeCounterTypesRunnable2 = storeCounterTypesRunnable;
            synchronized (storeCounterTypesRunnable2) {
                long waitTime = 3000L;
                long endTime = System.currentTimeMillis() + waitTime;
                while (!storeCounterTypesRunnable.hasStoredCounters()) {
                    try {
                        long timeLeft = endTime - System.currentTimeMillis();
                        if (waitTime < timeLeft || timeLeft <= 0L) break;
                        storeCounterTypesRunnable.wait(timeLeft);
                    }
                    catch (InterruptedException e) {}
                }
                if (storeCounterTypesRunnable.hasStoredCounters()) {
                    countersRegistered = true;
                } else {
                    StringBuffer moClasses = new StringBuffer();
                    for (int i = 0; i < counterTypes.length; ++i) {
                        PmMoClassCounterType pmCounterType = counterTypes[i];
                        String moClassName = pmCounterType.getMoClassName();
                        moClasses.append(" " + moClassName);
                    }
                    this.error("PmsiAdaptor failed to store counter registrations, PM counters will not be reported for MO class(es):" + moClasses.toString());
                }
            }
        }
        return countersRegistered;
    }

    public void publishService() {
        this.enter("publishService");
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        if (serviceRepository == null) {
            this.error("ServiceRepository is NULL");
        }
        serviceRepository.addService((Object)this, PmCounterRegistration.class, null);
    }

    private void updateScannerInPms(PmStatPredefinedScannerItem predefScanner) {
        boolean createNewScanner = true;
        String measurementName = predefScanner.getMeasurementName();
        this.debug("Looking for pre-defined Scanner " + measurementName + " in PMS");
        MonitoringTaskInfo[] monitoringList = this.m_pmsPortal.listPerformanceMonitorings();
        if (monitoringList == null || monitoringList.length == 0) {
            this.debug("No pre-defined Scanner exists!");
        } else {
            for (int i = 0; i < monitoringList.length; ++i) {
                if (monitoringList[i] == null || !measurementName.equals(monitoringList[i].getName())) continue;
                this.debug("Pre-defined Scanner " + measurementName + " exists, check if it has been altered");
                createNewScanner = false;
                if (!this.isPredefScannerAltered(monitoringList[i], predefScanner)) break;
                this.general("Pre-defined Scanner " + measurementName + " has been altered, delete it!");
                createNewScanner = true;
                this.deletePerformanceMonitoring(monitoringList[i]);
                break;
            }
        }
        if (createNewScanner) {
            this.general("Create pre-defined Scanner " + measurementName);
            this.createPerformanceMonitoring(predefScanner);
        }
    }

    private void createPerformanceMonitoring(PmStatPredefinedScannerItem predefScanner) {
        try {
            this.m_pmsPortal.createPerformanceMonitoring(predefScanner.getObservationClasses(), predefScanner.getObservationObjects(), predefScanner.getGranularityPeriod().inSeconds(), predefScanner.getMeasurementName(), predefScanner.getState());
        }
        catch (InvalidObservationClassException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to InvalidObservationClassException.");
            ObservationClass[] invalidObservationClasses = e.getObservationClassList();
            if (invalidObservationClasses.length > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Faulty ObservationClasses.");
                for (int i = 0; i < invalidObservationClasses.length; ++i) {
                    ObservationClass invalidObservationClass = invalidObservationClasses[i];
                    String moClassName = invalidObservationClass.object_class_name;
                    String[] counters = invalidObservationClass.class_attribute_list;
                    PmStateListenerImpl.appendKeyValue(buffer, "moClassName", moClassName);
                    for (int j = 0; j < counters.length; ++j) {
                        String counterName = counters[j];
                        PmStateListenerImpl.appendKeyValue(buffer, "counterName", counterName);
                    }
                }
                this.info(buffer.toString());
            }
        }
        catch (InvalidObservationObjectListException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to InvalidObservationObjectListException.");
        }
        catch (InvalidGranularityPeriodException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to InvalidGranularityPeriodException.");
        }
        catch (NumberOfCountersExceededException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to NumberOfCountersExceededException.");
        }
        catch (NumberOfMonitorsExceededException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to NumberOfMonitorsExceededException.");
        }
        catch (OverloadException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to OverloadException.");
        }
        catch (GranularityPeriodNotSupportedException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to GranularityPeriodNotSupportedException.");
        }
        catch (GranularityAndAttributeActivationException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to GranularityAndAttributeActivationException.");
        }
        catch (ParameterNotAcceptedException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to ParameterNotAcceptedException.");
        }
        catch (ProcessingErrorException e) {
            this.error("Failed to create pre-defined Scanner " + predefScanner.getMeasurementName() + " due to ProcessingErrorException.");
        }
    }

    private boolean isPredefScannerAltered(MonitoringTaskInfo monitoringTask, PmStatPredefinedScannerItem predefScanner) {
        String measurementName = predefScanner.getMeasurementName();
        boolean isAltered = false;
        if (this.compareScannerInfo(monitoringTask, predefScanner)) {
            this.debug("Pre-defined Scanner " + measurementName + " is unaltered");
            if (monitoringTask.getState() == PerformanceMonitoringState.SUSPENDED) {
                this.info("Pre-defined Scanner " + measurementName + " is suspended in current cv!");
                isAltered = true;
            }
        } else {
            this.debug("Pre-defined Scanner " + measurementName + " is altered");
            isAltered = true;
        }
        return isAltered;
    }

    private boolean compareScannerInfo(MonitoringTaskInfo monitoringTask, PmStatPredefinedScannerItem predefScanner) {
        boolean areEqual = true;
        this.debug(predefScanner.toString());
        this.debugMonitoringTaskInfo(monitoringTask);
        ObservationClass[] obsclassesExisting = monitoringTask.getObservationClassList();
        ObservationClass[] obsclassesRegistered = predefScanner.getObservationClasses();
        if (obsclassesExisting.length != obsclassesRegistered.length) {
            this.debug("Pre-defined Scanner differs, MO-class length info has been altered");
            areEqual = false;
        } else {
            for (int i = 0; i < obsclassesExisting.length; ++i) {
                if (obsclassesExisting[i].object_class_name.equals(obsclassesRegistered[i].object_class_name)) {
                    if (Arrays.equals(obsclassesExisting[i].class_attribute_list, obsclassesRegistered[i].class_attribute_list)) continue;
                    this.debug("Pre-defined Scanner differs, counter info has been altered");
                    areEqual = false;
                    break;
                }
                this.debug("Pre-defined Scanner differs, MO-class info has been altered");
                areEqual = false;
                break;
            }
        }
        if (predefScanner.getGranularityPeriod().inSeconds() != monitoringTask.getGranularityPeriod().inSeconds()) {
            this.error("Granularity Period for Scanner " + predefScanner.getMeasurementName() + " has been altered!");
            areEqual = false;
        }
        return areEqual;
    }

    private void debugMonitoringTaskInfo(MonitoringTaskInfo monitoringTask) {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append("\nExisting Pre-defined Scanner definition:");
        buffer.append("\n  MeasurementName = ");
        buffer.append(monitoringTask.getName());
        buffer.append("\n  Observation classes =");
        ObservationClass[] obsclasses = monitoringTask.getObservationClassList();
        for (int i = 0; i < obsclasses.length; ++i) {
            buffer.append("\n    ");
            buffer.append(obsclasses[i].object_class_name);
            buffer.append(" (");
            for (int j = 0; j < obsclasses[i].class_attribute_list.length; ++j) {
                buffer.append(obsclasses[i].class_attribute_list[j]);
                if (j >= obsclasses[i].class_attribute_list.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(')');
        }
        buffer.append("\n  Granularityperiod = ");
        buffer.append(monitoringTask.getGranularityPeriod().inSeconds());
        PerformanceMonitoringState state = monitoringTask.getState();
        if (state != null) {
            String stateStr = state.equals(PerformanceMonitoringState.ACTIVE) ? "ACTIVE" : "SUSPENDED";
            buffer.append("\n  State = ");
            buffer.append(stateStr);
        }
        this.debug(buffer.toString());
    }

    private void deletePerformanceMonitoring(MonitoringTaskInfo monitoringTask) {
        try {
            this.m_pmsPortal.deletePerformanceMonitoring(monitoringTask.getId().intValue());
        }
        catch (NoSuchIdException ef) {
            this.error("Failed to delete performance monitoring " + monitoringTask.getName() + " due to NoSuchIdException for id: " + ef.getScannerId());
        }
        catch (ProcessingErrorException ef) {
            this.error("Failed to delete performance monitoring " + monitoringTask.getName() + " due to ProcessingErrorException.");
        }
        catch (InvalidPerformanceMonitoringTypeException ef) {
            this.error("Failed to delete performance monitoring " + monitoringTask.getName() + " due to InvalidPerformanceMonitoringTypeException.");
        }
    }

    public class StoreCounterTypesRunnable
    implements Runnable {
        private PmStatPredefinedScannerItem m_innerPredefinedScannerItem;
        private PmLists.PmCounterRegistrationItemList m_innerCounterTypes = new PmLists.PmCounterRegistrationItemList();
        private boolean m_hasStoredCounters = false;

        public StoreCounterTypesRunnable(PmMoClassCounterType[] counterTypes, PmPredefinedScannerType predefScannerType) {
            this.m_innerPredefinedScannerItem = new PmStatPredefinedScannerItem();
            for (int i = 0; i < counterTypes.length; ++i) {
                String moClassName = counterTypes[i].getMoClassName();
                PmCounter[] pmCounters = counterTypes[i].getPmCounters();
                String innerMoClassName = moClassName;
                PmCounter[] innerPmCounters = new PmCounter[pmCounters.length];
                PmLists.StringList countersInPredefScanner = new PmLists.StringList();
                for (int j = 0; j < innerPmCounters.length; ++j) {
                    PmCounter innerPmCounter;
                    PmCounter pmCounter = pmCounters[j];
                    String innerCounterName = pmCounter.getCounterName();
                    int innerCounterMultiplicity = pmCounter.getMultiplicity();
                    boolean innerIsIncludedInPredefScanner = pmCounter.isIncludedInPredefinedScanner();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Received counter definition.");
                    PmStateListenerImpl.appendKeyValue(buffer, "moClassName", innerMoClassName);
                    PmStateListenerImpl.appendKeyValue(buffer, "counterName", innerCounterName);
                    PmStateListenerImpl.appendKeyValue(buffer, "multiplicity", innerCounterMultiplicity);
                    PmStateListenerImpl.appendKeyValue(buffer, "includedInPredefinedScanner", innerIsIncludedInPredefScanner ? "true" : "false");
                    PmStateListenerImpl.this.general(buffer.toString());
                    innerPmCounters[j] = innerPmCounter = new PmCounter(innerCounterName, innerCounterMultiplicity);
                    if (!innerIsIncludedInPredefScanner) continue;
                    countersInPredefScanner.add(innerCounterName);
                }
                this.m_innerCounterTypes.add(new PmCounterRegistrationItem(innerMoClassName, innerPmCounters));
                if (0 == countersInPredefScanner.size()) continue;
                ObservationClass obsClass = new ObservationClass(innerMoClassName, countersInPredefScanner.toArray());
                this.m_innerPredefinedScannerItem.addObservationClass(obsClass);
            }
            if (null == predefScannerType || null == predefScannerType.getScannerName() || predefScannerType.getScannerName().equals("")) {
                PmStateListenerImpl.this.general("No pre-defined Scanner is supplied");
                this.m_innerPredefinedScannerItem = null;
            } else {
                this.m_innerPredefinedScannerItem.setMeasurementName("PREDEF." + predefScannerType.getScannerName() + ".STATS");
                this.m_innerPredefinedScannerItem.setState(PerformanceMonitoringState.ACTIVE);
                if (900 != predefScannerType.getGranularityPeriod()) {
                    PmStateListenerImpl.this.info("Scanner " + this.m_innerPredefinedScannerItem.getMeasurementName() + " has GP set to a value <> 15 minutes. " + "Monitoring will be created with GP set to 15 minutes!");
                }
                this.m_innerPredefinedScannerItem.setGranularityPeriod(GranularityPeriod.MINUTES_15);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PmStateListenerImpl.this.enter("StoreCounterTypesRunnable.run");
            for (int i = 0; i < this.m_innerCounterTypes.size(); ++i) {
                PmStateListenerImpl.this.m_counterRegistrationItems.add(this.m_innerCounterTypes.get(i));
            }
            if (null != this.m_innerPredefinedScannerItem) {
                PmStateListenerImpl.this.debug(this.m_innerPredefinedScannerItem.toString());
                PmStateListenerImpl.this.m_predefinedScannerItems.add(this.m_innerPredefinedScannerItem);
            }
            StoreCounterTypesRunnable storeCounterTypesRunnable = this;
            synchronized (storeCounterTypesRunnable) {
                this.m_hasStoredCounters = true;
                this.notify();
            }
        }

        public boolean hasStoredCounters() {
            return this.m_hasStoredCounters;
        }

        public PmLists.PmCounterRegistrationItemList getInnerCounterTypes() {
            return this.m_innerCounterTypes;
        }

        public PmStatPredefinedScannerItem getInnerPredefinedScannerItem() {
            return this.m_innerPredefinedScannerItem;
        }
    }

    private class RegistrationCompleteRunnable
    implements Runnable {
        private RegistrationCompleteRunnable() {
        }

        public void run() {
            PmStateListenerImpl.this.m_callback.stateListener_compareRegistrations(PmStateListenerImpl.this.m_counterRegistrationItems);
            for (int i = 0; i < PmStateListenerImpl.this.m_predefinedScannerItems.size(); ++i) {
                PmStatPredefinedScannerItem scannerItem = PmStateListenerImpl.this.m_predefinedScannerItems.get(i);
                PmStateListenerImpl.this.updateScannerInPms(scannerItem);
            }
            PmStateListenerImpl.this.m_callback.stateListener_registrationComplete();
        }
    }

    public static interface Callback {
        public void stateListener_mopplet_startEvent();

        public void stateListener_registrationComplete();

        public void stateListener_compareRegistrations(PmLists.PmCounterRegistrationItemList var1);
    }
}

