/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import java.util.Timer;
import java.util.TimerTask;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;

public class PmTimer
extends PmBase {
    private PmThreadSwitcherI m_threadSwitcher;
    private Timer m_timer;

    public PmTimer(PmThreadSwitcherI threadSwitcher) {
        this.enter("PmTimer");
        this.m_threadSwitcher = threadSwitcher;
        this.m_timer = new Timer();
    }

    public PmTimerTask schedule(int timeOutInMs, Runnable runnable) {
        this.enter("schedule");
        this.general("Created timer task with timeout: " + timeOutInMs);
        PmTimerTask timerTask = new PmTimerTask(runnable);
        this.m_timer.schedule((TimerTask)timerTask, timeOutInMs);
        this.debug("Timeout in milliseconds: " + timeOutInMs);
        return timerTask;
    }

    public void cancelTimer() {
        this.enter("cancelTimer");
        this.m_timer.cancel();
    }

    public class PmTimerTask
    extends TimerTask {
        private Runnable m_runnable;

        public PmTimerTask(Runnable runnable) {
            PmTimer.this.enter("PmTimerTask");
            this.m_runnable = runnable;
        }

        public void run() {
            PmTimer.this.enter("PmTimerTask.run");
            super.cancel();
            PmTimer.this.m_threadSwitcher.executeInMainThread(this.m_runnable);
        }
    }
}

