/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.aueframework.common.AueContextImpl;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.ResetActionListener;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.ResetXmlHandler;
import se.ericsson.crbs.omf.aue.common.xml.ResetXmlHandlerFactory;

public abstract class AbstractResetXmlExecutor
implements ResetActionListener {
    public static final String UNKNOWN = "Unknown";
    protected static final AueContext CONVERTER_CONTEXT_NOT_SET = new AueContextImpl();
    protected AueContext aueContext = CONVERTER_CONTEXT_NOT_SET;
    private static final CrbsAueException AUE_EXCEPTION_NOT_SET = new CrbsAueException("No exception received");
    protected CrbsAueException aueException = AUE_EXCEPTION_NOT_SET;
    protected final XmlHolder xmlHolder;
    private final AbstractLogger logger;

    public AbstractResetXmlExecutor(XmlHolder xmlHolder, AbstractLogger logger) {
        this.xmlHolder = xmlHolder;
        this.logger = logger;
    }

    public void parseResetXmlFile(AueContext context) throws CrbsAueException {
        this.logger.traceEnter(this.getClass(), "convert()");
        this.aueContext = context;
        this.aueException = AUE_EXCEPTION_NOT_SET;
        ResetXmlHandler handler = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            handler = ResetXmlHandlerFactory.getResetXmlHandler(this.aueContext);
            parser.setContentHandler(handler);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.xmlHolder.getContents().getBytes());
            InputSource inputSource = new InputSource(inputStream);
            handler.addMoResetAttributesCollectedListener(this);
            parser.parse(inputSource);
        }
        catch (SAXException se) {
            if (!((Object)((Object)this.aueException)).equals((Object)AUE_EXCEPTION_NOT_SET)) {
                throw this.aueException;
            }
            String msg = this.getClass() + ": Parse error: " + se.getMessage() + " when parsing file: " + this.xmlHolder.getPath();
            this.logger.traceDebug(this.getClass(), AueUtil.appendReason(msg, se));
            throw new CrbsAueException(msg, se);
        }
        catch (IOException ioe) {
            String msg = this.getClass() + ": Cannot read reset file: " + this.xmlHolder.getPath();
            this.logger.traceDebug(this.getClass(), AueUtil.appendReason(msg, ioe));
            throw new CrbsAueException(msg, ioe);
        }
        finally {
            try {
                handler.removeMoResetAttributesCollectedListener(this);
            }
            catch (Exception ignore) {}
        }
        this.aueContext = CONVERTER_CONTEXT_NOT_SET;
        this.logger.traceReturn(this.getClass(), "convert()");
    }

    public String getFromRevision() {
        return UNKNOWN;
    }

    public String getToRevision() {
        return UNKNOWN;
    }

    public abstract void moResetAttributesCollected(Map var1, String var2) throws CrbsAueException;
}

