/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.logging;

import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLoggingServiceHelper;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.logging.StdioLogger;

public final class LoggingServiceHelperImpl
extends AbstractLoggingServiceHelper {
    private static final String LOGGING_SERVICES_ARGNAME = "ELIB.LOG_SERVICES";
    private static final String LOGGING_SERVICES_CLASSNAME = "se.ericsson.crbs.omf.aue.common.logging.CppLogger";
    private AbstractLogger logger;
    private AbstractLogger btLogger;
    private boolean btLoggerCreated = false;
    private static LoggingServiceHelperImpl instance = new LoggingServiceHelperImpl();

    public static LoggingServiceHelperImpl instance() {
        return instance;
    }

    private LoggingServiceHelperImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLogger getLogger() {
        LoggingServiceHelperImpl loggingServiceHelperImpl = this;
        synchronized (loggingServiceHelperImpl) {
            if (this.logger == null) {
                String unitTestClassName = System.getProperty(LOGGING_SERVICES_ARGNAME);
                String classNameToUse = unitTestClassName == null ? LOGGING_SERVICES_CLASSNAME : unitTestClassName;
                Object result = this.getNamedClassInstanceByReflection(classNameToUse);
                this.logger = (AbstractLogger)result;
                if (this.logger instanceof StdioLogger) {
                    this.btLogger = this.logger;
                }
            }
            return this.logger;
        }
    }

    public AbstractLogger getLogger(String className) {
        return this.getLogger();
    }

    private Object getNamedClassInstanceByReflection(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException cnfx) {
            throw new IllegalArgumentException(className + " could not be instantiated. " + cnfx.getMessage());
        }
        catch (InstantiationException ix) {
            throw new IllegalArgumentException(className + " could not be instantiated. " + ix.getMessage());
        }
        catch (IllegalAccessException iax) {
            throw new IllegalArgumentException(className + " could not be instantiated. " + iax.getMessage());
        }
    }

    public void setBtLogger() {
        this.setBtLogger(true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBtLogger(boolean basicOn, boolean debugOn, boolean enterReturnOn) {
        LoggingServiceHelperImpl loggingServiceHelperImpl = this;
        synchronized (loggingServiceHelperImpl) {
            String showOutputStr = System.getProperty("show.output.for.basic.test");
            if (!this.btLoggerCreated) {
                this.btLogger = showOutputStr == null || showOutputStr.equalsIgnoreCase("true") ? (this.logger = new StdioLogger(basicOn, debugOn, enterReturnOn)) : (this.logger = new StdioLogger(false, false, false));
            }
            this.btLoggerCreated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBtLogger() {
        Class clazz = LoggingService.class;
        synchronized (clazz) {
            this.logger = null;
            this.btLoggerCreated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBtLogger() {
        Class clazz = LoggingService.class;
        synchronized (clazz) {
            this.logger = null;
            this.btLoggerCreated = true;
            this.setLogger(this.btLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBtLogger(boolean basicOn, boolean debugOn, boolean enterReturnOn) {
        Class clazz = LoggingService.class;
        synchronized (clazz) {
            this.logger = null;
            this.btLoggerCreated = false;
            if (this.btLogger instanceof StdioLogger) {
                StdioLogger stdIoLogger = (StdioLogger)this.btLogger;
                stdIoLogger.basicOn = basicOn;
                stdIoLogger.debugOn = debugOn;
                stdIoLogger.enterReturnOn = enterReturnOn;
            }
            this.setLogger(this.btLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogger(AbstractLogger aLogger) {
        LoggingServiceHelperImpl loggingServiceHelperImpl = this;
        synchronized (loggingServiceHelperImpl) {
            this.logger = aLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeningLogger(AbstractLogger listeningLogger) {
        LoggingServiceHelperImpl loggingServiceHelperImpl = this;
        synchronized (loggingServiceHelperImpl) {
            if (this.logger != null) {
                this.logger.addListeningLogger(listeningLogger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeningLogger(AbstractLogger listeningLogger) {
        LoggingServiceHelperImpl loggingServiceHelperImpl = this;
        synchronized (loggingServiceHelperImpl) {
            if (this.logger != null) {
                this.logger.removeListeningLogger(listeningLogger);
            }
        }
    }
}

