/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class Step1ResetAction {
    private static final Integer FALSE_VALUE = new Integer(0);
    private static final Integer TRUE_VALUE = new Integer(1);
    private static final Class THIS_CLASS = Step1ResetAction.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    protected final Map moAttributeMap = new HashMap();
    protected final String froTypeName;

    public Step1ResetAction(Map moAttributeMap, String moName) {
        this.moAttributeMap.putAll(moAttributeMap);
        this.froTypeName = moName;
    }

    public void reset(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "reset()");
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        String attrName = "";
        try {
            TableData tableData = tableHandler.getTableData(this.froTypeName);
            Iterator iter = this.moAttributeMap.keySet().iterator();
            while (iter.hasNext()) {
                attrName = this.checkString((String)iter.next(), "No attribute name specified in " + AueUtil.doubleQuote(this.getClass().getName()));
                String attrValue = this.checkString((String)this.moAttributeMap.get(attrName), "No attribute value specified in " + AueUtil.doubleQuote(this.getClass().getName()));
                logger.traceGeneral(THIS_CLASS, "reset: resetting attribute " + AueUtil.quote(attrName) + " in FRO " + this.froTypeName + " to " + AueUtil.quote(attrValue));
                this.updateColumnData(tableData, attrValue, attrName);
            }
        }
        catch (Exception e) {
            String errorMsg = "Could not reset attribute, " + AueUtil.doubleQuote(attrName) + ", from, " + AueUtil.doubleQuote(this.froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            throw new CrbsAueException(errorMsg, e);
        }
        logger.traceReturn(THIS_CLASS, "reset()");
    }

    private void updateColumnData(TableData tableData, String attrValue, String attrName) throws TableDataException {
        boolean attributefound = false;
        String[] attributeNames = tableData.getAttributeNames();
        for (int columnIndex = 0; columnIndex < attributeNames.length; ++columnIndex) {
            if (!attributeNames[columnIndex].equalsIgnoreCase(attrName)) continue;
            attributefound = true;
            Object[] columnDatas = tableData.getAttributeValues(attributeNames[columnIndex]);
            String momType = tableData.getMomType(attributeNames[columnIndex]);
            this.checkMomType(momType, attrValue);
            for (int rowIndex = 0; rowIndex < columnDatas.length; ++rowIndex) {
                this.setRowData(tableData, attrValue, attrName, rowIndex, momType);
            }
        }
        if (!attributefound) {
            logger.traceAbnormal(THIS_CLASS, "updateColumnData: The attribute: " + attrName + " in MO " + tableData.getFroTypeName() + " has not been reset because it was not found");
        }
    }

    private void setRowData(TableData tableData, String attrValue, String attrName, int rowIndex, String momType) throws TableDataException {
        if (momType.equalsIgnoreCase("S32") || momType.equalsIgnoreCase("U32")) {
            Integer integerValue = TRUE.equalsIgnoreCase(attrValue) ? TRUE_VALUE : (FALSE.equalsIgnoreCase(attrValue) ? FALSE_VALUE : this.getIntegerValue(tableData, attrName, attrValue));
            tableData.setAttributeValue(rowIndex, attrName, integerValue);
        } else {
            tableData.setAttributeValue(rowIndex, attrName, attrValue);
        }
    }

    private Integer getIntegerValue(TableData tableData, String attrName, String attrValue) throws TableDataException {
        Integer integerValue;
        try {
            integerValue = Integer.valueOf(attrValue);
        }
        catch (NumberFormatException nfe) {
            throw new TableDataException("Attribute " + attrName + " in MO " + tableData.getFroTypeName() + " was expected to be set to an integer value but the reset value was " + AueUtil.quote(attrValue));
        }
        return integerValue;
    }

    private String checkString(String string, String errorMsg) throws CrbsAueException {
        if (string == null) {
            throw new CrbsAueException(errorMsg);
        }
        return string;
    }

    private void checkMomType(String momType, String defaultValueStr) {
        boolean checkIsOk = true;
        if (momType.equalsIgnoreCase("S32") || momType.equalsIgnoreCase("U32")) {
            checkIsOk = this.checkIntegerMomType(momType, defaultValueStr);
        } else if (momType.equalsIgnoreCase("S64")) {
            try {
                Long.valueOf(defaultValueStr);
            }
            catch (NumberFormatException nfe) {
                logger.traceDebug(THIS_CLASS, "Specified default value is not a long. Has to be when MOM type is: S64. Default value was: " + AueUtil.doubleQuote(defaultValueStr));
                checkIsOk = false;
            }
        } else if (!momType.equalsIgnoreCase("STRING")) {
            logger.traceDebug(THIS_CLASS, "Incorrect MOM type specified: " + AueUtil.doubleQuote(momType));
            checkIsOk = false;
        }
        if (checkIsOk) {
            logger.traceDebug(THIS_CLASS, "checkMomType(" + momType + ", " + defaultValueStr + ") - is OK");
        }
    }

    private boolean checkIntegerMomType(String momType, String defaultValueStr) {
        boolean checkIsOk = true;
        try {
            Integer.valueOf(defaultValueStr);
        }
        catch (NumberFormatException nfe) {
            logger.traceDebug(THIS_CLASS, "Specified default value is not an integer. Has to be when MOM type is: " + AueUtil.doubleQuote(momType) + ". Default value was: " + AueUtil.doubleQuote(defaultValueStr));
            checkIsOk = false;
        }
        return checkIsOk;
    }
}

