/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class AbstractDeleteMoAction
extends AbstractConversionAction {
    private final Class loggerClass;
    private final AbstractLogger logger;
    private final boolean deleteEntireMoType;
    protected TableData tableData = null;

    public AbstractDeleteMoAction(boolean deleteEntireMoType, Class loggerClass) {
        this.deleteEntireMoType = deleteEntireMoType;
        this.loggerClass = loggerClass;
        this.logger = LoggingService.getLogger(loggerClass.getName());
    }

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        this.logger.traceEnter(this.loggerClass, "convert()");
        String froTypeToDelete = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.tableData = tableHandler.getTableData(froTypeToDelete);
            this.deleteMoType(this.tableData, tableHandler, froTypeToDelete);
            tableHandler.checkAndDropIfNotUpdated(true, this.tableData);
            if (this.deleteEntireMoType) {
                this.tableData.deleteMoType();
            }
        }
        catch (CrbsAueException auee) {
            throw auee;
        }
        catch (Exception e) {
            String errorMsg = "Failed to read \"froTypeName\" from \"fro_versions\".";
            this.logger.traceDebug(this.loggerClass, AueUtil.appendReason("Failed to read \"froTypeName\" from \"fro_versions\".", e));
            throw new CrbsAueException(AueUtil.appendReason("Failed to read \"froTypeName\" from \"fro_versions\".", e), e);
        }
        this.logger.traceReturn(this.loggerClass, "convert()");
    }

    private void deleteMoType(TableData localTableData, TableHandler tableHandler, String froTypeToDelete) throws CrbsAueException, TableDataException {
        if (tableHandler != null && localTableData.isNotEmpty()) {
            Object[] columnDatas;
            localTableData.clearAllData();
            try {
                columnDatas = localTableData.getAttributeValues("ldn");
            }
            catch (TableDataException tde) {
                throw new CrbsAueException(tde.getMessage());
            }
            for (int i = 0; i < columnDatas.length; ++i) {
                String parentLdn = columnDatas[i].toString();
                this.findChildrenAndDelete(tableHandler, parentLdn);
            }
        }
        this.logger.traceGeneral(this.loggerClass, "Mo, " + AueUtil.doubleQuote(froTypeToDelete) + ", is removed");
    }

    private void findChildrenAndDelete(TableHandler tableHandler, String parentLdn) throws CrbsAueException {
        FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsData = froVersionsTable.getDatas();
        for (int i = 0; i < froVersionsData.length; ++i) {
            String currentFroTypeName = froVersionsData[i].froTypeName;
            try {
                TableData currentTableData = tableHandler.getTableData(currentFroTypeName);
                boolean tableDataWasUpdatedFromStart = currentTableData.isTableDataUpdated();
                currentTableData.setTableDataUpdated(false);
                this.deleteChild(tableHandler, parentLdn, currentTableData);
                currentTableData.setTableDataUpdated(currentTableData.isTableDataUpdated() || tableDataWasUpdatedFromStart);
                tableHandler.checkAndDropIfNotUpdated(currentTableData);
                continue;
            }
            catch (Exception e) {
                String errorMsg = "Could not delete " + AueUtil.doubleQuote(currentFroTypeName);
                this.logger.traceDebug(this.loggerClass, AueUtil.appendReason(errorMsg, e));
                throw new CrbsAueException(errorMsg, e);
            }
        }
    }

    private void deleteChild(TableHandler tableHandler, String parentLdn, TableData childTableData) throws CrbsAueException, TableDataException {
        if (childTableData.isNotEmpty()) {
            Object[] columnDatas = childTableData.getAttributeValues("ldn");
            for (int i = columnDatas.length - 1; i >= 0; --i) {
                String ldn = columnDatas[i].toString();
                if (!parentLdn.equals(this.getParentLdn(ldn))) continue;
                childTableData.deleteRowData(i);
                this.findChildrenAndDelete(tableHandler, ldn);
            }
        }
    }
}

